/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public final class RawStore
implements RawStoreFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    private static final String BACKUP_HISTORY = "BACKUP.HISTORY";
    protected TransactionFactory xactFactory;
    protected DataFactory dataFactory;
    protected LogFactory logFactory;
    private StorageFactory storageFactory;
    private SecureRandom random;
    private boolean databaseEncrypted;
    private boolean encryptDatabase;
    private CipherProvider encryptionEngine;
    private CipherProvider decryptionEngine;
    private CipherProvider newEncryptionEngine;
    private CipherProvider newDecryptionEngine;
    private CipherFactory currentCipherFactory;
    private CipherFactory newCipherFactory = null;
    private int counter_encrypt;
    private int counter_decrypt;
    private int encryptionBlockSize = 8;
    String dataDirectory;
    protected DaemonService rawStoreDaemon;
    private int actionCode;
    private static final int FILE_WRITER_ACTION = 1;
    private StorageFile actionStorageFile;
    private StorageFile actionToStorageFile;
    private boolean actionAppend;
    private static final int REGULAR_FILE_EXISTS_ACTION = 2;
    private File actionRegularFile;
    private static final int STORAGE_FILE_EXISTS_ACTION = 3;
    private static final int REGULAR_FILE_DELETE_ACTION = 4;
    private static final int REGULAR_FILE_MKDIRS_ACTION = 5;
    private static final int REGULAR_FILE_IS_DIRECTORY_ACTION = 6;
    private static final int REGULAR_FILE_REMOVE_DIRECTORY_ACTION = 7;
    private static final int REGULAR_FILE_RENAME_TO_ACTION = 8;
    private File actionRegularFile2;
    private static final int COPY_STORAGE_DIRECTORY_TO_REGULAR_ACTION = 9;
    private byte[] actionBuffer;
    private String[] actionFilter;
    private boolean actionCopySubDirs;
    private static final int COPY_REGULAR_DIRECTORY_TO_STORAGE_ACTION = 10;
    private static final int COPY_REGULAR_FILE_TO_STORAGE_ACTION = 11;
    private static final int REGULAR_FILE_LIST_DIRECTORY_ACTION = 12;
    private static final int STORAGE_FILE_LIST_DIRECTORY_ACTION = 13;
    private static final int COPY_STORAGE_FILE_TO_REGULAR_ACTION = 14;
    private static final int REGULAR_FILE_GET_CANONICALPATH_ACTION = 15;
    private static final int STORAGE_FILE_GET_CANONICALPATH_ACTION = 16;
    private static final int COPY_STORAGE_FILE_TO_STORAGE_ACTION = 17;
    private static final int STORAGE_FILE_DELETE_ACTION = 18;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = null;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = null;

    public boolean canSupport(Properties properties) {
        return true;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        String string;
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        DaemonFactory daemonFactory = (DaemonFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        this.rawStoreDaemon = daemonFactory.createNewDaemon("rawStoreDaemon");
        this.xactFactory = (TransactionFactory)Monitor.bootServiceModule(bl, this, this.getTransactionFactoryModule(), properties);
        this.dataFactory = (DataFactory)Monitor.bootServiceModule(bl, this, this.getDataFactoryModule(), properties);
        this.storageFactory = this.dataFactory.getStorageFactory();
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty("createFrom");
            if (string2 == null) {
                string2 = properties.getProperty("restoreFrom");
            }
            if (string2 == null) {
                string2 = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (bl) {
            this.setupEncryptionEngines(bl, properties);
        }
        this.dataFactory.setRawStoreFactory(this, bl, properties);
        this.xactFactory.setRawStoreFactory(this);
        if (properties instanceof UpdateServiceProperties && this.storageFactory instanceof WritableStorageFactory) {
            ((UpdateServiceProperties)properties).setStorageFactory((WritableStorageFactory)this.storageFactory);
        }
        this.logFactory = (LogFactory)Monitor.findServiceModule(this, this.getLogFactoryModule());
        if (string2 != null) {
            this.restoreRemainingFromBackup(string2);
        }
        if ((string = properties.getProperty("logDevice")) != null) {
            if (!(this.isReadOnly() || !bl && string.equals(this.logFactory.getCanonicalLogPath()) && string2 == null)) {
                properties.put("logDevice", this.logFactory.getCanonicalLogPath());
                properties.put("derby.storage.logDeviceWhenBackedUp", this.logFactory.getCanonicalLogPath());
            }
        } else if (string2 != null && this.logFactory.getCanonicalLogPath() != null) {
            properties.put("logDevice", this.logFactory.getCanonicalLogPath());
        } else {
            properties.remove("derby.storage.logDeviceWhenBackedUp");
        }
        if (string2 != null) {
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        if (!bl) {
            if (properties.getProperty("derby.storage.databaseEncryptionStatus") != null) {
                this.handleIncompleteDatabaseEncryption(properties);
            }
            this.setupEncryptionEngines(bl, properties);
        }
        if (this.databaseEncrypted) {
            this.logFactory.setDatabaseEncrypted(false);
            this.dataFactory.setDatabaseEncrypted();
        }
        this.logFactory.recover(this, this.dataFactory, this.xactFactory);
        if (this.encryptDatabase) {
            this.configureDatabaseForEncryption(properties, this.newCipherFactory);
        }
    }

    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
        if (this.logFactory == null) {
            return;
        }
        try {
            if (this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false) && this.dataFactory != null) {
                this.dataFactory.removeStubsOK();
            }
        }
        catch (StandardException standardException) {
            this.markCorrupt(standardException);
        }
    }

    public boolean isReadOnly() {
        return this.dataFactory.isReadOnly();
    }

    public LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    public TransactionFactory getXactFactory() {
        return this.xactFactory;
    }

    public Object getXAResourceManager() throws StandardException {
        return this.xactFactory.getXAResourceManager();
    }

    public Transaction startGlobalTransaction(ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        return this.xactFactory.startGlobalTransaction(this, contextManager, n, byArray, byArray2);
    }

    public Transaction startTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startTransaction(this, contextManager, string);
    }

    public Transaction startNestedReadOnlyUserTransaction(CompatibilitySpace compatibilitySpace, ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startNestedReadOnlyUserTransaction(this, compatibilitySpace, contextManager, string);
    }

    public Transaction startNestedUpdateUserTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startNestedUpdateUserTransaction(this, contextManager, string);
    }

    public Transaction findUserTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.findUserTransaction(this, contextManager, string);
    }

    public Transaction startInternalTransaction(ContextManager contextManager) throws StandardException {
        return this.xactFactory.startInternalTransaction(this, contextManager);
    }

    public void checkpoint() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false);
    }

    public void freeze() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.dataFactory.freezePersistentStore();
        this.logFactory.freezePersistentStore();
    }

    public void unfreeze() throws StandardException {
        this.logFactory.unfreezePersistentStore();
        this.dataFactory.unfreezePersistentStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String string, boolean bl) throws StandardException {
        Object object;
        if (string == null || string.equals("")) {
            throw StandardException.newException("XSRS6.S", (Object)null);
        }
        String string2 = null;
        try {
            object = new URL(string);
            string2 = ((URL)object).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2 != null) {
            string = string2;
        }
        object = this.xactFactory.findUserTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        try {
            if (((RawTransaction)object).isBlockingBackup()) {
                throw StandardException.newException("XSRSB.S");
            }
            if (!this.xactFactory.blockBackupBlockingOperations(bl)) {
                throw StandardException.newException("XSRSA.S");
            }
            this.backup((Transaction)object, new File(string));
        }
        finally {
            this.xactFactory.unblockBackupBlockingOperations();
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void backup(Transaction transaction, File file) throws StandardException {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        if (!this.privExists(file)) {
            if (!this.privMkdirs(file)) {
                throw StandardException.newException("XSRS6.S", file);
            }
        } else {
            if (!this.privIsDirectory(file)) {
                throw StandardException.newException("XSRS1.S", file);
            }
            if (this.privExists(new File(file, "service.properties"))) {
                throw StandardException.newException("XSRSC.S", file);
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        File file2 = null;
        File file3 = null;
        OutputStreamWriter outputStreamWriter = null;
        StorageFile storageFile = null;
        File file4 = null;
        LogInstant logInstant = this.logFactory.getFirstUnflushedInstant();
        StorageFile storageFile2 = this.storageFactory.newStorageFile(null);
        String string = this.storageFactory.getCanonicalName();
        int n = string.lastIndexOf(this.storageFactory.getSeparator());
        String string2 = string.substring(n + 1);
        outputStreamWriter = this.privFileWriter(this.storageFactory.newStorageFile(BACKUP_HISTORY), true);
        file3 = new File(file, string2);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D004", string, this.getFilePath(file3)));
        if (this.privExists(file3)) {
            file2 = new File(file, string2 + ".OLD");
            if (this.privExists(file2)) {
                if (this.privIsDirectory(file2)) {
                    this.privRemoveDirectory(file2);
                } else {
                    this.privDelete(file2);
                }
            }
            if (!this.privRenameTo(file3, file2)) {
                bl3 = true;
                throw StandardException.newException("XSRS4.S", (Object)file3, (Object)file2);
            }
            this.logHistory(outputStreamWriter, MessageService.getTextMessage("D005", this.getFilePath(file3), this.getFilePath(file2)));
            bl2 = true;
        }
        if (!this.privMkdirs(file3)) {
            throw StandardException.newException("XSRS6.S", file3);
        }
        storageFile = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        if (!this.privCopyFile(storageFile, file4 = new File(file3, BACKUP_HISTORY))) {
            throw StandardException.newException("XSRS5.S", (Object)storageFile, (Object)file4);
        }
        StorageFile storageFile3 = this.storageFactory.newStorageFile("jar");
        if (this.privExists(storageFile3)) {
            object4 = this.privList(storageFile3);
            object3 = new File(file3, "jar");
            if (!this.privMkdirs((File)object3)) {
                throw StandardException.newException("XSRS6.S", object3);
            }
            for (int i = 0; i < ((String[])object4).length; ++i) {
                object2 = this.storageFactory.newStorageFile(storageFile3, object4[i]);
                if (this.privCopyDirectory((StorageFile)object2, (File)(serializable = new File((File)object3, (String)object4[i])), null, null, false)) continue;
                throw StandardException.newException("XSRS5.S", object2, (Object)serializable);
            }
        }
        object4 = this.logFactory.getLogDirectory();
        try {
            object3 = Monitor.getMonitor().getServiceName(this);
            object = Monitor.getMonitor().getServiceType(this);
            object2 = object.getCanonicalServiceName((String)object3);
            serializable = object.getServiceProperties((String)object2, null);
            StorageFile storageFile4 = this.storageFactory.newStorageFile("log");
            if (!object4.equals(storageFile4)) {
                serializable.remove("logDevice");
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D007"));
            }
            object.saveServiceProperties(file3.getPath(), (Properties)serializable, false);
        }
        catch (StandardException standardException) {
            this.logHistory(outputStreamWriter, MessageService.getTextMessage("D008") + standardException);
            Object var24_26 = null;
            try {
                if (bl) {
                    this.logFactory.abortLogBackup();
                    if (!bl3) {
                        this.privRemoveDirectory(file3);
                    }
                    if (bl2) {
                        this.privRenameTo(file2, file3);
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
                } else {
                    if (bl2 && this.privExists(file2)) {
                        this.privRemoveDirectory(file2);
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", this.getFilePath(file2)));
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                    if (!this.privCopyFile(storageFile, file4)) {
                        throw StandardException.newException("XSRS5.S", (Object)storageFile, (Object)file4);
                    }
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", iOException);
            }
            return;
        }
        object3 = this.storageFactory.newStorageFile("verifyKey.dat");
        if (this.privExists((StorageFile)object3) && !this.privCopyFile((StorageFile)object3, (File)(object = new File(file3, "verifyKey.dat")))) {
            throw StandardException.newException("XSRS5.S", object3, object);
        }
        object = new File(file3, "log");
        if (this.privExists((File)object)) {
            this.privRemoveDirectory((File)object);
        }
        if (!this.privMkdirs((File)object)) {
            throw StandardException.newException("XSRS6.S", object);
        }
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.startLogBackup((File)object);
        object2 = new File(file3, "seg0");
        if (!this.privMkdirs((File)object2)) {
            throw StandardException.newException("XSRS6.S", object2);
        }
        this.dataFactory.backupDataFiles(transaction, (File)object2);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D006", this.getFilePath((File)object2)));
        this.logFactory.endLogBackup((File)object);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D009", this.getFilePath((StorageFile)object4), this.getFilePath((File)object)));
        bl = false;
        Object var24_27 = null;
        try {
            if (bl) {
                this.logFactory.abortLogBackup();
                if (!bl3) {
                    this.privRemoveDirectory(file3);
                }
                if (bl2) {
                    this.privRenameTo(file2, file3);
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
            } else {
                if (bl2 && this.privExists(file2)) {
                    this.privRemoveDirectory(file2);
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", this.getFilePath(file2)));
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                if (!this.privCopyFile(storageFile, file4)) {
                    throw StandardException.newException("XSRS5.S", (Object)storageFile, (Object)file4);
                }
            }
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw StandardException.newException("XSRS7.S", iOException);
        }
        {
            catch (IOException iOException) {
                throw StandardException.newException("XSRS7.S", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var24_28 = null;
            try {
                if (bl) {
                    this.logFactory.abortLogBackup();
                    if (!bl3) {
                        this.privRemoveDirectory(file3);
                    }
                    if (bl2) {
                        this.privRenameTo(file2, file3);
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
                } else {
                    if (bl2 && this.privExists(file2)) {
                        this.privRemoveDirectory(file2);
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", this.getFilePath(file2)));
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                    if (!this.privCopyFile(storageFile, file4)) {
                        throw StandardException.newException("XSRS5.S", storageFile, file4);
                    }
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", iOException);
            }
            throw throwable;
        }
    }

    public void backupAndEnableLogArchiveMode(String string, boolean bl, boolean bl2) throws StandardException {
        boolean bl3 = false;
        try {
            if (!this.logFactory.logArchived()) {
                this.logFactory.enableLogArchiveMode();
                bl3 = true;
            }
            this.backup(string, bl2);
            if (bl) {
                this.logFactory.deleteOnlineArchivedLogFiles();
            }
        }
        catch (Throwable throwable) {
            if (bl3) {
                this.logFactory.disableLogArchiveMode();
            }
            throw StandardException.plainWrapException(throwable);
        }
    }

    public void disableLogArchiveMode(boolean bl) throws StandardException {
        this.logFactory.disableLogArchiveMode();
        if (bl) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void restoreRemainingFromBackup(String string) throws StandardException {
        File file = new File(string, "jar");
        StorageFile storageFile = this.storageFactory.newStorageFile("jar");
        if (!this.privExists(storageFile) && this.privExists(file) && !this.privCopyDirectory(file, storageFile)) {
            throw StandardException.newException("XBM0Z.D", (Object)file, (Object)storageFile);
        }
        StorageFile storageFile2 = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        File file2 = new File(string, BACKUP_HISTORY);
        if (!this.privExists(storageFile2) && !this.privCopyFile(file2, storageFile2)) {
            throw StandardException.newException("XSRS5.S", (Object)file2, (Object)storageFile2);
        }
    }

    public void idle() throws StandardException {
        this.dataFactory.idle();
    }

    public TransactionInfo[] getTransactionInfo() {
        return this.xactFactory.getTransactionInfo();
    }

    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return this.logFactory.openFlushedScan(databaseInstant, n);
    }

    public DaemonService getDaemon() {
        return this.rawStoreDaemon;
    }

    public void createFinished() throws StandardException {
        this.xactFactory.createFinished();
        this.dataFactory.createFinished();
    }

    public void getRawStoreProperties(PersistentSet persistentSet) throws StandardException {
        this.logFactory.getLogFactoryProperties(persistentSet);
    }

    public void freezePersistentStore() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.freezePersistentStore();
    }

    public void unfreezePersistentStore() throws StandardException {
        this.logFactory.unfreezePersistentStore();
    }

    private void setupEncryptionEngines(boolean bl, Properties properties) throws StandardException {
        Object object;
        String string = properties.getProperty("dataEncryption");
        this.databaseEncrypted = Boolean.valueOf(string);
        boolean bl2 = false;
        if (!bl) {
            String string2;
            String string3 = Monitor.getMonitor().getServiceName(this);
            object = Monitor.getMonitor().getServiceType(this);
            Properties properties2 = object.getServiceProperties(string2 = object.getCanonicalServiceName(string3), null);
            string = properties2.getProperty("dataEncryption");
            boolean bl3 = Boolean.valueOf(string);
            if (!bl3 && this.databaseEncrypted) {
                this.encryptDatabase = true;
                this.databaseEncrypted = false;
            } else if (bl3) {
                if (properties.getProperty("newBootPassword") != null) {
                    bl2 = true;
                } else if (properties.getProperty("newEncryptionKey") != null) {
                    bl2 = true;
                }
                this.encryptDatabase = bl2;
            }
            if (this.encryptDatabase && this.isReadOnly()) {
                if (bl2) {
                    throw StandardException.newException("XBCXR.S");
                }
                throw StandardException.newException("XBCXQ.S");
            }
        }
        if (this.databaseEncrypted || this.encryptDatabase) {
            boolean bl4 = bl || this.encryptDatabase && !bl2;
            object = (CipherFactoryBuilder)Monitor.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
            this.currentCipherFactory = object.createCipherFactory(bl4, properties, false);
            this.currentCipherFactory.verifyKey(bl4, this.storageFactory, properties);
            this.encryptionEngine = this.currentCipherFactory.createNewCipher(1);
            if (bl4) {
                this.encryptionBlockSize = this.encryptionEngine.getEncryptionBlockSize();
                if (bl) {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
            } else {
                this.encryptionBlockSize = properties.getProperty("derby.encryptionBlockSize") != null ? Integer.parseInt(properties.getProperty("derby.encryptionBlockSize")) : this.encryptionEngine.getEncryptionBlockSize();
            }
            this.decryptionEngine = this.currentCipherFactory.createNewCipher(2);
            this.random = this.currentCipherFactory.getSecureRandom();
            if (this.encryptDatabase) {
                if (bl2) {
                    this.newCipherFactory = object.createCipherFactory(bl4, properties, true);
                    this.newDecryptionEngine = this.newCipherFactory.createNewCipher(2);
                    this.newEncryptionEngine = this.newCipherFactory.createNewCipher(1);
                } else {
                    this.newDecryptionEngine = this.decryptionEngine;
                    this.newEncryptionEngine = this.encryptionEngine;
                }
            }
            if (bl) {
                this.currentCipherFactory.saveProperties(properties);
            }
        }
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws StandardException {
        if (!this.databaseEncrypted && !this.encryptDatabase || this.encryptionEngine == null && this.newEncryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_encrypt;
        if (bl) {
            return this.newEncryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
        }
        return this.encryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        if (!this.databaseEncrypted || this.decryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_decrypt;
        return this.decryptionEngine.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    public int random() {
        return this.databaseEncrypted ? this.random.nextInt() : 0;
    }

    public Serializable changeBootPassword(Properties properties, Serializable serializable) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XBCX9.S");
        }
        if (!this.databaseEncrypted) {
            throw StandardException.newException("XBCX8.S");
        }
        if (serializable == null) {
            throw StandardException.newException("XBCX5.S");
        }
        if (!(serializable instanceof String)) {
            throw StandardException.newException("XBCX6.S");
        }
        String string = (String)((Object)serializable);
        return this.currentCipherFactory.changeBootPassword((String)((Object)serializable), properties, this.encryptionEngine);
    }

    private void crashOnDebugFlag(String string, boolean bl) throws StandardException {
    }

    public void configureDatabaseForEncryption(Properties properties, CipherFactory cipherFactory) throws StandardException {
        boolean bl = this.databaseEncrypted && this.encryptDatabase;
        this.canEncryptDatabase(bl);
        boolean bl2 = false;
        if (properties.getProperty("encryptionKey") != null) {
            bl2 = true;
        }
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        RawTransaction rawTransaction = this.xactFactory.startTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        try {
            Object object;
            this.dataFactory.encryptAllContainers(rawTransaction);
            if (!this.logFactory.isCheckpointInLastLogFile()) {
                this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            }
            this.encryptDatabase = false;
            this.logFactory.setDatabaseEncrypted(true);
            if (!bl) {
                this.databaseEncrypted = true;
                this.dataFactory.setDatabaseEncrypted();
            } else {
                this.decryptionEngine = this.newDecryptionEngine;
                this.encryptionEngine = this.newEncryptionEngine;
                this.currentCipherFactory = cipherFactory;
            }
            this.logFactory.startNewLogFile();
            properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(1));
            if (bl) {
                if (bl2) {
                    StorageFile storageFile;
                    object = this.storageFactory.newStorageFile("verifyKey.dat");
                    if (!this.privCopyFile((StorageFile)object, storageFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
                        throw StandardException.newException("XSRS5.S", object, (Object)storageFile);
                    }
                    this.currentCipherFactory.verifyKey(bl, this.storageFactory, properties);
                } else {
                    object = properties.getProperty("encryptedBootPassword");
                    if (object != null) {
                        properties.put("OldEncryptedBootPassword", object);
                    }
                }
            } else {
                properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
            }
            this.currentCipherFactory.saveProperties(properties);
            rawTransaction.commit();
            this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(3));
            this.dataFactory.removeOldVersionOfContainers(false);
            if (bl) {
                if (bl2) {
                    object = this.storageFactory.newStorageFile("verifyOldKey.dat");
                    if (!this.privDelete((StorageFile)object)) {
                        throw StandardException.newException("XBM0R.D", object);
                    }
                } else {
                    properties.remove("OldEncryptedBootPassword");
                }
            }
            properties.remove("derby.storage.databaseEncryptionStatus");
            rawTransaction.close();
        }
        catch (StandardException standardException) {
            throw StandardException.newException(bl ? "XBCXV.S" : "XBCXU.S", standardException, (Object)standardException.getMessage());
        }
        finally {
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
        }
    }

    public void handleIncompleteDatabaseEncryption(Properties properties) throws StandardException {
        StorageFile storageFile;
        int n = 0;
        String string = properties.getProperty("derby.storage.databaseEncryptionStatus");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        boolean bl = false;
        if (n == 1) {
            if (this.logFactory.isCheckpointInLastLogFile()) {
                n = 3;
            } else {
                n = 2;
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(n));
            }
        }
        if (n == 2) {
            this.logFactory.deleteLogFileAfterCheckpointLogFile();
            storageFile = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists(storageFile)) {
                StorageFile storageFile2 = this.storageFactory.newStorageFile("verifyOldKey.dat");
                if (this.privExists(storageFile2)) {
                    if (!this.privCopyFile(storageFile2, storageFile)) {
                        throw StandardException.newException("XSRS5.S", (Object)storageFile2, (Object)storageFile);
                    }
                    bl = true;
                } else if (!this.privDelete(storageFile)) {
                    throw StandardException.newException("XBM0R.D", storageFile);
                }
            } else {
                String string2 = properties.getProperty("OldEncryptedBootPassword");
                if (string2 != null) {
                    properties.put("encryptedBootPassword", string2);
                    bl = true;
                }
            }
            if (!bl) {
                properties.remove("dataEncryption");
                properties.remove("log_encrypt_algorithm_version");
                properties.remove("data_encrypt_algorithm_version");
                properties.remove("derby.encryptionBlockSize");
                properties.remove("encryptionKeyLength");
                properties.remove("encryptionProvider");
                properties.remove("encryptionAlgorithm");
                properties.remove("encryptedBootPassword");
            }
        }
        if (n == 3) {
            this.dataFactory.removeOldVersionOfContainers(true);
        }
        if (this.privExists(storageFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
            if (!this.privDelete(storageFile)) {
                throw StandardException.newException("XBM0R.D", storageFile);
            }
        } else {
            properties.remove("OldEncryptedBootPassword");
        }
        properties.remove("derby.storage.databaseEncryptionStatus");
    }

    private void canEncryptDatabase(boolean bl) throws StandardException {
        String string = bl ? "newBootPassword/newEncryptionKey attribute" : "dataEncryption attribute on an existing database";
        this.logFactory.checkVersion(10, 2, string);
        if (this.xactFactory.hasPreparedXact()) {
            if (bl) {
                throw StandardException.newException("XBCXP.S");
            }
            throw StandardException.newException("XBCXO.S");
        }
        if (this.logFactory.logArchived()) {
            if (bl) {
                throw StandardException.newException("XBCXT.S");
            }
            throw StandardException.newException("XBCXS.S");
        }
    }

    public StandardException markCorrupt(StandardException standardException) {
        this.logFactory.markCorrupt(standardException);
        this.dataFactory.markCorrupt(standardException);
        this.xactFactory.markCorrupt(standardException);
        return standardException;
    }

    public String getTransactionFactoryModule() {
        return "org.apache.derby.iapi.store.raw.xact.TransactionFactory";
    }

    public String getDataFactoryModule() {
        return "org.apache.derby.iapi.store.raw.data.DataFactory";
    }

    public String getLogFactoryModule() {
        return "org.apache.derby.iapi.store.raw.log.LogFactory";
    }

    private void logHistory(OutputStreamWriter outputStreamWriter, String string) throws IOException {
        Date date = new Date();
        outputStreamWriter.write(date.toString() + ":" + string + "\n");
        outputStreamWriter.flush();
    }

    private String getFilePath(StorageFile storageFile) {
        String string = this.privGetCanonicalPath(storageFile);
        if (string != null) {
            return string;
        }
        return storageFile.getPath();
    }

    private String getFilePath(File file) {
        String string = this.privGetCanonicalPath(file);
        if (string != null) {
            return string;
        }
        return file.getPath();
    }

    protected boolean privCopyDirectory(StorageFile storageFile, File file) {
        return this.privCopyDirectory(storageFile, file, null, null, true);
    }

    protected boolean privCopyDirectory(File file, StorageFile storageFile) {
        return this.privCopyDirectory(file, storageFile, null, null);
    }

    public long getMaxContainerId() throws StandardException {
        return this.dataFactory.getMaxContainerId();
    }

    public boolean checkVersion(int n, int n2, String string) throws StandardException {
        return this.logFactory.checkVersion(n, n2, string);
    }

    private synchronized OutputStreamWriter privFileWriter(StorageFile storageFile, boolean bl) throws IOException {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        this.actionAppend = bl;
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)AccessController.doPrivileged(this);
            return outputStreamWriter;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(File file) {
        this.actionCode = 2;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(File file) {
        this.actionCode = 4;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 18;
        this.actionStorageFile = storageFile;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privMkdirs(File file) {
        this.actionCode = 5;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privIsDirectory(File file) {
        this.actionCode = 6;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRemoveDirectory(File file) {
        this.actionCode = 7;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRenameTo(File file, File file2) {
        this.actionCode = 8;
        this.actionRegularFile = file;
        this.actionRegularFile2 = file2;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
            this.actionRegularFile2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(StorageFile storageFile, File file, byte[] byArray, String[] stringArray, boolean bl) {
        this.actionCode = 9;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        this.actionCopySubDirs = bl;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl2 = (Boolean)t;
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        this.actionCode = 10;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.actionCode = 11;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile storageFile, File file) {
        this.actionCode = 14;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile storageFile, StorageFile storageFile2) {
        this.actionCode = 17;
        this.actionStorageFile = storageFile;
        this.actionToStorageFile = storageFile2;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionToStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(File file) {
        this.actionCode = 12;
        this.actionRegularFile = file;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            return stringArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(StorageFile storageFile) {
        this.actionCode = 13;
        this.actionStorageFile = storageFile;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            return stringArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String privGetCanonicalPath(StorageFile storageFile) {
        this.actionCode = 16;
        this.actionStorageFile = storageFile;
        try {
            String string = (String)AccessController.doPrivileged(this);
            return string;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string = null;
            return string;
        }
        catch (SecurityException securityException) {
            String string = null;
            return string;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String privGetCanonicalPath(File file) {
        this.actionCode = 15;
        this.actionRegularFile = file;
        try {
            String string = (String)AccessController.doPrivileged(this);
            return string;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string = null;
            return string;
        }
        catch (SecurityException securityException) {
            String string = null;
            return string;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    public final Object run() throws IOException {
        switch (this.actionCode) {
            case 1: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(this.actionAppend));
            }
            case 2: {
                return ReuseFactory.getBoolean(this.actionRegularFile.exists());
            }
            case 3: {
                return ReuseFactory.getBoolean(this.actionStorageFile.exists());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.actionRegularFile.delete());
            }
            case 18: {
                return ReuseFactory.getBoolean(this.actionStorageFile.delete());
            }
            case 5: {
                return ReuseFactory.getBoolean(this.actionRegularFile.mkdirs());
            }
            case 6: {
                return ReuseFactory.getBoolean(this.actionRegularFile.isDirectory());
            }
            case 7: {
                return ReuseFactory.getBoolean(FileUtil.removeDirectory(this.actionRegularFile));
            }
            case 8: {
                return ReuseFactory.getBoolean(this.actionRegularFile.renameTo(this.actionRegularFile2));
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory(this.storageFactory, this.actionStorageFile, this.actionRegularFile, this.actionBuffer, this.actionFilter, this.actionCopySubDirs));
            }
            case 10: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile, this.actionBuffer, this.actionFilter));
            }
            case 11: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile));
            }
            case 12: {
                return this.actionRegularFile.list();
            }
            case 13: {
                return this.actionStorageFile.list();
            }
            case 14: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((StorageFactory)((WritableStorageFactory)this.storageFactory), this.actionStorageFile, this.actionRegularFile));
            }
            case 17: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionStorageFile, this.actionToStorageFile));
            }
            case 15: {
                return this.actionRegularFile.getCanonicalPath();
            }
            case 16: {
                return this.actionStorageFile.getCanonicalPath();
            }
        }
        return null;
    }
}

