#ifndef TAG_LIST_H__
#define TAG_LIST_H__

#include <jni.h>

typedef struct tag_list {
    jlong clz_tag;
    jint size;
    jint next_pos;
    jlong* tags;
} tag_list;

/** setup a tag_list 
 * @param so a pointer to a tag_list.
 * @param clz the class that the tag list is for, use NULL for unspecified.
 */
void setup_tag_list (JNIEnv* env, tag_list* tl, jclass clz);

void cleanup_tag_list (tag_list* tl);

/** Add a tag to the list. 
 *  This method will expand the list if it needs to.
 */
void add_tag (tag_list* tl, jlong tag);

#endif /* TAG_LIST_H__ */
