//
// Automatically generated by skel. Modify at your own risk.

#include "adios.h"
#include "mpi.h"
#include "skel/skel_xml_output.h"
#include <stdlib.h>
#include <stdio.h>

int main (int argc, char ** argv)
{

MPI_Init (&argc, &argv);

double skel_init_timer = 0;
double skel_open_timer = 0;
double skel_access_timer = 0;
double skel_close_timer = 0;
double skel_total_timer = 0;

// Time the init
MPI_Barrier (MPI_COMM_WORLD);
skel_init_timer -= MPI_Wtime();

adios_init ("picongpu_skel.xml", MPI_WORLD_COMM);
skel_init_timer += MPI_Wtime();

int skel_mpi_size, skel_mpi_rank, skel_i;
uint64_t adios_groupsize;
MPI_Comm_rank (MPI_COMM_WORLD, &skel_mpi_rank);
MPI_Comm_size (MPI_COMM_WORLD, &skel_mpi_size);

int64_t adios_handle;
uint64_t skel_total_size;

// Scalar declarations
int total_size_x;
int total_size_y;
int size_z;
int total_size_z;
int npz;
int offset_z;
int npy;
int offset_y;
int offset_x;
int npx;
int size_x;
int iter;
int size_y;
iter = 1;
npx = 8;
npy = 8;
npz = 8;
size_x = 64;
size_y = 64;
size_z = 64;
total_size_x = npx*size_x;
total_size_y = npy*size_y;
total_size_z = npz*size_z;
offset_x = size_z*(skel_mpi_rank/(npx*npy));
offset_y = size_y*((skel_mpi_rank/npx)%npy);
offset_z = size_x*(skel_mpi_rank%npx);

// Array declarations

float * t;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;
t = (float*) malloc (size_x*size_y*size_z * sizeof (float) );
for (skel_i = 0; skel_i < size_x*size_y*size_z; skel_i++) 
    t[skel_i] = (float) skel_mpi_rank;

for (skel_i = 0; skel_i < 1; skel_i++){

// Time the opens
MPI_Barrier (MPI_COMM_WORLD);
skel_open_timer -= MPI_Wtime();
skel_total_timer -= MPI_Wtime();
MPI_Comm comm = MPI_COMM_WORLD;
adios_open(&adios_handle, "fields", "out_fields_write.bp", "w", comm);
skel_open_timer += MPI_Wtime();

// Time the writes
skel_access_timer -= MPI_Wtime();

// Set the adios group size
adios_groupsize =
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 +
                     4 * (size_x) * (size_y) * (size_z) +
                     4 * (size_x) * (size_y) * (size_z) +
                     4 * (size_x) * (size_y) * (size_z) +
                     4 * (size_x) * (size_y) * (size_z) +
                     4 * (size_x) * (size_y) * (size_z) +
                     4 * (size_x) * (size_y) * (size_z) +
                     4 * (size_x) * (size_y) * (size_z) ;
adios_group_size (adios_handle, adios_groupsize, &skel_total_size);

// Write each variable
adios_write (adios_handle, "iter", &iter);
adios_write (adios_handle, "npx", &npx);
adios_write (adios_handle, "npy", &npy);
adios_write (adios_handle, "npz", &npz);
adios_write (adios_handle, "size_x", &size_x);
adios_write (adios_handle, "size_y", &size_y);
adios_write (adios_handle, "size_z", &size_z);
adios_write (adios_handle, "total_size_x", &total_size_x);
adios_write (adios_handle, "total_size_y", &total_size_y);
adios_write (adios_handle, "total_size_z", &total_size_z);
adios_write (adios_handle, "offset_x", &offset_x);
adios_write (adios_handle, "offset_y", &offset_y);
adios_write (adios_handle, "offset_z", &offset_z);
adios_write (adios_handle, "fields_FieldE_x", t);
adios_write (adios_handle, "fields_FieldE_y", t);
adios_write (adios_handle, "fields_FieldE_z", t);
adios_write (adios_handle, "fields_FieldB_x", t);
adios_write (adios_handle, "fields_FieldB_y", t);
adios_write (adios_handle, "fields_FieldB_z", t);
adios_write (adios_handle, "fields_Density_e", t);

// Stop timing the writes
skel_access_timer += MPI_Wtime();

// Time the closes
skel_close_timer -= MPI_Wtime();
adios_close (adios_handle);
skel_close_timer += MPI_Wtime();}
skel_total_timer += MPI_Wtime();

// Output results

 skel_write_coarse_xml_data ();
double skel_total_init, skel_total_open, skel_total_access, skel_total_close, skel_total_total;
MPI_Reduce (&skel_init_timer, &skel_total_init, 1, MPI_DOUBLE, MPI_MAX, 0, MPI_COMM_WORLD);
MPI_Reduce (&skel_open_timer, &skel_total_open, 1, MPI_DOUBLE, MPI_MAX, 0, MPI_COMM_WORLD);
MPI_Reduce (&skel_access_timer, &skel_total_access, 1, MPI_DOUBLE, MPI_MAX, 0, MPI_COMM_WORLD);
MPI_Reduce (&skel_close_timer, &skel_total_close, 1, MPI_DOUBLE, MPI_MAX, 0, MPI_COMM_WORLD);
MPI_Reduce (&skel_total_timer, &skel_total_total, 1, MPI_DOUBLE, MPI_MAX, 0, MPI_COMM_WORLD);
if (skel_mpi_rank == 0) {
    fprintf (stdout, "\n");
    fprintf (stdout, "\n*************************");
    fprintf (stdout, "\n   Groupsize: %lli", adios_groupsize);
    fprintf (stdout, "\n  Open Time: %f", skel_total_open);
    fprintf (stdout, "\nAccess Time: %f", skel_total_access);
    fprintf (stdout, "\n Close Time: %f", skel_total_close);
    fprintf (stdout, "\n Total Time: %f", skel_total_total);
    fprintf (stdout, "\n*************************");
    fprintf (stdout, "\n");
}

// Free the arrays
free (t);

// Clean up
adios_finalize(0);
MPI_Finalize();
}
