// Copyright(c) 2005, Rodrigo Braz Monteiro
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of the Aegisub Group nor the names of its contributors
//     may be used to endorse or promote products derived from this software
//     without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// Aegisub Project http://www.aegisub.org/
//
// $Id$

/// @file dialog_style_editor.h
/// @see dialog_style_editor.cpp
/// @ingroup style_editor
///

#ifndef AGI_PRE
#include <wx/checkbox.h>
#include <wx/combobox.h>
#include <wx/radiobox.h>
#include <wx/spinctrl.h>
#include <wx/textctrl.h>
#endif

#include <libaegisub/scoped_ptr.h>

namespace agi { struct Context; }
class AssStyle;
class AssStyleStorage;
class ColourButton;
class PersistLocation;
class SubtitlesPreview;

/// DOCME
/// @class DialogStyleEditor
/// @brief DOCME
///
/// DOCME
class DialogStyleEditor : public wxDialog {
	agi::Context *c;
	agi::scoped_ptr<PersistLocation> persist;

	/// If true, the style was just created and so the user should not be
	/// asked if they want to change any existing lines should they rename
	/// the style
	bool is_new;

	/// DOCME
	AssStyle *style;

	/// DOCME
	agi::scoped_ptr<AssStyle> work;

	/// DOCME
	AssStyleStorage *store;

	/// DOCME
	wxTextCtrl *StyleName;

	/// DOCME
	wxComboBox *FontName;

	/// DOCME
	wxTextCtrl *FontSize;

	/// DOCME
	wxCheckBox *BoxBold;

	/// DOCME
	wxCheckBox *BoxItalic;

	/// DOCME
	wxCheckBox *BoxUnderline;

	/// DOCME
	wxCheckBox *BoxStrikeout;

	/// DOCME
	ColourButton *colorButton[4];

	/// DOCME
	wxSpinCtrl *colorAlpha[4];

	/// DOCME
	wxSpinCtrl *margin[4];

	/// DOCME
	wxRadioBox *Alignment;

	/// DOCME
	wxTextCtrl *Outline;

	/// DOCME
	wxTextCtrl *Shadow;

	/// DOCME
	wxCheckBox *OutlineType;

	/// DOCME
	wxTextCtrl *ScaleX;

	/// DOCME
	wxTextCtrl *ScaleY;

	/// DOCME
	wxTextCtrl *Angle;

	/// DOCME
	wxComboBox *Encoding;

	/// DOCME
	wxTextCtrl *Spacing;

	/// DOCME
	wxTextCtrl *PreviewText;

	/// DOCME
	SubtitlesPreview *SubsPreview;

	void SetBitmapColor(int n,wxColour color);
	int AlignToControl(int n);
	int ControlToAlign(int n);
	void UpdateWorkStyle();

	void OnChildFocus(wxChildFocusEvent &event);
	void OnCommandPreviewUpdate(wxCommandEvent &event);

	void OnPreviewTextChange(wxCommandEvent &event);
	void OnPreviewColourChange(wxCommandEvent &event);

	/// @brief Maybe apply changes and maybe close the dialog
	/// @param apply Should changes be applied?
	/// @param close Should the dialog be closed?
	void Apply(bool apply,bool close);
	void OnSetColor(int n, wxCommandEvent& evt);

public:
	DialogStyleEditor(wxWindow *parent, AssStyle *style, agi::Context *c, AssStyleStorage *store = 0, wxString const& new_name = "");
	~DialogStyleEditor();

	wxString GetStyleName() const;
};
