// ---------------------------------------------------------------------------
// - Libcsm.cpp                                                              -
// - afnix:csm module - declaration & implementation                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Locos.hpp"
#include "Libcsm.hpp"
#include "Predcsm.hpp"
#include "Function.hpp"
#include "Assistant.hpp"

namespace afnix {

  // initialize the afnix:csm module

  Object* init_afnix_csm (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the afnix:csm nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* gset = aset->mknset   ("csm");

    // bind all symbols in the afnix:csm nameset
    gset->symcst ("Rco",         new Meta (Rco::mknew));
    gset->symcst ("Slot",        new Meta (Slot::mknew));
    gset->symcst ("Locos",       new Meta (Locos::mknew));
    gset->symcst ("Appointer",   new Meta (Appointer::mknew));
    gset->symcst ("Assistant",   new Meta (Assistant::mknew));

    // bind the predicates
    gset->symcst ("rco-p",       new Function (csm_rcop));
    gset->symcst ("slot-p",      new Function (csm_slotp));
    gset->symcst ("locos-p",     new Function (csm_cosp));
    gset->symcst ("appointer-p", new Function (csm_apptp));
    gset->symcst ("assistant-p", new Function (csm_asstp));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_csm (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_csm (interp, argv);
  }
}
