// ---------------------------------------------------------------------------
// - AsnNode.hxx                                                             -
// - afnix:itu module - asn global private definitions                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CCNF_HPP
#include "ccnf.hpp"
#endif

#ifndef AFNIX_ASNNODE_HXX
#define AFNIX_ASNNODE_HXX

namespace afnix {

  // the identifier octet class mask
  static const t_byte ASN_MASK_CLS  = 0xC0;
  // the identifier octet constructed flag mask
  static const t_byte ASN_MASK_CFL  = 0x20;
  // the identifier octet tag mask
  static const t_byte ASN_MASK_TAG  = 0x1F;

  // the universal class encoding
  static const t_byte ASN_UNIV_CLS  = 0x00;
  // the application class encoding
  static const t_byte ASN_APPL_CLS  = 0x40;
  // the context specific class encoding
  static const t_byte ASN_CTXS_CLS  = 0x80;
  // the private class encoding
  static const t_byte ASN_PRIV_CLS  = 0xC0;

  // the constructed flag
  static const t_byte ASN_CONS_CLS  = 0x20;
  // the long tag number encoding
  static const t_byte ASN_LTAG_BIN  = 0x1F;
  // the indefinite length encoding
  static const t_byte ASN_ILEN_BIN  = 0x80;

  // the universal tag
  static const t_octa ASN_UNIV_BOOL = 0x0000000000000001ULL; // boolean
  static const t_octa ASN_UNIV_INTG = 0x0000000000000002ULL; // integer
  static const t_octa ASN_UNIV_BITS = 0x0000000000000003ULL; // bit string
  static const t_octa ASN_UNIV_OCTS = 0x0000000000000004ULL; // octet string
  static const t_octa ASN_UNIV_NULL = 0x0000000000000005ULL; // null
  static const t_octa ASN_UNIV_OIDN = 0x0000000000000006ULL; // oid
  static const t_octa ASN_UNIV_ODES = 0x0000000000000007ULL; // descriptor
  static const t_octa ASN_UNIV_INST = 0x0000000000000008ULL; // instance-of
  static const t_octa ASN_UNIV_REAL = 0x0000000000000009ULL; // real
  static const t_octa ASN_UNIV_ENUM = 0x000000000000000AULL; // enumeration
  static const t_octa ASN_UNIV_EPDV = 0x000000000000000BULL; // pdv
  static const t_octa ASN_UNIV_UTFS = 0x000000000000000CULL; // utf string
  static const t_octa ASN_UNIV_ROID = 0x000000000000000DULL; // roid
  static const t_octa ASN_UNIV_SEQO = 0x0000000000000010ULL; // sequence
  static const t_octa ASN_UNIV_SETO = 0x0000000000000011ULL; // set
  static const t_octa ASN_UNIV_NUMS = 0x0000000000000012ULL; // numeric string
  static const t_octa ASN_UNIV_PRTS = 0x0000000000000013ULL; // printable string
  static const t_octa ASN_UNIV_TLXS = 0x0000000000000014ULL; // teletex string
  static const t_octa ASN_UNIV_VIDS = 0x0000000000000015ULL; // videotex string
  static const t_octa ASN_UNIV_IA5S = 0x0000000000000016ULL; // IA5 string
  static const t_octa ASN_UNIV_UTCS = 0x0000000000000017ULL; // UTC time
  static const t_octa ASN_UNIV_GTMS = 0x0000000000000018ULL; // generalized time
  static const t_octa ASN_UNIV_GRPS = 0x0000000000000019ULL; // graphic string
  static const t_octa ASN_UNIV_VISS = 0x000000000000001AULL; // visible string
  static const t_octa ASN_UNIV_GENS = 0x000000000000001BULL; // general string
  static const t_octa ASN_UNIV_UNVS = 0x000000000000001CULL; // univers string 
  static const t_octa ASN_UNIV_BMPS = 0x000000000000001EULL; // BMP string 
}

#endif
