//network.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_NETWORK_H_
#define _AROARFW_NETWORK_H_

//! Possible socket types
typedef enum {
 //! None, not set, unknown, invalid
 RSOCKETTYPE_NONE             =  0,
 //! TCP Socket
 RSOCKETTYPE_TCP              =  1,
 //! UNIX Socket
 RSOCKETTYPE_UNIX             =  2,
 //! Fork (internal use only)
 RSOCKETTYPE_FORK             =  3,
 //! Normal file (may be specal device, too, everything open() works on)
 RSOCKETTYPE_FILE             =  4,
 //! UDP
 RSOCKETTYPE_UDP              =  5,
 //! Generic stream
 RSOCKETTYPE_GENSTR           =  6,
 //! DECnet
 RSOCKETTYPE_DECNET           =  7,
 //! TCP6
 RSOCKETTYPE_TCP6             =  8,
 //! UDP6
 RSOCKETTYPE_UDP6             =  9,
 //! IPX/SPX
 RSOCKETTYPE_IPXSPX           = 10,
 //! Plain IPX
 RSOCKETTYPE_IPX              = 11,
 //! LAT Service
 RSOCKETTYPE_LAT_SERVICE      = 12,
 //! LAT reverse port
 RSOCKETTYPE_LAT_REVERSE_PORT = 13
} rsocktype_t;

//! Possible socket modes
typedef enum {
 // Listen Socket
 RSOCKMODE_LISTEN  = 1,
 // Normal client socket
 RSOCKMODE_CONNECT = 2
} rsockmode_t;

//! Default RoarAudio port for TCP/IP
#define RDEFAULT_PORT   16002

//! Default RoarAudio Host
#define RDEFAULT_HOST   "localhost"

//! Default RoarAudio global socket filename
#define RDEFAULT_GSOCK  "/tmp/roar"

/** \brief Default RoarAudio user socket filename

 Tilde (~) at the begining of the string needs to be replaced by
 the user's home directory. This is normaly stored in $HOME.
*/
#define RDEFAULT_USOCK  "~/.roar"

//! Default RoarAudio DECnet object
#define RDEFAULT_OBJECT "roar"

#endif

//ll
