// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __reg_comp__
#define __reg_comp__

// Makes regular expression matching possible.

#include <stddef.h>
#include <stdlib.h>
#include <sys/types.h> // for cygwin compilation (must be before regex.h!)
#include <regex.h>

#include "Puma/ErrorStream.h"

namespace Puma {


class RegComp {
  const char *_expr;      // The regular expression.
  regex_t     _compiled;  // The compiled regular expression (faster!).
  int         _cerror;    // Error during compilation.
  int         _eerror;    // Error during comparison.
  int         _cflags;    // Compile flags.
        
public:
  // Constructor: Compile the regular expression.
  RegComp (const char *expr, int cflags = REG_EXTENDED | REG_NOSUB);
  RegComp (RegComp &);

  // Destructor: Free the storage used by the regex_t structure.
  ~RegComp () { regfree (&_compiled); delete[] _expr; }
        
  // Compile the regular expression.
  bool compile (const char *expr, int cflags = REG_EXTENDED | REG_NOSUB);

  // Match against a string.
  bool match (const char *string, int eflags = 0);
        
  // To be called on errors.
  void comperror (ErrorStream &) const;
};
 
 
} // namespace Puma

#endif /* __reg_comp__ */
