// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_stream_h__
#define __error_stream_h__

// An ErrorStream is a special ErrorSink that prints out an error message
// as soon as it complete. It also stores the maximum error severity.
// The ErrorStream can be reset to it's initial state.

#include <sstream>
#include "Puma/ErrorSink.h"
#include "Puma/ErrorSeverity.h"
#include "Puma/Location.h"
using namespace std;

namespace Puma {


class ErrorStream : public ErrorSink {
  ostream *_ostream;
  ErrorSeverity _max_severity;
  ErrorSeverity _curr_severity;
  Location _location;
  bool _have_location;
  std::ostringstream *_msg;
  bool _silently;

  void output ();
  void clear ();

public:
  ErrorStream (std::ostream &s = cerr) : _ostream (&s), _msg ((std::ostringstream*)0)
   { reset (); _silently = false; }
  virtual ~ErrorStream () { delete _msg; }

  ErrorStream &operator << (const char *);
  ErrorStream &operator << (long);
  ErrorStream &operator << (unsigned);
  ErrorStream &operator << (int);
  ErrorStream &operator << (short);
  ErrorStream &operator << (char);
  ErrorStream &operator << (double);
  ErrorStream &operator << (const ErrorSeverity &);
  ErrorStream &operator << (Location);
  ErrorStream &operator << (const Printable &);
  ErrorStream &operator << (void (*f)(ErrorSink &));

  void endMessage ();
  void reset ();
  void silent ();
  void loud ();

  ErrorSeverity severity () const { return _max_severity; }
};


} // namespace Puma

#endif /* __error_stream_h__ */
