/* scanner.h */

# ifndef _SCANNER_
# define _SCANNER_

# include "symbol.h"

typedef enum
 {
   CLASSES, TABLE, COLON, IS, CHAR, STRING, TO, OR, STAR, PLUS,
   OPEN_BRACKET, CLOSE_BRACKET, OPEN_SQUARE_BRACKET, CLOSE_SQUARE_BRACKET,
   EPSILON, HASH_MARK, MAP_TO, LOOK_AHEAD, SPACE, COMMENT, 
   END_OF_LINE_COMMENT, NAME, END, ERROR
 } TokenType;


typedef struct { TokenType     Type;
                 TableIndex    Index;
               } Token;


int BeginScanning (char *FileName);

int EndScanning (void);

void NextToken (Token *Token);

# endif





