# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""
Some utilities needing some asrun objects to be initialized.
"""
#...but must not require import of other asrun modules

import os
import time

from asrun.common.i18n import _
from asrun.backward_compatibility import get_hostrc


def get_tmpname(run, dirname=None, basename=None, node=None, pid=None):
    """Return a name for a temporary directory (*not created*)
    of the form : 'dirname'/user@machine-'basename'.'pid'
    Default values :
        dirname  = run['rep_trav']   from config file
        basename = 'tmpname-' + date
        pid      = run['num_job']
    """
    user, host = run.system.getuser_host()
    node = node or host
    dirname  = dirname or run['rep_trav']
    pid = pid or run['num_job']
    return get_tmpname_base(dirname, basename, user, node, pid)


def get_tmpname_base(dirname=None, basename=None, user=None, node=None, pid=None):
    """Return a name for a temporary directory (*not created*)
    of the form : 'dirname'/user@machine-'basename'.'pid'
    *Only* basename is not compulsory in this variant.
    """
    basename = basename or 'tmpname-%.6f' % time.time()
    if pid == "auto":
        pid = "pid-%.6f" % time.time()
    root, ext = os.path.splitext(basename)
    name = '%s-%s-' % (user, node) + root + '.' + str(pid) + ext
    return os.path.join(dirname, name)


def get_devel_param(run):
    """Return user/server on the main server.
    """
    user = run['devel_server_user']
    mach = run['devel_server_ip']
    if user in (None, ''):
        run.Mess(_(u"remote connection to '%s' may fail :%s" \
                 "'devel_server_user' not defined in '%s'") \
                % (mach, os.linesep, run.user_rc), '<A>_ALARM')
    return user, mach

