(*
datatypes.atxt: 1(line=1, offs=1) -- 37(line=5, offs=3)
*)

//
#include "tutorial.dats"
//

(*
datatypes.atxt: 40(line=6, offs=2) -- 127(line=8, offs=3)
*)
val _tok1 = comment("\n\
The file is automatically generated by [atsdoc] from datatypes.atxt.\n\
")
val () = theTextMap_insert_str ("_tok1", _tok1)

(*
datatypes.atxt: 163(line=10, offs=22) -- 174(line=10, offs=33)
*)
val _tok3 = timestamp()
val () = theTextMap_insert_str ("_tok3", _tok3)

(*
datatypes.atxt: 129(line=9, offs=2) -- 178(line=11, offs=3)
*)
val _tok2 = comment("\n\
Time of Generation: #_tok3$\
")
val () = theTextMap_insert_str ("_tok2", _tok2)

(*
datatypes.atxt: 180(line=12, offs=2) -- 214(line=12, offs=36)
*)
val _tok4 = comment("beg of [datatypes.html]")
val () = theTextMap_insert_str ("_tok4", _tok4)

(*
datatypes.atxt: 885(line=30, offs=1) -- 2303(line=43, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR="#000000">datatype</FONT> <FONT COLOR="#0000FF">intlst0</FONT> <FONT COLOR="#000000">=</FONT> <FONT COLOR="#787878">// simple datatype
</FONT>  <FONT COLOR="#000000">|</FONT> INTLST0nil <FONT COLOR="#787878">// the first bar (|) is optional
</FONT>  <FONT COLOR="#000000">|</FONT> INTLST0cons <FONT COLOR="#000000">of</FONT> <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>int<FONT COLOR="#000000">,</FONT> intlst0<FONT COLOR="#000000">)</FONT></FONT>

<FONT COLOR="#000000">fun</FONT> length_intlst0 <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">intlst0</FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">int</FONT> <FONT COLOR="#000000">=</FONT>
  <FONT COLOR="#000000">case+</FONT> xs <FONT COLOR="#000000">of</FONT> <FONT COLOR="#787878">// [case+] demands exhaustive pattern matching
</FONT>  <FONT COLOR="#787878">// the bar (|) in the first clause is optional
</FONT>  <FONT COLOR="#000000">|</FONT> INTLST0cons <FONT COLOR="#000000">(</FONT>_<FONT COLOR="#000000">,</FONT> xs<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> 1 + length_intlst0 <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">)</FONT>
  <FONT COLOR="#000000">|</FONT> INTLST0nil <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> 0
</FONT></PRE>
*)

(*
datatypes.atxt: 2305(line=44, offs=2) -- 2695(line=55, offs=3)
*)
val _tok5 = atscode2xmld("\
datatype intlst0 = // simple datatype
  | INTLST0nil // the first bar (|) is optional
  | INTLST0cons of (int, intlst0)

fun length_intlst0 (xs: intlst0): int =
  case+ xs of // [case+] demands exhaustive pattern matching
  // the bar (|) in the first clause is optional
  | INTLST0cons (_, xs) => 1 + length_intlst0 (xs)
  | INTLST0nil () => 0
// end of [length_intlst0]
")
val () = theTextMap_insert_str ("_tok5", _tok5)

(*
datatypes.atxt: 2696(line=55, offs=4) -- 2719(line=55, offs=27)
*)
val _tok6 = comment("atscode2xmld")
val () = theTextMap_insert_str ("_tok6", _tok6)

(*
datatypes.atxt: 3149(line=67, offs=1) -- 4046(line=74, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR="#000000">datatype</FONT> <FONT COLOR="#0000FF">intlst1 <FONT COLOR="#000000">(</FONT>int<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#000000">=</FONT> <FONT COLOR="#787878">// dependent datatype
</FONT>  <FONT COLOR="#000000">|</FONT> INTLST1nil <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>0<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#787878">// the first bar (|) is optional
</FONT>  <FONT COLOR="#000000">|</FONT> <FONT COLOR="#000000">{</FONT><FONT COLOR="#0000FF">n<FONT COLOR="#000000">:</FONT>nat</FONT><FONT COLOR="#000000">}</FONT> INTLST1cons <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>n+1<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#000000">of</FONT> <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>int<FONT COLOR="#000000">,</FONT> intlst1 n<FONT COLOR="#000000">)</FONT></FONT>
</FONT></PRE>
*)

(*
datatypes.atxt: 4048(line=75, offs=2) -- 4235(line=80, offs=3)
*)
val _tok7 = atscode2xmld("\
datatype intlst1 (int) = // dependent datatype
  | INTLST1nil (0) // the first bar (|) is optional
  | {n:nat} INTLST1cons (n+1) of (int, intlst1 n)
// end of [intlst1]
")
val () = theTextMap_insert_str ("_tok7", _tok7)

(*
datatypes.atxt: 4852(line=100, offs=1) -- 5929(line=109, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR="#000000">fun</FONT> length_intlst1 <FONT COLOR="#0000FF"><FONT COLOR="#000000">{</FONT>n<FONT COLOR="#000000">:</FONT>nat<FONT COLOR="#000000">}</FONT></FONT> <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">intlst1 n</FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">int n</FONT> <FONT COLOR="#000000">=</FONT>
  <FONT COLOR="#000000">case+</FONT> xs <FONT COLOR="#000000">of</FONT> <FONT COLOR="#787878">// the bar (|) in the first clause is optional
</FONT>  <FONT COLOR="#787878">// the bar (|) in the first clause is optional
</FONT>  <FONT COLOR="#000000">|</FONT> INTLST1cons <FONT COLOR="#000000">(</FONT>_<FONT COLOR="#000000">,</FONT> xs<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> 1 + length_intlst1 <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">)</FONT>
  <FONT COLOR="#000000">|</FONT> INTLST1nil <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> 0
</FONT></PRE>
*)

(*
datatypes.atxt: 5931(line=110, offs=2) -- 6212(line=117, offs=3)
*)
val _tok8 = atscode2xmld("\
fun length_intlst1 {n:nat} (xs: intlst1 n): int n =
  case+ xs of // the bar (|) in the first clause is optional
  // the bar (|) in the first clause is optional
  | INTLST1cons (_, xs) => 1 + length_intlst1 (xs)
  | INTLST1nil () => 0
// end of [length_intlst1]
")
val () = theTextMap_insert_str ("_tok8", _tok8)

(*
datatypes.atxt: 6534(line=132, offs=1) -- 7928(line=142, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR="#787878">// the index is a natural number less than the size of the indexed length
</FONT><FONT COLOR="#000000">fun</FONT> nth_intlst1 <FONT COLOR="#0000FF"><FONT COLOR="#000000">{</FONT>n<FONT COLOR="#000000">,</FONT>i<FONT COLOR="#000000">:</FONT>int <FONT COLOR="#000000">|</FONT> 0 &lt;= i<FONT COLOR="#000000">;</FONT> i <FONT COLOR="#000000">&lt;</FONT> n<FONT COLOR="#000000">}</FONT></FONT> <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">intlst1 n</FONT><FONT COLOR="#000000">,</FONT> i<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">int i</FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">int</FONT> <FONT COLOR="#000000">=</FONT>
  <FONT COLOR="#787878">// [val+] demands exhaustive pattern matching
</FONT>  <FONT COLOR="#000000">let</FONT> <FONT COLOR="#000000">val+</FONT> INTLST1cons <FONT COLOR="#000000">(</FONT>x<FONT COLOR="#000000">,</FONT> xs<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=</FONT> xs <FONT COLOR="#000000">in</FONT>
    <FONT COLOR="#000000">if</FONT> i <FONT COLOR="#000000">&gt;</FONT> 0 <FONT COLOR="#000000">then</FONT> nth_intlst1 <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">,</FONT> i-1<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">else</FONT> x
  <FONT COLOR="#000000">end</FONT>
</FONT></PRE>
*)

(*
datatypes.atxt: 7930(line=143, offs=2) -- 8277(line=151, offs=3)
*)
val _tok9 = atscode2xmld("\
// the index is a natural number less than the size of the indexed length
fun nth_intlst1 {n,i:int | 0 <= i; i < n} (xs: intlst1 n, i: int i): int =
  // [val+] demands exhaustive pattern matching
  let val+ INTLST1cons (x, xs) = xs in
    if i > 0 then nth_intlst1 (xs, i-1) else x
  end // end of [let]
// end of [nth_intlst1]
")
val () = theTextMap_insert_str ("_tok9", _tok9)

(*
datatypes.atxt: 8744(line=163, offs=1) -- 9864(line=171, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR=#"808080">// [t@ype] is a sort for types of unrestricted size
</FONT><FONT COLOR="#000000">datatype</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">:</FONT>t@ype+<FONT COLOR="#000000">,</FONT> int<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#000000">=</FONT> <FONT COLOR="#787878">// polymorphic datatype
</FONT>  <FONT COLOR="#000000">|</FONT> nil <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> 0<FONT COLOR="#000000">)</FONT></FONT>
  <FONT COLOR="#000000">|</FONT> <FONT COLOR="#000000">{</FONT><FONT COLOR="#0000FF">n<FONT COLOR="#000000">:</FONT>nat</FONT><FONT COLOR="#000000">}</FONT> cons <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> n+1<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#000000">of</FONT> <FONT COLOR="#0000FF"><FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> list <FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> n<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">)</FONT></FONT>
</FONT></PRE>
*)

(*
datatypes.atxt: 9866(line=172, offs=2) -- 10053(line=177, offs=3)
*)
val _tok10 = atscode2xmld("\
// [t@ype] is a sort for types of unrestricted size
datatype list (a:t@ype+, int) = // polymorphic datatype
  | nil (a, 0)
  | {n:nat} cons (a, n+1) of (a, list (a, n))
")
val () = theTextMap_insert_str ("_tok10", _tok10)

(*
datatypes.atxt: 10597(line=196, offs=1) -- 12160(line=205, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR="#000000">fun</FONT><FONT COLOR="#000000">{</FONT><FONT COLOR="#0000FF">a<FONT COLOR="#000000">:</FONT>t@ype</FONT><FONT COLOR="#000000">}</FONT> append_list <FONT COLOR="#0000FF"><FONT COLOR="#000000">{</FONT>m<FONT COLOR="#000000">,</FONT>n<FONT COLOR="#000000">:</FONT>nat<FONT COLOR="#000000">}</FONT></FONT>
  <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> m<FONT COLOR="#000000">)</FONT></FONT><FONT COLOR="#000000">,</FONT> ys<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> n<FONT COLOR="#000000">)</FONT></FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT>a<FONT COLOR="#000000">,</FONT> m+n<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#000000">=</FONT>
  <FONT COLOR="#000000">case+</FONT> xs <FONT COLOR="#000000">of</FONT>
  <FONT COLOR="#000000">|</FONT> cons <FONT COLOR="#000000">(</FONT>x<FONT COLOR="#000000">,</FONT> xs<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> cons <FONT COLOR="#000000">(</FONT>x<FONT COLOR="#000000">,</FONT> append_list <FONT COLOR="#000000">(</FONT>xs<FONT COLOR="#000000">,</FONT> ys<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">)</FONT>
  <FONT COLOR="#000000">|</FONT> nil <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> ys
</FONT></PRE>
*)

(*
datatypes.atxt: 12162(line=206, offs=2) -- 12375(line=214, offs=3)
*)
val _tok11 = atscode2xmld("\
fun{a:t@ype}
append_list {m,n:nat}
  (xs: list (a, m), ys: list (a, n)): list (a, m+n) =
  case+ xs of
  | cons (x, xs) => cons (x, append_list (xs, ys))
  | nil () => ys
// end of [append_list]
")
val () = theTextMap_insert_str ("_tok11", _tok11)

(*
datatypes.atxt: 12733(line=224, offs=1) -- 15278(line=234, offs=3)
*)

(*
<PRE><FONT COLOR="#E80000"><FONT COLOR="#000000">fun</FONT><FONT COLOR="#000000">{</FONT><FONT COLOR="#0000FF">a1<FONT COLOR="#000000">,</FONT>a2<FONT COLOR="#000000">:</FONT>t@ype</FONT><FONT COLOR="#000000">}</FONT> zip_list <FONT COLOR="#0000FF"><FONT COLOR="#000000">{</FONT>n<FONT COLOR="#000000">:</FONT>nat<FONT COLOR="#000000">}</FONT></FONT>
  <FONT COLOR="#000000">(</FONT>xs1<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT>a1<FONT COLOR="#000000">,</FONT> n<FONT COLOR="#000000">)</FONT></FONT><FONT COLOR="#000000">,</FONT> xs2<FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT>a2<FONT COLOR="#000000">,</FONT> n<FONT COLOR="#000000">)</FONT></FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">:</FONT> <FONT COLOR="#0000FF">list <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">'(</FONT>a1<FONT COLOR="#000000">,</FONT> a2<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">,</FONT> n<FONT COLOR="#000000">)</FONT></FONT> <FONT COLOR="#000000">=</FONT>
  <FONT COLOR="#000000">case+</FONT> <FONT COLOR="#000000">(</FONT>xs1<FONT COLOR="#000000">,</FONT> xs2<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">of</FONT>
  <FONT COLOR="#000000">|</FONT> <FONT COLOR="#000000">(</FONT>cons <FONT COLOR="#000000">(</FONT>x1<FONT COLOR="#000000">,</FONT> xs1<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">,</FONT> cons <FONT COLOR="#000000">(</FONT>x2<FONT COLOR="#000000">,</FONT> xs2<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> cons <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">'(</FONT>x1<FONT COLOR="#000000">,</FONT> x2<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">,</FONT> zip_list <FONT COLOR="#000000">(</FONT>xs1<FONT COLOR="#000000">,</FONT> xs2<FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">)</FONT>
  <FONT COLOR="#000000">|</FONT> <FONT COLOR="#000000">(</FONT>nil <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">,</FONT> nil <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT><FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=&gt;</FONT> nil <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT>
  <FONT COLOR="#000000">|</FONT> <FONT COLOR="#000000">(</FONT>_<FONT COLOR="#000000">,</FONT> _<FONT COLOR="#000000">)</FONT> <FONT COLOR="#000000">=/=&gt;&gt;</FONT> <FONT COLOR="#000000">(</FONT><FONT COLOR="#000000">)</FONT> <FONT COLOR="#787878">// other cases cannot occur
</FONT></FONT></PRE>
*)

(*
datatypes.atxt: 15280(line=235, offs=2) -- 15601(line=244, offs=3)
*)
val _tok12 = atscode2xmld("\
fun{a1,a2:t@ype}
zip_list {n:nat}
  (xs1: list (a1, n), xs2: list (a2, n)): list ('(a1, a2), n) =
  case+ (xs1, xs2) of
  | (cons (x1, xs1), cons (x2, xs2)) => cons ('(x1, x2), zip_list (xs1, xs2))
  | (nil (), nil ()) => nil ()
  | (_, _) =/=>> () // none of these cases can occur
// end of [zip_list]
")
val () = theTextMap_insert_str ("_tok12", _tok12)

(*
datatypes.atxt: 15855(line=252, offs=2) -- 15891(line=252, offs=38)
*)
val _tok13 = comment(" end of [datatypes.html] ")
val () = theTextMap_insert_str ("_tok13", _tok13)

(*
datatypes.atxt: 15893(line=254, offs=1) -- 15967(line=256, offs=3)
*)

implement main () = fprint_filsub (stdout_ref, "datatypes_atxt.txt")

