'
' Contributed by Ian Sydenham <ian_sydenham@hotmail.com>,
' many thanks
'
'Script file to generate a Hugin pto file from a series of images.
'The images are all dragged and dropped onto the program icon.
'This routine calls generatekeys to generate sift keypoints
'then runs autopano to check matches and create a Hugin file.
'Both executables for generatekeys and autopano must be in the same directory as this script.
'The key files and Hugin pto file are generated in the same file as the images.

   Option Explicit   ' Force explicit variable declaration.

   'Check if the host script is recent enough
   If WScript.Version <2 Then
   	promptstr= "Visual Basic Script version 2 or greater is needed to run this script"&vbNewLine& _
   	        "Current version is " & WScript.Version & vbNewLine & _
   	        "Download the latest version from the Microsoft download site." & vbNewLine & _
   	        "Go to http://www.microsoft.com/downloads/search.aspx , then" & vbNewLine & _
   	        "select 'System Management Tools' from the download categories list," & vbNewLine & _
   	        "then search to find Windows Script for your version of Windows."& vbNewLine & vbNewLine & _
   	        "Script will Exit"
   	msgbox promptstr,vbCritical, "Windows Script Update required" 
	WScript.Quit
   End If
   
   'Set Constants and Variables
   Const KeyExt=".xml.gz"			'The file extension for keyfiles - added on to the image file name
   Const MinDim_dflt=1300
   Const Ransac_dflt="on"
   Const Ransac_on="on"
   Const Ransac_off="off"
   Const MaxMatches_dflt=16
   Const HuginFile_dflt="Hugin.pto"
   Const CleanKeys_dflt=false
   Const generatekeysExe = "generatekeys.exe"  'The executable for generateingkeys
   Const autopanoExe = "autopano.exe"             'The executable for autopano
   Dim WshShell, objArgs, ImageFile, KeyFile, i, Namepos, loopreply
   Dim dblquote, reply, promptstr, KeyFileList, shlcmd, HuginFileSet
   Dim MinDim, Ransac, MaxMatches, HuginFile,CleanKeys,DefaultBtn
   Public EchoMe,fso
   Set objArgs = WScript.Arguments 'The list of files dropped into this icon
   Set fso = CreateObject("Scripting.FileSystemObject")
   Set WshShell = WScript.CreateObject("WScript.Shell") 
   dblquote=unescape("%22")
   KeyFileList=""


   ' When using drag and drop make sure that the external WScript.Run commands use the 
   ' correct "current directory". This is where the autopano and generatekeys exe files will be.
   ' Sets the 
   WshShell.CurrentDirectory = ScriptFilePath() 
   

   'If there is not at least one argument then show the usage information
   If (WScript.Arguments.Count < 1) Then
      'Nothing to do.
      promptstr = "usage: Autopano-complete.vbs image1 image2 [...]"&vbNewLine& _
        "or drag and drop the images onto this script's icon."&vbNewLine&vbNewLine& _
	"Options and Parameters are prompted within the script, not entered as command line parameters."&vbNewLine& _
        "Parameters are:"&vbNewLine& _
        "MinDim: Halve the size of the images until width and height are smaller than MinDim, default: "&MinDim_dflt&vbNewLine& _
	"MaxMatches: number of control points kept for each pair default: "&MaxMatches_dflt&vbNewLine& _
	"Ransac: Ransac detection enabled or disabled. Default: "&Ransac_dflt&vbNewLine& _
	"CleanKeys: True to overwrite (and not reuse) keypoints detected in earlier runs. Default: "&CleanKeys_dflt&vbNewLine& _
        "Huginfile: The full path and filename of the Hugin pto file to be created by Autopano. The default file is named "&HuginFile_dflt& " and is saved in the same directory as the first image file"&vbNewLine& _
        "The keyfiles are saved in the same directory as the images."
      msgbox promptstr, vbExclamation, "No Image Files to read"
      WScript.Quit
   End If

   
   'Check if Windows scripting is using the command console, or Windows mode
   If instr(1,WScript.FullName,"cscript.exe",vbtextcompare)>0 then
   	'Using the cscript.exe executable which will NOT stop running to display an echo
   	'so echo messages to the console
   	EchoMe=true
   Else
   	'Must be using wscript.exe executable which WILL stop running to display an echo
   	'So do NOT echo messages to the console
   	promptstr= "This script was started using the default script interpreter WScript.exe." &vbNewLine& _
   	       "Consider using CScript.exe instead." & vbNewLine & vbNewLine & _
   	       "WScript stops to display a pop-up window for any progress messages," &vbNewLine& _
   	       "so this script disables progress messages when started using WScript." &vbNewLine& _
   	       "CScript shows progress messages in the command window and continues." &vbNewLine& _
   	       "so this script enables progress messages when started using CScript." &vbNewLine&vbNewLine& _
   	       "To change to CScript.exe select Start->Run" &vbNewLine& _
   	       "then type WScript.exe //H:CScript and click OK." &vbNewLine& _
   	       "To change back do the same, but type CScript.exe //H:WScript"
      	msgbox promptstr, vbExclamation
      	EchoMe=false
   End If
      
   
   'Check &/or set the user parameters for generatekeys and autopano
   EchoThis "Checking parameters"
   MinDim=MinDim_dflt
   HuginFile=FilePath(objArgs(0))&HuginFile_dflt
   MaxMatches=MaxMatches_dflt
   Ransac=Ransac_dflt
   CleanKeys=CleanKeys_dflt
   DO
     promptstr="MinDim:" & cstr(MinDim) & vbNewLine & _
               "HuginFile:" & HuginFile & vbNewLine & _
               "MaxMatches:" & cstr(MaxMatches) & vbNewLine & _
               "Ransac:" & Ransac & vbNewLine & _
               "CleanKeys:" & Cleankeys 
     loopreply=msgbox(promptstr, vbYesNoCancel+vbDefaultButton2+vbQuestion, "Do you want to change the the current settings:")
     If loopreply=vbYes then
       MinDim=inputbox("MinDim", "Enter New Value", MinDim)
       Do 
          HuginFile=inputbox("HuginFile", "Enter New Value", HuginFile)
          reply=FileOverwriteCheck(HuginFile)
          HuginFileSet=true
       Loop Until reply=vbYes   
       MaxMatches=inputbox("MaxMatches", "Enter New Value", MaxMatches)
       If Ransac=Ransac_on Then DefaultBtn=vbDefaultButton1 Else DefaultBtn=vbDefaultButton2 End If
       reply=msgbox("Ransac Check",vbYesNo+DefaultBtn+vbQuestion,"Select New Value")
       Select Case reply
         Case vbYes
           Ransac=Ransac_on
         Case vbNo
           Ransac=Ransac_off
       End Select
       If CleanKeys=True Then DefaultBtn=vbDefaultButton1 Else DefaultBtn=vbDefaultButton2 End If
       reply=msgbox("CleanKeys (erase any existing keyfiles):",vbYesNo+DefaultBtn+vbQuestion,"Select New Value")
       Select Case reply
         Case vbYes
           CleanKeys=true
         Case vbNo
           CleanKeys=false
       End Select
     End If
   Loop Until (loopreply<>vbYes)
   If reply=vbCancel then
     WScript.Quit
   End If
   if not HuginFileSet then
     'Check to see if the Hugin file will be overwritten
     Do
       reply=FileOverwriteCheck(HuginFile)
       if reply=vbno then  
      	 HuginFile=inputbox("HuginFile", "Enter New Value", HuginFile)
       end if
     Loop Until reply=vbYes         
   end if
        
   'GenerateKeys
   For i = 0 to objArgs.Count - 1
      ImageFile=objArgs(i)
      KeyFile=ImageFile+KeyExt
      If (fso.FileExists(ImageFile)) Then
         KeyFileList=KeyFileList+" "+dblquote+KeyFile+dblquote      
         If (fso.FileExists(KeyFile) and not CleanKeys) Then
            EchoThis "Using existing keypoint file: "+KeyFile
         Else
            EchoThis "Generating key file: "+KeyFile
            shlcmd=generatekeysExe & " " & dblquote&ImageFile&dblquote &" "&dblquote&KeyFile&dblquote&" "&cstr(MinDim)
            WshShell.Run shlcmd, , true
         End If
      End If
   Next
   EchoThis "KeyFiles Done"

   'Run Autopano
   if KeyFileList<>"" then
     EchoThis "Calling Autopano to create " & HuginFile
     shlcmd = "cmd /K " & autopanoExe & " --ransac " & Ransac & " --maxmatches " & MaxMatches & " " & dblquote&HuginFile&dblquote & " "&KeyfileList
     WshShell.Run shlcmd, , false
   end if
   WScript.Quit

Function ScriptFilePath() 
'Returns the pathname of this script file - it the directory where this script file is saved.
   Dim Name_pos, Pathonly, deduct
   
   Namepos = InStrRev(WScript.ScriptFullName, WScript.ScriptName, -1, 1)
   If Namepos >3 then 
     deduct=2 
   Else 
     deduct=1 
   End If
   Pathonly = mid(WScript.ScriptFullName,1,Namepos-deduct)
   ScriptFilePath=Pathonly
End Function

Function FilePath(filespec)
'Returns file path (without file name) of filespec including the last \

   Dim f
   Dim Name_pos, Pathonly
   
   If fso.FileExists(filespec) then
     Set f = fso.GetFile(filespec)
   
     Namepos = InStrRev(f.Path, f.Name, -1, 1)
     Pathonly = mid(f.Path,1,Namepos-1)
     FilePath=Pathonly
    Else
      FilePath=""
    End If
End Function

Sub EchoThis(EchoString)
  If EchoMe Then WScript.Echo EchoString End If
end Sub

Function FileOverwriteCheck(FileName)
'returns true if the file does not exist, or exists and the user
'wants to overwrite it

   Dim reply,promptstr
   
   If (fso.FileExists(FileName)) Then
      promptstr="The File (" & HuginFile & ")already exists and will be overwritten."&vbNewLine& _
                "Is that what you want to do?"
      reply=msgbox(promptstr,vbYesNo+vbDefaultButton2+vbExclamation,"File will be overwritten")
   else
      reply=vbYes
   end if   
   FileOverwriteCheck=reply

end Function
