
using Gtk;
using GtkSharp;
using System;

public class DistMetricTest
{
	public static void Main (string[] args)
	{
		Application.Init ();

		Window win = new Window ("Image keypoint display program");
		win.DefaultSize = new Gdk.Size (400, 300);
		win.DeleteEvent += new DeleteEventHandler (Window_Delete);

		int dim = 800;
		Gdk.Pixbuf pbuf = new Gdk.Pixbuf (Gdk.Colorspace.Rgb, false, 8,
			dim, dim);
		pbuf.Fill (0x000000);

		double ax = 200;
		double bx = 600;
		double ay = 400;
		double by = 400;

		for (int y = 0 ; y < dim ; ++y) {
			for (int x = 0 ; x < dim ; ++x) {
				double d1 = Math.Sqrt (Math.Pow (y - ay, 2) + Math.Pow (x - ax, 2));
				double d2 = Math.Sqrt (Math.Pow (y - by, 2) + Math.Pow (x - bx, 2));
				double d3 = Math.Abs (bx - ax);

				/*
				double s = (d1 + d2 + d3) / 2.0;
				double S = Math.Sqrt (s * (s - d1) * (s - d2) * (s - d3));
				byte grayVal = (byte) ((S / 50000) * 255.0);
				*/
				double S = d1 + d2 - d3;
				byte grayVal = (byte) ((S / Math.Sqrt (800*800 + 800*800)) * 255.0);

				for (int n = 0 ; n < 3 ; ++n) {
					if ((x == ax && y == ay) || (x == bx && y == by))
						grayVal = (new byte[] { 255, 0, 0 })[n];
					pbuf.Pixels[y * pbuf.Rowstride + x * pbuf.NChannels + n] = grayVal;
				}
			}
		}

		win.Add (new Image (pbuf));
		win.ShowAll ();
		Application.Run ();
	}

	static void Window_Delete (object obj, DeleteEventArgs args)
	{
		Application.Quit ();
		args.RetVal = true;
	}
}

