/*
Copyright (C) 2000-2001 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "avrpp.h"
#include "avrserial.h"
#include "microdelay.h"
#include <unistd.h>

int exchange (ASPP *aspp, int wr_data) {
  /* WARNING: aspp_SCK should be clear when entering this function */
  /*         this in ensured by executing the power_up function */
  int rd_data=0;
  int cont;
  for (cont=0; cont<8; cont++) {
    aspp_MOSI(aspp, wr_data&0x80);  /* put data */
    microdelay(TCLCL*2);        /* wait >1.25 tclcl */
    aspp_SCK(aspp, 1);          /* rising edge of SCK */
    microdelay(TCLCL*3);
    rd_data |= aspp_MISO(aspp); /* read data */
    microdelay(TCLCL*2);
    aspp_SCK(aspp, 0);          /* falling edge of SCK */
    rd_data <<= 1;
    wr_data <<= 1;
  }
  rd_data >>= 1;
  return rd_data;
}

int programming_enable (ASPP *aspp) {
  unsigned char data=0;
  int try=0;

  exchange(aspp, 0xac);
  exchange(aspp, 0x53);
  data = exchange(aspp,0x00);
  exchange(aspp, 0x00);
  try++;

  /* FALTA REVISAR ESTA ROTINA */
  /* *************************************************** */
  /* only chip is AT90S1200 it needs to exit now!!! */
  /* *************************************************** */
  /* seems to work fine exiting here for AT90S2313 too. */
  return 1;

  while (data!=0x53 && try<34) {
    aspp_SCK(aspp,1);
    /* usleep(DELAY2); */
    aspp_SCK(aspp,0);
    /* usleep(DELAY2); */
    exchange(aspp, 0xac);
    exchange(aspp, 0x53);
    data = exchange(aspp,0x00);
    /* printf("0x%d - 0x%x\n", try, data); */
    exchange(aspp, 0x00);
    try++;
  }
  /* printf("prog enable: %d\n",try); */
  return data == 0x53;
}

void chip_erase(ASPP * aspp) {
  exchange(aspp, 0xac);
  exchange(aspp, 0x80);
  exchange(aspp, 0);
  exchange(aspp, 0);
  usleep(30000); /* wait >20ms */
  aspp_RESET(aspp,1); /* reset positive pulse */
  usleep(10000);
  aspp_RESET(aspp,0);
  usleep(20000);
}

int read_signature_byte(ASPP *aspp, int address) {
  exchange(aspp, 0x30);
  exchange(aspp, 0);
  exchange(aspp, address&0x03);
  return (int) exchange(aspp, 0);
}

int read_program_memory(ASPP *aspp, int sb, int address) {
  exchange(aspp, 0x20 | (sb ? 0x8 : 0x0));
  exchange(aspp, (address >> 8) & 0xff);
  exchange(aspp, address & 0xff);
  return exchange(aspp, 0x00);
}

int write_program_memory(ASPP *aspp, int sb, int address, int data) {
    exchange(aspp, 0x40 | (sb ? 0x8 : 0x0));
    exchange(aspp, (address >> 8) & 0xff);
    exchange(aspp, address & 0xff);
    exchange(aspp, data & 0xff);
    microdelay(5000); /* wait at least 4ms to read/write next byte */
    /* printf(" (wr-%02x-%02x) ",read_program_memory(aspp, sb, address),data); */
    return (read_program_memory(aspp, sb, address)==data);  /* verifies if data was written */
}

int read_eeprom_memory(ASPP *aspp, int address) {
  exchange(aspp, 0xa0);
  exchange(aspp, 0);
  exchange(aspp, address & 0xff);
  return exchange(aspp, 0);
}

int write_eeprom_memory(ASPP *aspp, int address, int data) {
    exchange(aspp, 0xc0);
    exchange(aspp, 0);
    exchange(aspp, address & 0xff);
    exchange(aspp, data & 0xff);
    microdelay(5000); /* wait at least 4ms to read/write next byte */
    return read_eeprom_memory(aspp, address)==data;  /* verifies if data was written */
}

void power_up (ASPP * aspp) {
    aspp_SCK(aspp, 0); /* set SCK to zero */
    usleep(30000);
    aspp_RESET(aspp, 1); /* send a positive pulse to RESET */
    usleep(30000);
    aspp_RESET(aspp, 0);
    usleep(30000); /* wait >20ms */
}

void power_off (ASPP * aspp, int reset) {
    /* if reset=0 do not let the chip software run */
    /*   reset=1 put reset in high level, so chip software runs */
    aspp_SCK(aspp, 1);
    aspp_MOSI(aspp, 1);
    if (reset)
	aspp_RESET(aspp, 1);
    else
	aspp_RESET(aspp, 0);
    usleep(20000);
}

void change_reset_pin (ASPP * aspp, int i) {
    aspp_RESET (aspp, i!=0);
}

void write_lock_bits(ASPP * aspp, int lock) {
    /* lock = 0   ->   LB2=0; LB1=0
       lock = 1   ->   LB2=0; LB1=1
       lock = 2   ->   LB2=1; LB1=0
       lock = 3   ->   LB2=1; LB1=1 */
    lock=(lock&0x03)<<1;
    exchange(aspp, 0xac);
    exchange(aspp, 0xe0 | lock);
    exchange(aspp, 0);
    exchange(aspp, 0);
}
