.TH AX25RTD.CONF 5 "11 November 2003" Linux "Linux Programmer's Manual"
.SH NAME
ax25rtd.conf \- ax25 routing daemon configuration file
.SH SYNOPSIS
.B /etc/ax25/ax25rtd.conf
.SH DESCRIPTION


The file /etc/ax25/ax25rtd.conf is the configuration file for @@@ax25rtd@@@.
The parameters of the options shown here are the default values except the
ones marked with (example)
.PP
ax25-maxroutes	4096
.TP
ip-maxroutes	4096
The maximum size of the three lists / caches. On overflow,
@@@ax25rtd@@@ will substitute the oldest entry with the new one.
.TP
iproute2-table radio

name ("radio") of the kernel routing table. This is an advanced
routing feature. If you do not need it, just leave this setting as is.

The current implementation  depends on iproute2 (anyone like to code it
directly?).

If not set or empty, routes are set in the normal, default, manner.
Please configure /etc/iproute2/rt_protos with

  44      @@@ax25rtd@@@

and /etc/iproute2/rt_tables with

  210     radio

where "radio" is the name of the table, (for the configuration example above).

This option is disabled by default.
.TP
ip-encaps-dev ipax0
This option was for a patched kernel of the 2.2.x series. Multible interfaces
were aggregated to one interface when sending IP frames. This option is
disabled by default.
.TP
[1k2]
.br
This marks the beginning of per-port definitions. Note that
you have to use port names as defined in axports(5) here,
anywhere else you may use the port or the device name.
.TP
ax25-learn-routes no
Set this to "yes", @@@ax25rtd@@@ will add the routing information
for every heard frame (with complete digipeater path) to the 
kernel AX.25 routing table. Note that @@@ax25rtd@@@'s internal cache
will be updated anyway, regardless of this option.
.TP
ax25-learn-only-mine no
If you set it to "yes", only frames that are sent to (1) the
interface callsign, (2) any of the listeners on this device, or
(3) the callsigns specified by ax25-more-mycalls will be used
to update the internal cache and (depending on
ax25-learn-routes) the kernel routing table.
.TP
ax25-add-path db0ach	(example)
This is useful on DAMA digipeaters. In this case, the DAMA
master has to be used for _every_ AX.25 connection, thus
@@@ax25rtd@@@ will add this digipeater(s) to every target we learn
that has no digipeater path (yet). "db0ach" is just an
example here.
.TP
ax25-more-mycalls dl1bke dl1bke-8	(example)
You can specify more calls as calls here that belong to
this interface... "dl1bke" and "dl1bke-8" are examples.
.TP
ip-learn-routes no
If set to "yes", @@@ax25rtd@@@ will modify the IP routing table if it
receives an IP frame (directed to us). This is dangerous!

It should not screw up your routing table, though. @@@Ax25rtd@@@ 
recognizes the netmask of the device and will adjust the route 
only if it fits the netmask and the old route points to
one of the devices @@@ax25rtd@@@ knows about (hence an AX.25 device).

The problems begin if you have more than one port and a user
is able to hear your outgoing traffic on at least two of them. 
Due to technical reasons @@@ax25rtd@@@ adjusts the route _after_ the 
kernel has sent the reply to the received TCP frame already.  
This has technical reasons. 

If the remote does the same both are switching between the two
ports.

Don't use this feature unless you know what you are doing.

It _should_ be safe do enable this on one-port machines, although
I strongly recommend to set a network route instead, i.e.:

        route add -net 44.0.0.0 scc3

Note that @@@ax25rtd@@@'s internal cache will be updated anyway,
regardless of this option.
.TP
irtt <irtt>
If ip-learn-routes is enabled this will assign newly added
routes an initial round trip time (IRTT) for TCP. <irtt>
is measured in msec, hence

        irtt 10000

sets the irtt to 10 seconds. A value of 0 disables this
feature (default).
.TP
ip-adjust-mode no
If you set this option to "yes" @@@ax25rtd@@@ will change the IP
encapsulation mode according to the last received IP frame.

The problem with this option is that the kernel AX.25 sends
a received IP frame to the IP layer regardless if it was
sent in UI frame encapsulation "mode datagram (dg)" or 
in I frame encaps, hence in an AX.25 connection, "mode virtual 
connect (vc)". The Linux kernel will respond to this frame
before @@@ax25rtd@@@ can adjust the mode. If the remote does the
same... You get the picture.

Don't use this feature unless you know what you are doing.
.TP
arp-add	no
This option, if set to "yes", changes the ARP table to the 
source callsign of the received frame. It should be harmless,
just has the the effect that if it is a new entry, the Linux
ARP code will send one ARP request before @@@ax25rtd@@@ has adjust
the ARP table. If there was already an existing ARP entry
for this IP route, one IP datagram will be sent to the old
address. Not really a problem, I hope.
.SH "SEE ALSO"
.BR @@@ax25rtd@@@ (8),
.BR ax25rtctl (8).
.LP
.SH AUTHORS
.nf
Joerg Reuter <jreuter@poboxes.com>
.br
Llaus Kudielka OE1KIB
.fi
