
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef AXIOM_MIME_CONST_H
#define AXIOM_MIME_CONST_H

/**
* @file axiom.h
* @brief includes all headers in MIME_CONST
*/
#ifdef __cplusplus
extern "C"
{
#endif

#define AXIOM_MIME_BOUNDARY_BYTE 45
#define AXIOM_MIME_CRLF_BYTE 13

#define AXIOM_MIME_TYPE_XOP_XML "application/xop+xml"
#define AXIOM_MIME_TYPE_MULTIPART_RELATED "multipart/related"
#define AXIOM_MIME_TYPE_OCTET_STREAM "application/octet-stream"

#define AXIOM_MIME_HEADER_FIELD_CHARSET "charset"
#define AXIOM_MIME_HEADER_FIELD_TYPE "type"
#define AXIOM_MIME_HEADER_FIELD_BOUNDARY "boundary"
#define AXIOM_MIME_HEADER_FIELD_START_INFO "start-info"
#define AXIOM_MIME_HEADER_FIELD_START "start"

#define AXIOM_MIME_HEADER_CONTENT_TYPE "content-type"
#define AXIOM_MIME_HEADER_CONTENT_TRANSFER_ENCODING "content-transfer-encoding"
#define AXIOM_MIME_HEADER_CONTENT_ID "content-id"

#define AXIOM_MIME_CONTENT_TRANSFER_ENCODING_BINARY "binary"

    /** @} */

#ifdef __cplusplus
}
#endif

#endif                          /* AXIOM_MIME_CONST_H */
