#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeploymentAppGateway(Model):
    """
    Deployment operation parameters.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar uri: URI referencing the template. Default value:
     "https://azuresdkci.blob.core.windows.net/templatehost/CreateAppGateway_2016-07-19/azuredeploy.json"
     .
    :vartype uri: str
    :param content_version: If included it must match the ContentVersion in
     the template.
    :type content_version: str
    :ivar _artifacts_location: Container URI of of the template. Default
     value:
     "https://azuresdkci.blob.core.windows.net/templatehost/CreateAppGateway_2016-07-19"
     .
    :vartype _artifacts_location: str
    :param application_gateway_name: The name of the application gateway.
    :type application_gateway_name: str
    :param capacity: The number of instances to use with the application
     gateway. Default value: 2 .
    :type capacity: int
    :param cert_data: The contents of the PFX certificate file.
    :type cert_data: str
    :param cert_password: The certificate password.
    :type cert_password: str
    :param frontend_port: The front end port number.
    :type frontend_port: int
    :param frontend_type: Specify which kind of frontend configuration to
     create. Possible values include: 'publicIp', 'privateIp'. Default value:
     "privateIp" .
    :type frontend_type: str or :class:`frontendType
     <appgatewaycreationclient.models.frontendType>`
    :param http_listener_protocol: The HTTP listener protocol. Possible
     values include: 'http', 'https'. Default value: "http" .
    :type http_listener_protocol: str or :class:`httpListenerProtocol
     <appgatewaycreationclient.models.httpListenerProtocol>`
    :param http_settings_cookie_based_affinity: Enable or disable HTTP
     settings cookie based affinity. Possible values include: 'enabled',
     'disabled'. Default value: "disabled" .
    :type http_settings_cookie_based_affinity: str or
     :class:`httpSettingsCookieBasedAffinity
     <appgatewaycreationclient.models.httpSettingsCookieBasedAffinity>`
    :param http_settings_port: The HTTP settings port. Default value: 80 .
    :type http_settings_port: int
    :param http_settings_protocol: The HTTP settings protocol. Possible
     values include: 'http', 'https'. Default value: "http" .
    :type http_settings_protocol: str or :class:`httpSettingsProtocol
     <appgatewaycreationclient.models.httpSettingsProtocol>`
    :param location: The location in which to create the application gateway.
    :type location: str
    :param private_ip_address: The static private IP address to associate
     with the application gateway frontend.
    :type private_ip_address: str
    :param private_ip_address_allocation: Specify the kind of private IP
     allocation. Possible values include: 'dynamic', 'static'. Default value:
     "dynamic" .
    :type private_ip_address_allocation: str or
     :class:`privateIpAddressAllocation
     <appgatewaycreationclient.models.privateIpAddressAllocation>`
    :param public_ip: The name or ID of the public IP address.
    :type public_ip: str
    :param public_ip_address_allocation: Specify the kind of public IP
     allocation for new public IPs. Possible values include: 'dynamic',
     'static'. Default value: "dynamic" .
    :type public_ip_address_allocation: str or
     :class:`publicIpAddressAllocation
     <appgatewaycreationclient.models.publicIpAddressAllocation>`
    :param public_ip_type: Specify the type of public IP address. Possible
     values include: 'none', 'new', 'existingName', 'existingId'. Default
     value: "none" .
    :type public_ip_type: str or :class:`publicIpType
     <appgatewaycreationclient.models.publicIpType>`
    :param routing_rule_type: The request routing rule type. Possible values
     include: 'Basic', 'PathBasedRouting'. Default value: "Basic" .
    :type routing_rule_type: str or :class:`routingRuleType
     <appgatewaycreationclient.models.routingRuleType>`
    :param servers: The list of IP addresses or DNS names corresponding to
     backend servers.
    :type servers: list of object
    :param sku_name: The name of the SKU. (Standard_Small, Standard_Medium,
     Standard_Large). Default value: "Standard_Medium" .
    :type sku_name: str
    :param sku_tier: The SKU tier. Default value: "Standard" .
    :type sku_tier: str
    :param subnet: The name or ID of the subnet. Default value: "default" .
    :type subnet: str
    :param subnet_address_prefix: The subnet prefix in CIDR format. Default
     value: "10.0.0.0/24" .
    :type subnet_address_prefix: str
    :param subnet_type: Use a new or existing subnet. Possible values
     include: 'new', 'existingId', 'existingName'. Default value: "new" .
    :type subnet_type: str or :class:`subnetType
     <appgatewaycreationclient.models.subnetType>`
    :param tags: Tags object.
    :type tags: object
    :param virtual_network_name: The name of the virtual network (VNet)
     associated with the subnet.
    :type virtual_network_name: str
    :param vnet_address_prefix: The virtual network address range in CIDR
     format. Default value: "10.0.0.0/16" .
    :type vnet_address_prefix: str
    :ivar mode: Gets or sets the deployment mode. Default value:
     "Incremental" .
    :vartype mode: str
    """ 

    _validation = {
        'uri': {'required': True, 'constant': True},
        '_artifacts_location': {'required': True, 'constant': True},
        'application_gateway_name': {'required': True},
        'mode': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'uri': {'key': 'properties.templateLink.uri', 'type': 'str'},
        'content_version': {'key': 'properties.templateLink.contentVersion', 'type': 'str'},
        '_artifacts_location': {'key': 'properties.parameters._artifactsLocation.value', 'type': 'str'},
        'application_gateway_name': {'key': 'properties.parameters.applicationGatewayName.value', 'type': 'str'},
        'capacity': {'key': 'properties.parameters.capacity.value', 'type': 'int'},
        'cert_data': {'key': 'properties.parameters.certData.value', 'type': 'str'},
        'cert_password': {'key': 'properties.parameters.certPassword.value', 'type': 'str'},
        'frontend_port': {'key': 'properties.parameters.frontendPort.value', 'type': 'int'},
        'frontend_type': {'key': 'properties.parameters.frontendType.value', 'type': 'frontendType'},
        'http_listener_protocol': {'key': 'properties.parameters.httpListenerProtocol.value', 'type': 'httpListenerProtocol'},
        'http_settings_cookie_based_affinity': {'key': 'properties.parameters.httpSettingsCookieBasedAffinity.value', 'type': 'httpSettingsCookieBasedAffinity'},
        'http_settings_port': {'key': 'properties.parameters.httpSettingsPort.value', 'type': 'int'},
        'http_settings_protocol': {'key': 'properties.parameters.httpSettingsProtocol.value', 'type': 'httpSettingsProtocol'},
        'location': {'key': 'properties.parameters.location.value', 'type': 'str'},
        'private_ip_address': {'key': 'properties.parameters.privateIpAddress.value', 'type': 'str'},
        'private_ip_address_allocation': {'key': 'properties.parameters.privateIpAddressAllocation.value', 'type': 'privateIpAddressAllocation'},
        'public_ip': {'key': 'properties.parameters.publicIp.value', 'type': 'str'},
        'public_ip_address_allocation': {'key': 'properties.parameters.publicIpAddressAllocation.value', 'type': 'publicIpAddressAllocation'},
        'public_ip_type': {'key': 'properties.parameters.publicIpType.value', 'type': 'publicIpType'},
        'routing_rule_type': {'key': 'properties.parameters.routingRuleType.value', 'type': 'routingRuleType'},
        'servers': {'key': 'properties.parameters.servers.value', 'type': '[object]'},
        'sku_name': {'key': 'properties.parameters.skuName.value', 'type': 'str'},
        'sku_tier': {'key': 'properties.parameters.skuTier.value', 'type': 'str'},
        'subnet': {'key': 'properties.parameters.subnet.value', 'type': 'str'},
        'subnet_address_prefix': {'key': 'properties.parameters.subnetAddressPrefix.value', 'type': 'str'},
        'subnet_type': {'key': 'properties.parameters.subnetType.value', 'type': 'subnetType'},
        'tags': {'key': 'properties.parameters.tags.value', 'type': 'object'},
        'virtual_network_name': {'key': 'properties.parameters.virtualNetworkName.value', 'type': 'str'},
        'vnet_address_prefix': {'key': 'properties.parameters.vnetAddressPrefix.value', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
    }

    uri = "https://azuresdkci.blob.core.windows.net/templatehost/CreateAppGateway_2016-07-19/azuredeploy.json"

    _artifacts_location = "https://azuresdkci.blob.core.windows.net/templatehost/CreateAppGateway_2016-07-19"

    mode = "Incremental"

    def __init__(self, application_gateway_name, content_version=None, capacity=2, cert_data=None, cert_password=None, frontend_port=None, frontend_type="privateIp", http_listener_protocol="http", http_settings_cookie_based_affinity="disabled", http_settings_port=80, http_settings_protocol="http", location=None, private_ip_address=None, private_ip_address_allocation="dynamic", public_ip=None, public_ip_address_allocation="dynamic", public_ip_type="none", routing_rule_type="Basic", servers=None, sku_name="Standard_Medium", sku_tier="Standard", subnet="default", subnet_address_prefix="10.0.0.0/24", subnet_type="new", tags=None, virtual_network_name=None, vnet_address_prefix="10.0.0.0/16"):
        self.content_version = content_version
        self.application_gateway_name = application_gateway_name
        self.capacity = capacity
        self.cert_data = cert_data
        self.cert_password = cert_password
        self.frontend_port = frontend_port
        self.frontend_type = frontend_type
        self.http_listener_protocol = http_listener_protocol
        self.http_settings_cookie_based_affinity = http_settings_cookie_based_affinity
        self.http_settings_port = http_settings_port
        self.http_settings_protocol = http_settings_protocol
        self.location = location
        self.private_ip_address = private_ip_address
        self.private_ip_address_allocation = private_ip_address_allocation
        self.public_ip = public_ip
        self.public_ip_address_allocation = public_ip_address_allocation
        self.public_ip_type = public_ip_type
        self.routing_rule_type = routing_rule_type
        self.servers = servers
        self.sku_name = sku_name
        self.sku_tier = sku_tier
        self.subnet = subnet
        self.subnet_address_prefix = subnet_address_prefix
        self.subnet_type = subnet_type
        self.tags = tags
        self.virtual_network_name = virtual_network_name
        self.vnet_address_prefix = vnet_address_prefix
