/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package Cadastros;

import Biblioteca.Botoes;
import Biblioteca.Janela;
import Biblioteca.Janelinha;
import Biblioteca.Visual;
import Principal.TelaPrincipal;
import javax.swing.table.DefaultTableModel;

public final class PlanejamentoPesquisar extends Janela {

    private final String Acao;
    private final Planejamento Planejamento;
    private final TelaPrincipal Principal;

    public PlanejamentoPesquisar(TelaPrincipal principal, Planejamento planejamento, String acao) {
        initComponents();
        Visual.Janela(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
        Planejamento = planejamento;
        Acao = acao;
        Principal = principal;
        resultado_pesquisa.setFont(FonteFinancas);
        resultado_pesquisa.getTableHeader().setFont(FonteFinancas);
    }
    
    public void Filtrar()
    {
        if(mes.getSelectedItem().equals(Lingua.getMensagem("todos")))
        {
            Banco.executeQuery("SELECT * FROM planejamento WHERE ano LIKE '%"+ano.getText()+"%' ORDER BY mes DESC, ano DESC");
        }else{
            Banco.executeQuery("SELECT * FROM planejamento WHERE ano LIKE '%"+ano.getText()+"%' AND mes='"+mes.getSelectedItem()+"' ORDER BY mes DESC, ano DESC");
        }

        try
        {
            DefaultTableModel modelo = (DefaultTableModel)resultado_pesquisa.getModel();
            modelo.setNumRows(0);
            while(Banco.getResultSet().next())
            {
                modelo.addRow(new Object[]{Banco.getResultSet().getString("id_planejamento"),Banco.getResultSet().getString("mes"),Banco.getResultSet().getString("ano"),Banco.getResultSet().getString("valor")});
            }
        }catch(Exception e)
        {
            Janelinha.Aviso(Lingua.getMensagem("atencao"),Lingua.getMensagem("excecao")+" "+e.getMessage());
        }
    }
    
    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair"))){
            PlanejamentoPesquisar.this.dispose();
        }
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        BarraDeFerramentas = new javax.swing.JToolBar();
        pesquisar_venda = new javax.swing.JPanel();
        scroll_pesquisa = new javax.swing.JScrollPane();
        resultado_pesquisa = new javax.swing.JTable();
        CLIENTE_NOME = new javax.swing.JLabel();
        BFiltrar = new javax.swing.JButton();
        mes = new javax.swing.JComboBox();
        CLIENTE_NOME1 = new javax.swing.JLabel();
        ano = new javax.swing.JTextField();

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("pesquisar"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);

        pesquisar_venda.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Lingua.getMensagem("plano"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, FonteFinancas, new java.awt.Color(0, 102, 204)));
        pesquisar_venda.setForeground(new java.awt.Color(51, 94, 168));

        resultado_pesquisa.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "ID", "", "", ""
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        resultado_pesquisa.getTableHeader().setReorderingAllowed(false);
        resultado_pesquisa.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                resultado_pesquisaMouseClicked(evt);
            }
        });
        scroll_pesquisa.setViewportView(resultado_pesquisa);
        if (resultado_pesquisa.getColumnModel().getColumnCount() > 0) {
            resultado_pesquisa.getColumnModel().getColumn(0).setMaxWidth(50);
            resultado_pesquisa.getColumnModel().getColumn(1).setResizable(false);
            resultado_pesquisa.getColumnModel().getColumn(1).setHeaderValue(Lingua.getMensagem("mes"));
            resultado_pesquisa.getColumnModel().getColumn(2).setResizable(false);
            resultado_pesquisa.getColumnModel().getColumn(2).setHeaderValue(Lingua.getMensagem("ano"));
            resultado_pesquisa.getColumnModel().getColumn(3).setResizable(false);
            resultado_pesquisa.getColumnModel().getColumn(3).setHeaderValue(Lingua.getMensagem("valor_inicial"));
        }

        CLIENTE_NOME.setFont(FonteFinancas);
        CLIENTE_NOME.setText(Lingua.getMensagem("mes")+":");

        BFiltrar.setFont(FonteFinancas);
        BFiltrar.setText(Lingua.getMensagem("pesquisar"));
        BFiltrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BFiltrarActionPerformed(evt);
            }
        });

        mes.setFont(FonteFinancas);
        mes.setModel(new javax.swing.DefaultComboBoxModel(new String[] { Lingua.getMensagem("todos"), "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12" }));
        mes.setRequestFocusEnabled(false);
        mes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mesActionPerformed(evt);
            }
        });

        CLIENTE_NOME1.setFont(FonteFinancas);
        CLIENTE_NOME1.setText(Lingua.getMensagem("ano")+":");

        ano.setFont(FonteFinancas);
        ano.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                anoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pesquisar_vendaLayout = new javax.swing.GroupLayout(pesquisar_venda);
        pesquisar_venda.setLayout(pesquisar_vendaLayout);
        pesquisar_vendaLayout.setHorizontalGroup(
            pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pesquisar_vendaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(scroll_pesquisa, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(pesquisar_vendaLayout.createSequentialGroup()
                        .addComponent(CLIENTE_NOME1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ano)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(CLIENTE_NOME)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(mes, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(BFiltrar)))
                .addContainerGap())
        );
        pesquisar_vendaLayout.setVerticalGroup(
            pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pesquisar_vendaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pesquisar_vendaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(CLIENTE_NOME)
                    .addComponent(mes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(CLIENTE_NOME1)
                    .addComponent(ano, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(BFiltrar))
                .addGap(18, 18, 18)
                .addComponent(scroll_pesquisa, javax.swing.GroupLayout.DEFAULT_SIZE, 297, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(BarraDeFerramentas, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(pesquisar_venda, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(BarraDeFerramentas, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pesquisar_venda, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        setSize(new java.awt.Dimension(582, 480));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

private void BFiltrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFiltrarActionPerformed
    Filtrar();
}//GEN-LAST:event_BFiltrarActionPerformed

private void resultado_pesquisaMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resultado_pesquisaMouseClicked
    String codSelecionado0;
    String codSelecionado1;
    String codSelecionado2;
    String codSelecionado3;
    codSelecionado0 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 0);
    codSelecionado1 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 1);
    codSelecionado2 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 2);
    codSelecionado3 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 3);
    if(Janelinha.Pergunta(codSelecionado1, Lingua.getMensagem("tem_certeza"))){
        Planejamento.PreencherFormulario(Acao, codSelecionado0, Integer.parseInt(codSelecionado1), codSelecionado2, codSelecionado3);
        PlanejamentoPesquisar.this.dispose();
    }
}//GEN-LAST:event_resultado_pesquisaMouseClicked

private void mesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mesActionPerformed
    Filtrar();    // TODO add your handling code here:
}//GEN-LAST:event_mesActionPerformed

private void anoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_anoActionPerformed
    Filtrar();    // TODO add your handling code here:
}//GEN-LAST:event_anoActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFiltrar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JLabel CLIENTE_NOME;
    private javax.swing.JLabel CLIENTE_NOME1;
    private javax.swing.JTextField ano;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JComboBox mes;
    private javax.swing.JPanel pesquisar_venda;
    private javax.swing.JTable resultado_pesquisa;
    private javax.swing.JScrollPane scroll_pesquisa;
    // End of variables declaration//GEN-END:variables

}
