/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package PreRelatorios;

import Biblioteca.Botoes;
import Biblioteca.Calendario;
import Biblioteca.JanelaModal;
import Biblioteca.Janelinha;
import Biblioteca.Visual;
import Relatorios.RReceitas;
import java.text.ParseException;

public class PreReceitas extends JanelaModal {

    private final RReceitas Relatorio = new RReceitas();

    public PreReceitas(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        Visual.JanelaModal(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
    }

    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair")))
        {
            PreReceitas.this.dispose();
        }
    }

    public void Receitas() throws ParseException
    {
        String DataInicial = data_inicial.getSelectedItem().toString();
        String tmp[] = DataInicial.split("/");
        DataInicial = tmp[2]+"-"+tmp[1]+"-"+tmp[0];
        String DataFinal = data_final.getSelectedItem().toString();
        String tmp2[] = DataFinal.split("/");
        DataFinal = tmp2[2]+"-"+tmp2[1]+"-"+tmp2[0];
        Relatorio.RReceitas(DataInicial,DataFinal);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BarraDeFerramentas = new javax.swing.JToolBar();
        INICIO = new javax.swing.JLabel();
        BFiltrar = new javax.swing.JButton();
        FINAL = new javax.swing.JLabel();
        TEXTO = new javax.swing.JLabel();
        data_inicial = new Calendario(true);
        data_final = new Calendario(true);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("receitas")+" > "+Lingua.getMensagem("periodo_categoria"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        getContentPane().setLayout(null);

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);
        getContentPane().add(BarraDeFerramentas);
        BarraDeFerramentas.setBounds(0, 0, 390, 41);

        INICIO.setFont(FonteFinancas);
        INICIO.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        INICIO.setText(Lingua.getMensagem("inicio")+":");
        getContentPane().add(INICIO);
        INICIO.setBounds(70, 90, 79, 20);

        BFiltrar.setFont(FonteFinancas);
        BFiltrar.setText(Lingua.getMensagem("gerar"));
        BFiltrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BFiltrarActionPerformed(evt);
            }
        });
        getContentPane().add(BFiltrar);
        BFiltrar.setBounds(160, 150, 110, 20);

        FINAL.setFont(FonteFinancas);
        FINAL.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FINAL.setText(Lingua.getMensagem("fim")+":");
        getContentPane().add(FINAL);
        FINAL.setBounds(60, 120, 80, 20);

        TEXTO.setFont(FonteFinancasPequena);
        TEXTO.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        TEXTO.setText(Lingua.getMensagem("mensagem_relatorio")+":");
        getContentPane().add(TEXTO);
        TEXTO.setBounds(0, 50, 380, 20);

        data_inicial.setFont(FonteFinancas);
        getContentPane().add(data_inicial);
        data_inicial.setBounds(160, 90, 110, 20);

        data_final.setFont(FonteFinancas);
        getContentPane().add(data_final);
        data_final.setBounds(160, 120, 110, 20);

        setSize(new java.awt.Dimension(387, 244));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void BFiltrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFiltrarActionPerformed
        try {
            Receitas();
        } catch (ParseException ex) {
            Janelinha.Aviso((Lingua.getMensagem("erro")), Lingua.getMensagem("excecao")+" "+ex.getMessage());
        }
}//GEN-LAST:event_BFiltrarActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFiltrar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JLabel FINAL;
    private javax.swing.JLabel INICIO;
    private javax.swing.JLabel TEXTO;
    private javax.swing.JComboBox data_final;
    private javax.swing.JComboBox data_inicial;
    // End of variables declaration//GEN-END:variables

}
