#!/usr/bin/env python
#file test_statistics.py
"""Test lyx-remote function from the LyX.lyxserver module

Revision History:

2005-02-23 G. Milde first version with the unittest framework
"""

import os, time
from unittest import TestCase, main 

from LyX.lyxserver import *
from LyX import lyxclient

class lyx_remoteTests(TestCase):
    """Test function lyx_remote() in lyxserver"""
    #
    def test_lyx_remote(self):
        """test the lyx_remote function"""
        client = lyxclient.LyXClient(lyxcmd=True) # do not open lyx for client
        filenames = [os.path.join(os.path.dirname(__file__), "test.lyx"),
                     os.path.join(os.path.dirname(__file__), "test2.lyx")]
        # test without running LyX
        lyx_remote(LYXCMD, filenames)
        self.assert_(client("server-get-name") in filenames)
        client("buffer-close")
        self.assert_(client("server-get-name") in filenames)
        client("buffer-close")
        # # test with running LyX
        time.sleep(0.5)
        lyx_remote(LYXCMD, filenames)
        self.assertEqual(client("server-get-name"), filenames[1])
        client("buffer-close")
        self.assertEqual(client("server-get-name"), filenames[0])
        client("buffer-close")
        client("lyx-quit")
        time.sleep(0.5) # give lyx some response time (adjust to your system)
        self.assertEqual(False, lyx_running())


if __name__ == '__main__':    #run tests if called from command-line
    main()
