; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "bibus"
!define PRODUCT_VERSION "1.5.2"
!define PRODUCT_WEB_SITE "http://bibus-biblio.sourceforge.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\bibus.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; Variables
Var USER   ; user type returned by UserInfo
Var OOoPath ; path to UNO, usually C:\Program Files\OpenOffice.org 2\program
Var OOoURE ; path to URE in OOo3, usually C:\Program Files\OpenOffice.org 3\URE\lib
Var OOoBasis ; path to Basis in OOo3, usually C:\Program Files\OpenOffice.org 3\Basis\program
; bibus.config file
Var bibusConfig

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "WinMessages.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Changing images
!define MUI_WELCOMEFINISHPAGE_BITMAP ..\..\WinInstaller\bibusWelcome.bmp
;!define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_UNWELCOMEFINISHPAGE_BITMAP ..\..\WinInstaller\bibusWelcome.bmp
;!define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP ..\..\WinInstaller\bibusHeaderImage.bmp
;!define MUI_HEADERIMAGE_BITMAP_NOSTRETCH

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "..\Freezed_Bibus\Docs\copying"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro "MUI_PAGE_DIRECTORY"
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "bibus"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Ask about Custom types
page custom types save_types
; Ask about Custom fields
page custom fields save_fields
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
;!define MUI_FINISHPAGE_RUN "" ;"$INSTDIR\bibusStart.pyw"
;!define MUI_FINISHPAGE_RUN_FUNCTION run_bibus ; not a good idea because we are usually logged as Admin
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\Docs\release_notes.txt"
;!define MUI_FINISHPAGE_SHOWREADME_TEXT "Changelog"
!define MUI_FINISHPAGE_LINK "Bibus Web site"
!define MUI_FINISHPAGE_LINK_LOCATION http://bibus-biblio.sourceforge.net
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "Spanish"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}-Win32-Full-Setup.exe"
InstallDir "$PROGRAMFILES\bibus"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT_AS "..\..\WinInstaller\types.ini" "types.ini"
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT_AS "..\..\WinInstaller\fields.ini" "fields.ini"
  
  ; We first check if we are Admin or not
  UserInfo::GetAccountType
  Pop $USER
  ; we display a Warning to user in case he his not Admin
  StrCmp $USER "Admin" +2
  MessageBox MB_OK|MB_ICONINFORMATION \
  "Bibus will be install for the current user only. \
  If you want to install it for all the users, \
  please start the installer with Adminstrator rights."

  ; bibus.config file
  GetTempFileName $bibusConfig
  File "/oname=$bibusConfig" "..\..\WinInstaller\bibus.config"
  
  ; we first try to remove the old install before installing the new version
  ReadRegStr $R0 HKLM "${PRODUCT_UNINST_KEY}" "UninstallString"
  StrCmp $R0 "" done

  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "${PRODUCT_NAME} is already installed. $\n$\nClick `OK` to remove the \
  previous version or `Cancel` to cancel this upgrade." \
  IDOK uninst
  Abort
   
;Run the uninstaller
uninst:
  ClearErrors
  ; Copy the uninstaller to a temp location
  GetTempFileName $0
  CopyFiles $R0 $0
  ;Start the uninstaller using the option to not copy itself
  ExecWait '$0 _?=$INSTDIR'

  IfErrors no_remove_uninstaller
    ; In most cases the uninstall is successful at this point.
    ; You may also consider using a registry key to check whether
    ; the user has chosen to uninstall. If you are using an uninstaller
    ; components page, make sure all sections are uninstalled.
    goto done
  no_remove_uninstaller:
    MessageBox MB_ICONEXCLAMATION \
    "Unable to remove previous version of ${PRODUCT_NAME}"
    Abort

done:
  ; remove the copied uninstaller
  Delete '$0'

FunctionEnd

Function check_OOo
   ; OpenOffice.org2-uno
   ReadRegStr $OOoPath HKLM "SOFTWARE\OpenOffice.org\UNO\InstallPath" ""
   StrCmp $OOoPath "" 0 +2
      MessageBox MB_OK "I did not detect a valid OpenOffice.org2 installation. You won't be able to insert citations in OOo."
   ; OOo URE for OOo3
   ReadRegStr $OOoURE HKLM "SOFTWARE\OpenOffice.org\Layers\OpenOffice.org\3" "UREINSTALLLOCATION"
   ; OOo Basis for OOo3
   ReadRegStr $OOoBasis HKLM "SOFTWARE\OpenOffice.org\Layers\OpenOffice.org\3" "BASISINSTALLLOCATION"
FunctionEnd

Function types
   !insertmacro MUI_HEADER_TEXT "Database" "Custom reference types"
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "types.ini"
FunctionEnd

Function save_types
   !insertmacro MUI_INSTALLOPTIONS_READ $R1 "types.ini" "Field 1" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R2 "types.ini" "Field 2" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R3 "types.ini" "Field 3" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R4 "types.ini" "Field 4" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R5 "types.ini" "Field 5" "State"
   ; now we write bibus.config
   FileOpen $3 "$bibusConfig" a
   FileSeek $3 0 END
   StrCmp $R1 "CUSTOM1" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM1'] = u'$R1'$\r$\n"
   StrCmp $R2 "CUSTOM2" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM2'] = u'$R2'$\r$\n"
   StrCmp $R3 "CUSTOM3" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM3'] = u'$R3'$\r$\n"
   StrCmp $R4 "CUSTOM4" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM4'] = u'$R4'$\r$\n"
   StrCmp $R5 "CUSTOM5" +2 0
   FileWrite $3 "BIBbase.NAME_TYPE['CUSTOM5'] = u'$R5'$\r$\n"
   FileClose $3
FunctionEnd

Function fields
   !insertmacro MUI_HEADER_TEXT "Database" "Custom reference fields"
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "fields.ini"
FunctionEnd

Function save_fields
   !insertmacro MUI_INSTALLOPTIONS_READ $R1 "fields.ini" "Field 1" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R2 "fields.ini" "Field 2" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R3 "fields.ini" "Field 3" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R4 "fields.ini" "Field 4" "State"
   !insertmacro MUI_INSTALLOPTIONS_READ $R5 "fields.ini" "Field 5" "State"
   ; now we write bibus.config
   FileOpen $3 "$bibusConfig" a
   FileSeek $3 0 END
   StrCmp $R1 "Custom1" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom1'] = u'$R1'$\r$\n"
   StrCmp $R2 "Custom2" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom2'] = u'$R2'$\r$\n"
   StrCmp $R3 "Custom3" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom3'] = u'$R3'$\r$\n"
   StrCmp $R4 "Custom4" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom4'] = u'$R4'$\r$\n"
   StrCmp $R5 "Custom5" +2 0
   FileWrite $3 "BIBbase.NAME_FIELD['Custom5'] = u'$R5'$\r$\n"
   FileClose $3
FunctionEnd

Section "bibus" SEC01
  SectionIn RO
  SetOverwrite try
  SetOutPath "$INSTDIR"

  ; looking for OOo2 install
  Call check_OOo
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current

  ; Put file there
  File /r /x Docs /x CVS /x bibus.cfg ..\Freezed_Bibus\*

; generating and writing bibus.cfg file
  SetOutPath $INSTDIR
  WriteINIStr $INSTDIR\bibus.cfg PATH oopath $OOoPath
  WriteINIStr $INSTDIR\bibus.cfg PATH ooure "$OOoUREbin"
  WriteINIStr $INSTDIR\bibus.cfg PATH oobasis "$OOoBasisprogram"

; bibus.config = file in WinInstaller + variables set in wp_leave
  Delete "$INSTDIR\bibus.config"
  Rename "$bibusConfig" "$INSTDIR\bibus.config"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section "Documentation (English)" SEC02
  SetOutPath "$INSTDIR"
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
         
  File /r /x CVS ..\Freezed_Bibus\Docs

  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +4
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\bibus.lnk" "$INSTDIR\bibus.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk" "$INSTDIR\Docs\index.html"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\eTBlast.lnk" "$INSTDIR\Docs\html\en\eTBlast Interface to Bibus.htm"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\MSWord.lnk" "$INSTDIR\Docs\html\en\bibMSW.htm"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "Main program"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Documentation english"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was succesfully removed from your computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to uninstall $(^Name)?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  UserInfo::GetAccountType
  Pop $USER
  ; Setting context depending on USER value
  StrCmp $USER "Admin" 0 +3
         SetShellVarContext all
         GoTo +2
         SetShellVarContext current
    
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
     
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\bibus.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\eTBlast.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\MSWord.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir /r "$INSTDIR"	; remove everything eventually on reboot if in use

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
