#include <string_tokenizer.hpp>
#include <stdio.h>
#include <iostream>
#include <string>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#include <regex.h>

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Progress.H>

using namespace std;

class get_molfile{

protected:
static string the_file;


static int my_progress_func(void* w,
                     double t, /* dltotal */
                     double d, /* dlnow */
                     double ultotal,
                     double ulnow)
{

  Fl_Window* win=reinterpret_cast<Fl_Window*>(w);
  cout <<  "progress: dlnow" <<  d << " dltotal" 
       << t << " "<< d*100.0/t<< "%" << endl;
  dynamic_cast<Fl_Progress*>(win->child(0))->maximum(static_cast<float>(400.0));
  dynamic_cast<Fl_Progress*>(win->child(0))->minimum(0);
  dynamic_cast<Fl_Progress*>(win->child(0))->value(static_cast<float>(d/t*400.0));
  win->redraw();
  Fl::check();
  return 0;
}


static int my_fwrite(void *buffer, size_t size, size_t nmemb, void *stream)
{
  char* ch=static_cast<char*>(buffer);
  for(unsigned int i=0; i< nmemb ;i++){
    for(unsigned int i2=0;i2<size;i2++){
      get_molfile::the_file+=ch[i+i2];
    }
  }
  //  sleep(1);
  return nmemb;
}

static string get_curl_file(string the_url,Fl_Window* progressw){
  get_molfile::the_file="";
  CURL *curl;
  CURLcode res;
  curl_global_init(CURL_GLOBAL_DEFAULT);

  curl = curl_easy_init();
  if(curl) {

    curl_easy_setopt(curl, CURLOPT_URL,
                     the_url.c_str());
    /* Define our callback to get called when there's data to be written */
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, my_fwrite);

    /* Switch on full protocol/debug output */
    curl_easy_setopt(curl, CURLOPT_VERBOSE, 1 );
    curl_easy_setopt(curl,CURLOPT_NOPROGRESS,0);
    curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, my_progress_func);
    curl_easy_setopt(curl, CURLOPT_PROGRESSDATA, progressw);


    res = curl_easy_perform(curl);


    /* always cleanup */
    curl_easy_cleanup(curl);

    if(CURLE_OK != res) {
      /* we failed */
      //fl_alert("Unable to get file from %s", the_url.c_str());
      return string("");
    }
  }
  /*
  cout << "***************************************" << endl;

  cout << the_file << endl;
  */
  curl_global_cleanup();
  return get_molfile::the_file;
}

public:

static string get_web_molfile(string filename,Fl_Window* progressw){
  string delim=" ";
  string_tokenizer tok(filename , delim);
  string filename_enc="";
  if(filename.find(' ')!=string::npos){
    while(!tok){
      filename_enc+=tok.next_token();
    }
  }else{
    filename_enc=filename;
  }

  string urlfetch="http://webbook.nist.gov/cgi/cbook.cgi?Name="+ 
    filename_enc + "&Units=SI";
  string molfile="";


  //string urlfetch="http://localhost/~cage/benzene.html";
  //string urlfetch="http://www2.autistici.org/interzona/";
  //cout << urlfetch << endl;
  string catalog=get_curl_file(urlfetch,progressw);

  regex_t weblink;
  regmatch_t result[1];
  
  //  This structure is also available as a 
  //<a href="/cgi/cbook.cgi/71-43-2-2d.mol?Str2File=C71432">2d Mol file</a>
  

  regcomp(&weblink, "/cgi/cbook.cgi/.\\+2d\\.mol.\\+\\\"",REG_NEWLINE);
  int error=regexec(&weblink, catalog.c_str(),1, result, 0);
  if(error==0){
    string link="http://webbook.nist.gov" + catalog.substr(result[0].rm_so,(result[0].rm_eo-1)-result[0].rm_so);
    //cout << link << endl;
    molfile=get_curl_file(link,progressw);
  }else{
    char error_re[72];
    regerror (error,&weblink,error_re,72); 
    //fl_alert("Error fetching %s", error_re);
  }
  regfree(&weblink);
  
  
  
  
  //string molfile=get_curl_file("http://localhost/~cage/benz.mol",progressw);
  return molfile;
}

};

string get_molfile::the_file="";

/*
int main(){
  cout << get_molfile::get_web_molfile("benzene") << endl;
  return 0;
}
*/
