/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>
#include <config_path.h>
#include <global.hpp>


#include <wordexp.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>


#include <cairo/cairo.h>
#include <cairo-ps.h>
#include <pango/pangocairo.h>
#include <glib.h>
#include <cairo_t_singleton.hpp>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <util.hpp>



extern finestra_pr* __la_finestra;

extern Preferences  __pref;




bist_plugin::bist_plugin(immagine* imm,string libpath)
  :_lib(libpath)
{
  _the_image=imm;
}

bist_plugin::~bist_plugin(){
  cout << "bist_plugin distr:" << endl;
}

string bist_plugin::libpath(){
  return _lib;
}

vector <etichetta*>*  bist_plugin::r_etich(){
  return & _the_image->_stringhe;
}

vector <gruppo>* bist_plugin::r_groups(){
  return &_the_image->_gruppi;
}
  
vector< pair < int, pair<int,int> > >*  bist_plugin::r_elem_selected(){
  //cout << "bist plugin says " << _the_image << " " << _the_image->_elem_selected.size() << " ";
  return &_the_image->_elem_selected;
}

vector<int*>* bist_plugin::r_legami_selected(){
  return &_the_image->_legami_selected;
}

void bist_plugin::image(immagine* imm){
  _the_image=imm;
}
