GAMEDIR=../../Game/

BINARY=$(GAMEDIR)blockattack.exe

CC=i586-mingw32msvc-gcc

CPP=i586-mingw32msvc-g++

BASE_CFLAGS=-c $(shell sdl-config --cflags)


BASE_LIBS=$(shell sdl-config --libs) -lSDL_image -lSDL_mixer -lSDL_ttf

#For developement only 
ifndef DEBUG
DEBUG=1
endif

ifndef NETWORK
NETWORK=1
endif

#Never use the apstract fs, it is not implemented and just linking it breaks on some systems
ifndef USE_ABSTRACT_FS
USE_ABSTRACT_FS=0
endif

#Compile with debug information or optimized.
ifeq ($(DEBUG),1)
BASE_CFLAGS += -g -DDEBUG=1
else
BASE_CFLAGS += -O4
endif

ifeq ($(NETWORK),1)
BASE_CFLAGS += -DNETWORK=1
BASE_LIBS += -lenet
else
BASE_CFLAGS += -DNETWORK=0
endif

ifeq ($(USE_ABSTRACT_FS),1)
BASE_CFLAGS += -DUSE_ABSTRACT_FS=1
BASE_LIBS += -lphysfs
else
BASE_CFLAGS += -DUSE_ABSTRACT_FS=0
endif

$(BINARY): 	winbuild/main.o winbuild/highscore.o winbuild/SFont.o winbuild/ReadKeyboard.o winbuild/joypad.o winbuild/listFiles.o winbuild/replay.o winbuild/common.o winbuild/stats.o winbuild/uploadReplay.o
	$(CPP) -O -o $(BINARY) winbuild/main.o winbuild/highscore.o winbuild/SFont.o winbuild/ReadKeyboard.o winbuild/joypad.o winbuild/listFiles.o winbuild/replay.o winbuild/common.o winbuild/stats.o $(BASE_LIBS)
#-lphysfs

winbuild/main.o:	main.cpp BlockGame.hpp mainVars.hpp common.h
	$(CPP) $(BASE_CFLAGS) main.cpp -o winbuild/main.o

winbuild/highscore.o: highscore.h highscore.cpp
	$(CPP) $(BASE_CFLAGS) highscore.cpp -o winbuild/highscore.o

winbuild/SFont.o: SFont.h SFont.c
	$(CC) $(BASE_CFLAGS) SFont.c -o winbuild/SFont.o

winbuild/ReadKeyboard.o: ReadKeyboard.h ReadKeyboard.cpp
	$(CPP) $(BASE_CFLAGS) ReadKeyboard.cpp -o winbuild/ReadKeyboard.o

winbuild/joypad.o: joypad.h joypad.cpp
	$(CPP) $(BASE_CFLAGS) joypad.cpp -o winbuild/joypad.o

winbuild/listFiles.o: listFiles.h listFiles.cpp
	$(CPP) $(BASE_CFLAGS) listFiles.cpp -o winbuild/listFiles.o

winbuild/replay.o: replay.h replay.cpp
	$(CPP) $(BASE_CFLAGS) replay.cpp -o winbuild/replay.o

winbuild/stats.o: stats.h stats.cc
	$(CPP) $(BASE_CFLAGS) stats.cc -o winbuild/stats.o

winbuild/common.o: common.h common.cc
	$(CPP) $(BASE_CFLAGS) common.cc -o winbuild/common.o

winbuild/uploadReplay.o: uploadReplay.cc uploadReplay.h
	$(CPP) $(BASE_CFLAGS) uploadReplay.cc -o winbuild/uploadReplay.o

#winbuild/MenuSystem.o: MenuSystem.cc MenuSystem.h
#	$(CPP) $(BASE_CFLAGS) MenuSystem.cc -o winbuild/MenuSystem.o

#winbuild/ttfont.o: ttfont.h ttfont.cc
#	$(CPP) $(BASE_CFLAGS) ttfont.cc -o winbuild/ttfont.o


run: $(BINARY)

clean:
	rm winbuild/*o
