package org.codehaus.mojo.buildhelper;

/*
 * The MIT License
 *
 * Copyright (c) 2004, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

import java.io.File;

/**
 * Add test source directories to the POM.
 *
 * @goal add-test-source
 * @phase generate-test-sources
 * @author <a href="dantran@gmail.com">Dan T. Tran</a>
 * @version $Id: AddTestSourceMojo.java 7305 2008-07-24 14:34:13Z dantran $
 * @since 1.0
 */
public class AddTestSourceMojo
    extends AbstractMojo
{
    /**
     * Additional test source directories.
     *
     * @parameter 
     * @required
     * @since 1.0
     * 
     */
    private File [] sources;

    /**
     * @parameter expression="${project}"
     * @required
     * @readonly
     * @since 1.0
     */
    private MavenProject project;


    public void execute()
        throws MojoExecutionException
    {        
        for ( int i = 0; i < sources.length; ++i )
        {
            this.project.addTestCompileSourceRoot( this.sources[i].getAbsolutePath() );
                
            this.getLog().info( "Test Source directory: " + this.sources[i] + " added." );              
        }
    }
}
