#!/bin/bash
<<ENDCOMMENT >/dev/null
/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
ENDCOMMENT

cd mml/mmlIn/Sofa/
for i in *.mml ; do
  benchmark $i sofa > out.tmp 2> err.tmp
  if (test -e ../../mmlOut/Sofa/$i) then
     if (diff -q ../../mmlOut/Sofa/$i Output.mml) then
        echo -e "\033[32;01m" $i " PASSED " "\033[00m"
     else 
        echo -e "\033[31;01m" $i " FAILED " "\033[00m"
     fi
  else
     echo -e "\033[31;01m" $i ": no saved mmlOut file to compare to" "\033[00m"
  fi
  rm -f Output.mml out.tmp err.tmp
done
