#
# 	Construction et gestion des outils
# 	(c) 1995-7 Jean Piche
# 	v. 1.80a (10/08/97)
#

proc makeTools2 {} {
global color ffont fffont  ceclib lan   initGraph prefs tcl_platform dpi

    set to [toplevel .win -bd 0   -bd 0 -menu .menubar]
    set t [frame .win.ff -relief groove -bd 2 ]
    # MacOS only (transient equivalent)
    if {$tcl_platform(platform) == "macintosh"} {unsupported1 style .win floatProc}
    
    wm title .win Tools
    wm minsize .win 123 216
    wm maxsize .win 123 216
    .win config -menu {}
    wm protocol .win WM_DELETE_WINDOW "destroy .win;set prefs(tools) 0;\
	 pack .pre.too -side top -before .pre.grap -expand n -fill x" 

    bindtoo

    frame $t.f3 
    foreach im {sines square  drunks rand  scatt} {
    	label $t.f3.$im -image $im  -bd 0 
    	pack $t.f3.$im -side top -anchor c -padx 2 -pady 2
    }

    frame $t.f1 
    foreach im {up1  down1 comp normal} {
    	label $t.f1.$im -image $im  -bd 0 
    	pack $t.f1.$im -side top -anchor c -padx 2 -pady 2
    }

    frame $t.f7 
    foreach im {cut copy paste reset imp exp} {
    	label $t.f7.$im -image $im  -bd 0 
    	pack $t.f7.$im -side top -anchor c  -padx 2 -pady 2
    }
        
    pack $t.f7 $t.f3  $t.f1  -side left -expand y -fill both -anchor c -padx 2 -pady 2
    pack $t -side top -expand y -fill both -anchor c -padx 2 -pady 2 	

    bindtools2 $t

	bind $t.f3.drunks 	<ButtonPress-1>  {drunk  $fDat(drunkpoints) $fDat(drunkwalk) $fDat(drunktype) }
	bind $t.f3.square 		<ButtonPress-1> {linseg $fDat(sawfreq) $fDat(sawamp) $fDat(osctype) $fDat(sawwidth) $fDat(inv)}
	bind $t.f3.rand    <ButtonPress-1> {noise $fDat(noisepoints) $fDat(noiseamp) $fDat(noisetype)}
	bind $t.f3.sines   <ButtonPress-1> {sine $fDat(sinpoints) $fDat(sinfreq) $fDat(sinamp) $fDat(sinphase)}
	bind $t.f3.scatt   <ButtonPress-1> {randomize actif  $fDat(ampx) $fDat(ampy) $fDat(scatype)}
	bind $t.f1.normal  <ButtonPress-1>  {normalize actif $fDat(scaley)}   
	bind $t.f1.comp    <ButtonPress-1>  {compress actif $fDat(scalex)}   

	bind $t.f7.copy    <ButtonPress-1>  gcopie
	bind $t.f7.cut     <ButtonPress-1>  gcut
	bind $t.f7.paste   <ButtonPress-1>  gpaste
	bind $t.f7.reset   <ButtonPress-1>  gclear
	bind $t.f7.imp     <ButtonPress-1> {saveActifGraph}
	bind $t.f7.exp     <ButtonPress-1>  {openActifGraph}
	bind $t.f1.up1     <ButtonPress-1> "nodge actif -1"      
	bind $t.f1.down1   <ButtonPress-1> "nodge actif 1"      

	bindHelp $t.f3.drunks	bToolsDrunk
	bindHelp $t.f3.square	bToolsSquare
	bindHelp $t.f3.rand	bToolsRand
	bindHelp $t.f3.sines	bToolsSines
	bindHelp $t.f3.scatt	bToolsScatt
	bindHelp $t.f1.normal	bToolsNormal
	bindHelp $t.f1.comp	bToolsComp
	bindHelp $t.f7.copy	bToolsCopy
	bindHelp $t.f7.cut	bToolsCut
	bindHelp $t.f7.paste	bToolsPaste
	bindHelp $t.f7.reset	bToolsReset
	bindHelp $t.f7.imp	bToolsImp
	bindHelp $t.f7.exp	bToolsExp
	bindHelp $t.f1.up1	bToolsUp1
	bindHelp $t.f1.down1	bToolsDown1
}

proc makeTools {} {
global color ffont fffont  ceclib    lan util prefs dpi
    set util [frame .pre.too  -relief groove -bd 2 ]
    set t $util
    frame $util.f0
	image create photo win -file [file join $ceclib graphics $dpi zcen.gif]        
	button $util.f0.win -image win -relief groove -bd 1   \
	    -command {pack forget .pre.too;set prefs(tools) 1; makeTools2}
 	pack $util.f0.win -side left -anchor w -padx 2
	pack $util.f0 -side left  -pady 2 -anchor w  -padx 2
 
    frame $t.f7 
    foreach im {cut copy paste reset imp exp} {
    	button $t.f7.$im -image $im -bd 0		  
    	pack $t.f7.$im -side left -anchor w  -padx 2
    }

    frame $t.f1 
    foreach im {up1 down1} {
    	button $t.f1.$im -image $im -bd 0
    	pack $t.f1.$im -side left -anchor c  -padx 2
    }
        
    frame $t.f3 
    foreach im {sines square drunks rand scatt} {
    	button $t.f3.$im -image $im  -bd 0
    	pack $t.f3.$im -side left -anchor c  -padx 2
    }
        
    frame $t.f5 
    foreach im {comp normal } {
    	button $t.f5.$im -image $im  -bd 0\    		 
    	pack $t.f5.$im -side left -anchor w -padx 4
    }
    
    pack  $t.f7 $t.f1  $t.f3 $t.f5 $util -side left -expand y -pady 3 -padx 10

	bindtools $t

	$t.f3.drunks config -command {drunk  $fDat(drunkpoints) $fDat(drunkwalk) $fDat(drunktype) }
	$t.f3.square config -command {linseg $fDat(sawfreq) $fDat(sawamp) $fDat(osctype) $fDat(sawwidth) $fDat(inv)}
	$t.f3.rand config   -command {noise $fDat(noisepoints) $fDat(noiseamp) $fDat(noisetype)}
	$t.f3.sines config  -command {sine $fDat(sinpoints) $fDat(sinfreq) $fDat(sinamp) $fDat(sinphase)}
	$t.f3.scatt config  -command {randomize actif  $fDat(ampx) $fDat(ampy) $fDat(scatype)}
	$t.f5.normal config -command {normalize actif $fDat(scaley)}   
	$t.f5.comp config   -command {compress actif $fDat(scalex)}   

	$t.f7.copy config   -command gcopie
	$t.f7.cut config    -command gcut
	$t.f7.paste config  -command gpaste
	$t.f7.reset config  -command gclear
	$t.f7.imp config    -command {saveActifGraph}
	$t.f7.exp config    -command {openActifGraph}
	$t.f1.up1 config    -command "nodge actif -1"      
	$t.f1.down1 config  -command "nodge actif 1"   
   
	bindHelp $t.f3.drunks	bToolsDrunk
	bindHelp $t.f3.square	bToolsSquare
	bindHelp $t.f3.rand	bToolsRand
	bindHelp $t.f3.sines	bToolsSines
	bindHelp $t.f3.scatt	bToolsScatt
	bindHelp $t.f5.normal	bToolsNormal
	bindHelp $t.f5.comp	bToolsComp
	bindHelp $t.f7.copy	bToolsCopy
	bindHelp $t.f7.cut	bToolsCut
	bindHelp $t.f7.paste	bToolsPaste
	bindHelp $t.f7.reset	bToolsReset
	bindHelp $t.f7.imp	bToolsImp
	bindHelp $t.f7.exp	bToolsExp
	bindHelp $t.f1.up1	bToolsUp1
	bindHelp $t.f1.down1	bToolsDown1

}

proc makerandBox {} {
global color ffont fffont click lan fDat cfont
    if [winfo exists .noise] { wm deiconify .noise;raise .noise;return}
    set t [toplevel .noise -bd 5  -relief ridge]
    wm minsize .noise 375 120
    frame $t.sli 
   frame $t.rad 
    label $t.rad.l -text "Shape:" -font $cfont(small) -width 13  
    radiobutton $t.rad.1 -text ramp -font $cfont(small) -value rm -variable fDat(noisetype)		  
    radiobutton $t.rad.2 -text square -font $cfont(small) -value sq -variable fDat(noisetype) 
    pack  $t.rad.l $t.rad.1 $t.rad.2 -side left
    pack  $t.rad -side top
    foreach sli {points amp} {
	frame $t.sli.$sli  -bd 2 -relief groove
	label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
	scale $t.sli.$sli.$sli -showvalue 0  -orient horizontal -length 150 -width 8 
	label $t.sli.$sli.lab$sli -textvariable fDat(noise$sli) -font $cfont(small) -width 8 
	pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
	pack $t.sli.$sli -side top -padx 5  -expand 1 -fill x
	pack config $t.sli.$sli.$sli  -expand 1 -fill x
	}
    $t.sli.points.points config -variable fDat(noisepoints)	-from 1 -to 150
    $t.sli.amp.amp config -variable fDat(noiseamp) -resolution .01 -from 0.01 -to 1 
    $t.sli.amp.amp set 1
    pack  $t.sli -side top -pady 3   -expand 1 -fill x
    frame $t.ex  -bd 2 -relief groove
	button $t.ex.ok -text $lan(nom15a) \
	    -command "destroy .noise "\
	    -font $cfont(small)
	button $t.ex.app -text $lan(nom15b) \
	    -command {noise $fDat(noisepoints) $fDat(noiseamp) $fDat(noisetype)}\
	    -font $cfont(small) 
	pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
	pack $t.ex.app -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
	if ![info exists fDat(noisetype)] {set fDat(noisetype) rm}
}

proc makenormBox {} {
global color ffont fffont click lan fDat cfont

    if [winfo exists .norm] { wm deiconify .norm;raise .norm;return}
    set t [toplevel .norm -bd 5  -relief ridge]
    wm minsize .norm 375 120
    frame $t.sli 
    foreach sli {scale-y } {
	frame $t.sli.$sli  -bd 2 -relief groove
	label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
	scale $t.sli.$sli.$sli -showvalue 0 -from 0.01 -to 1 -resolution 0.01 -variable fDat(scaley) \
		-highlightthickness 0  -orient horizontal -length 150 -width 8  
	label $t.sli.$sli.lab$sli -textvariable fDat(scaley) -font $cfont(small) -width 8 
	pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
	pack $t.sli.$sli -side top -padx 5  -expand 1 -fill x
	pack config $t.sli.$sli.$sli  -expand 1 -fill x
	}
     pack  $t.sli -side top -pady 3  -expand 1 -fill x
    frame $t.ex  -bd 2 -relief groove
	button $t.ex.ok -text $lan(nom15a) \
	    -command "destroy .norm "\
	    -font $cfont(small) 
	button $t.ex.app -text $lan(nom15b) \
	    -command {normalize actif $fDat(scaley)}\
	    -font $cfont(small) 
	pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
	pack $t.ex.app -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
}


proc makecompBox {} {
global color ffont fffont click lan fDat cfont
    if [winfo exists .comp] { wm deiconify .comp;raise .comp;return}
    set t [toplevel .comp -bd 5  -relief ridge]
    wm minsize .comp 375 120
    frame $t.sli 
    foreach sli {scale-x } {
	frame $t.sli.$sli  -bd 2 -relief groove
	label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
	scale $t.sli.$sli.$sli -showvalue 0 -from -0.5 -to 0.5 -resolution 0.01 \
		-variable fDat(scalex)  -orient horizontal -length 150 -width 8  
	label $t.sli.$sli.lab$sli -textvariable fDat(scalex) -font $cfont(small) -width 8 
	pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
	pack $t.sli.$sli -side top -padx 5 -expand 1 -fill x
	pack config $t.sli.$sli.$sli  -expand 1 -fill x
	}
     pack  $t.sli -side top -pady 3  -expand 1 -fill x
     frame $t.ex  -bd 2 -relief groove
	button $t.ex.ok -text $lan(nom15a) \
	    -command "destroy .comp "\
	    -font $cfont(small) 
	button $t.ex.app -text $lan(nom15b) \
	    -command {compress actif $fDat(scalex)}\
	    -font $cfont(small)
	pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
	pack $t.ex.app -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
}

proc makescattBox {} {
global color ffont cfont click lan fDat
    if [winfo exists .scatt] { wm deiconify .scatt;raise .scatt;return}
    set t [toplevel .scatt -bd 5  -relief ridge]
    wm minsize .scatt 375 180
    frame $t.sli 
    frame $t.rad 
    label $t.rad.l -text "Shape:" -font $cfont(small) -width 13  
    radiobutton $t.rad.1 -text ramp -font $cfont(small) -value rm -variable fDat(scatype)		  
    radiobutton $t.rad.2 -text square -font $cfont(small) -value sq -variable fDat(scatype) 
    radiobutton $t.rad.3 -text random -font $cfont(small) -value rnd -variable fDat(scatype) 
    pack  $t.rad.l $t.rad.1 $t.rad.2 $t.rad.3 -side left
    pack  $t.rad -side top
 
	frame $t.sli.points  -bd 2 -relief groove
	label $t.sli.points.nampoints -text "# points" -font $cfont(small) -width 8 
	scale $t.sli.points.points -showvalue 0 -resolution .001 -from 0 -to 1 \
		-variable fDat(amppoints)  -orient horizontal -length 150 -width 8  
	label $t.sli.points.labpoints -textvariable fDat(amppoints) \
		-font $cfont(small) -width 8 
	button $t.sli.points.ok -text resample \
		-command {resample actif  $fDat(amppoints)} -font $cfont(small) -width 7   -height 1
	pack  $t.sli.points.nampoints $t.sli.points.points $t.sli.points.labpoints $t.sli.points.ok -side left -pady 3 
	pack $t.sli.points -side top -padx 5 -fill x -expand 1
	pack config $t.sli.points.points	 -expand 1 -fill x
	
    foreach sli { x y } {
		frame $t.sli.$sli  -bd 2 -relief groove
		label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
		scale $t.sli.$sli.$sli -showvalue 0 -resolution .001 -from 0 -to 1 -variable fDat(amp$sli)\
			-highlightthickness 0  -orient horizontal -length 150 -width 8  
		label $t.sli.$sli.lab$sli -textvariable fDat(amp$sli) -font $cfont(small) -width 8 
		button $t.sli.$sli.ok -text scatter-$sli \
			-command {resample actif  $fDat(amppoints)} -font $cfont(small) -width 7  -height 1
		pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli $t.sli.$sli.ok -side left -pady 3 
		pack $t.sli.$sli -side top -padx 5 -expand 1 -fill x
		pack config $t.sli.$sli.$sli	 -expand 1 -fill x
    }
    $t.sli.points.points config -resolution 1 -from 2 -to 150
    $t.sli.x.ok config -command {randomize actif $fDat(ampx) 0.0 $fDat(scatype)}
    $t.sli.y.ok config -command {randomize actif 0.0 $fDat(ampy) $fDat(scatype)}
    $t.sli.x.x set .01
    $t.sli.y.y set .01
    $t.sli.points.points set 10
    pack  $t.sli -side top -pady 3 -expand 1 -fill x
    frame $t.ex  -bd 2 -relief groove
	button $t.ex.ok -text $lan(nom15a) \
	    -command "destroy .scatt "\
	    -font $cfont(small) 
	pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
	pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
    bind $t.sli.points.points <ButtonRelease-1>	  {resample actif  $fDat(amppoints)}
    if ![info exists fDat(scatype)] {set fDat(scatype) rnd}

}

proc makedrunksBox {} {
global color ffont cfont click lan fDat
    if [winfo exists .drunk] {wm deiconify .drunk; raise .drunk;return}
    set t [toplevel .drunk -bd 5  -relief ridge]
    wm minsize .drunk 375 140
    frame $t.rad 
    label $t.rad.l -text "First point:" -font $cfont(small) -width 13  
    radiobutton $t.rad.1 -text existing -font $cfont(small) -value static -variable fDat(drunktype)		  
    radiobutton $t.rad.2 -text random -font $cfont(small) -value rand -variable fDat(drunktype) 
    pack  $t.rad.l $t.rad.1 $t.rad.2 -side left
    pack $t.rad -side top -expand 1 -fill x
    frame $t.sli 
    foreach sli {points walk} {
	frame $t.sli.$sli  -bd 2 -relief groove
	label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
	scale $t.sli.$sli.$sli -showvalue 0  -orient horizontal -length 150 -width 8  
	label $t.sli.$sli.lab$sli -textvariable fDat(drunk$sli) -font $cfont(small) -width 8 
	pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
	pack $t.sli.$sli -side top -padx 5 -expand 1 -fill x
	pack config $t.sli.$sli.$sli -expand 1 -fill x
	}
    $t.sli.points.points config -variable fDat(drunkpoints)	-from 2 -to 150
    $t.sli.walk.walk config  -variable fDat(drunkwalk)  -resolution .01 -from 0.01 -to 1 	
    $t.sli.walk.walk set .2
    pack  $t.sli -side top -pady 3 -expand 1 -fill x
    frame $t.ex  -bd 2 -relief groove
    button $t.ex.ok -text $lan(nom15a) \
	-command "destroy .drunk "\
	-font $cfont(small) 
    button $t.ex.app -text $lan(nom15b) \
	-command {drunk $fDat(drunkpoints) $fDat(drunkwalk) $fDat(drunktype) }\
	-font $cfont(small) 
    pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
    pack $t.ex.app -side left -expand 1 -anchor e -padx 5 -pady 5
    pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
}

proc makesinesBox {} {
global color ffont cfont click lan fDat
    if [winfo exists .sine] {wm deiconify .sine;raise .sine;return}
    set t [toplevel .sine -bd 5  -relief ridge]
    wm minsize .sine 375 170
    frame $t.sli 
    foreach sli {points freq amp phase} {
	frame $t.sli.$sli  -bd 2 -relief groove
	label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
	scale $t.sli.$sli.$sli -showvalue 0 -variable fDat(sin$sli) -orient horizontal -length 150 -width 8  
	label $t.sli.$sli.lab$sli -textvariable fDat(sin$sli) -font $cfont(small) -width 8 
	pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
	pack $t.sli.$sli -side top -padx 5 -expand 1 -fill x
	pack config $t.sli.$sli.$sli -expand 1 -fill x
	}
    $t.sli.points.points config  -from 2 -to 150
    $t.sli.freq.freq config   -resolution .01 -from 0.01 -to 20	
    $t.sli.amp.amp config     -resolution .01 -from 0.01 -to 1	
    $t.sli.phase.phase config   -resolution 1 -from 0 -to 360
    $t.sli.freq.freq set   1	
    $t.sli.amp.amp set    1	
    $t.sli.phase.phase set   0
	
    pack  $t.sli -side top -pady 3 -expand 1 -fill x
    frame $t.ex  -bd 2 -relief groove
	button $t.ex.ok -text $lan(nom15a) \
	    -command "destroy .sine "\
	    -font $cfont(small) 
	button $t.ex.app -text $lan(nom15b) \
	    -command {sine $fDat(sinpoints) $fDat(sinfreq) $fDat(sinamp) $fDat(sinphase)}\
	    -font $cfont(small) 
	pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
	pack $t.ex.app -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
}

proc makesawBox {} {
global color ffont cfont click lan fDat
    if [winfo exists .saw] { wm deiconify .saw; raise .saw;return}
    set t [toplevel .saw -bd 5  -relief ridge]
    wm minsize .saw 375 170
    frame $t.rad 
	radiobutton $t.rad.1 -text Pulse  -font $cfont(small) -value q -variable fDat(osctype)   
	radiobutton $t.rad.2 -text Ramp   -font $cfont(small) -value r -variable fDat(osctype)   
	checkbutton $t.rad.3 -text Invert -font $cfont(small)  -variable fDat(inv)   
	pack  $t.rad.1 $t.rad.2 $t.rad.3 -side left
	pack $t.rad -side top -expand 1 -fill x
    frame $t.sli 
    foreach sli { freq amp width} {
	frame $t.sli.$sli  -bd 2 -relief groove
	label $t.sli.$sli.nam$sli -text $sli -font $cfont(small) -width 8 
	scale $t.sli.$sli.$sli -showvalue 0 -variable fDat(saw$sli) -orient horizontal -length 150 -width 8  
	label $t.sli.$sli.lab$sli -textvariable fDat(saw$sli) -font $cfont(small) -width 8 
	pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
	pack $t.sli.$sli -side top -padx 5 -expand 1 -fill x
	pack config $t.sli.$sli.$sli -expand 1 -fill x
    }
    $t.sli.freq.freq config   -resolution .01 -from .1 -to 50	
    $t.sli.amp.amp config     -resolution .01 -from 0.01 -to 1	
    $t.sli.width.width config     -resolution .01 -from 0.01 -to 0.99	
    $t.sli.freq.freq set   1	
    $t.sli.amp.amp set    1	
    $t.sli.width.width set    .5	
    $t.rad.1 invoke	
    pack  $t.sli -side top -pady 3 -expand 1 -fill x
    frame $t.ex  -bd 2 -relief groove
    button $t.ex.ok -text $lan(nom15a) \
	-command "destroy .saw "\
	-font $cfont(small) 
    button $t.ex.app -text $lan(nom15b) \
	-command {linseg  $fDat(sawfreq) $fDat(sawamp) $fDat(osctype) $fDat(sawwidth) $fDat(inv)}\
	-font $cfont(small) 
    pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
    pack $t.ex.app -side left -expand 1 -anchor e -padx 5 -pady 5
    pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x

}

