// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "WindowFactory.pypp.hpp"

namespace bp = boost::python;

struct WindowFactory_wrapper : CEGUI::WindowFactory, bp::wrapper< CEGUI::WindowFactory > {

    virtual ::CEGUI::Window * createWindow( ::CEGUI::String const & name ){
        bp::override func_createWindow = this->get_override( "createWindow" );
        return func_createWindow( boost::ref(name) );
    }

    virtual void destroyWindow( ::CEGUI::Window * window ){
        bp::override func_destroyWindow = this->get_override( "destroyWindow" );
        func_destroyWindow( boost::python::ptr(window) );
    }

};

void register_WindowFactory_class(){

    { //::CEGUI::WindowFactory
        typedef bp::class_< WindowFactory_wrapper, boost::noncopyable > WindowFactory_exposer_t;
        WindowFactory_exposer_t WindowFactory_exposer = WindowFactory_exposer_t( "WindowFactory", "*!\n\
        \n\
            Abstract class that defines the required interface for all WindowFactory\n\
            objects.\n\
        \n\
            A WindowFactory is used to create and destroy windows of a specific type.\n\
            For every type of Window object wihin the system (widgets, dialogs, movable\n\
            windows etc) there must be an associated WindowFactory registered with the\n\
            WindowFactoryManager so that the system knows how to create and destroy\n\
            those types of Window base object.\n\
        \n\
        \note\n\
            The use if of the CEGUI_DECLARE_WINDOW_FACTORY, CEGUI_DEFINE_WINDOW_FACTORY\n\
            and CEGUI_WINDOW_FACTORY macros is deprecated in favour of the\n\
            template class TplWindowFactory and templatised\n\
            WindowFactoryManager.addFactory function, whereby you no longer need to\n\
            directly create any supporting structure for your new window type, and can\n\
            simply do:\n\
            .\n\
            CEGUI.WindowFactoryManager.addFactory<TplWindowFactory<MyWidget> >();\n\
            \n\n\
        *\n", bp::no_init );
        bp::scope WindowFactory_scope( WindowFactory_exposer );
        { //::CEGUI::WindowFactory::createWindow
        
            typedef ::CEGUI::Window * ( ::CEGUI::WindowFactory::*createWindow_function_type )( ::CEGUI::String const & ) ;
            
            WindowFactory_exposer.def( 
                "createWindow"
                , bp::pure_virtual( createWindow_function_type(&::CEGUI::WindowFactory::createWindow) )
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a new Window object of whatever type this WindowFactory produces.\n\
            \n\
                @param name\n\
                    A unique name that is to be assigned to the newly created Window object\n\
            \n\
                @return\n\
                    Pointer to the new Window object.\n\
                *\n" );
        
        }
        { //::CEGUI::WindowFactory::destroyWindow
        
            typedef void ( ::CEGUI::WindowFactory::*destroyWindow_function_type )( ::CEGUI::Window * ) ;
            
            WindowFactory_exposer.def( 
                "destroyWindow"
                , bp::pure_virtual( destroyWindow_function_type(&::CEGUI::WindowFactory::destroyWindow) )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    Destroys the given Window object.\n\
            \n\
                @param window\n\
                    Pointer to the Window object to be destroyed.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::WindowFactory::getTypeName
        
            typedef ::CEGUI::String const & ( ::CEGUI::WindowFactory::*getTypeName_function_type )(  ) const;
            
            WindowFactory_exposer.def( 
                "getTypeName"
                , getTypeName_function_type( &::CEGUI::WindowFactory::getTypeName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the string that describes the type of Window object this\n\
                    WindowFactory produces.\n\
            \n\
                @return\n\
                    String object that contains the unique Window object type produced by\n\
                    this WindowFactory\n\
                *\n" );
        
        }
    }

}
