--
-- WORKER_RANGE_PARTITION
--

\set JobId 201010
\set TaskId 101101
\set Partition_Column l_orderkey
\set Partition_Column_Text '\'l_orderkey\''
\set Partition_Column_Type 20

\set Select_Query_Text '\'SELECT * FROM lineitem\''
\set Select_All 'SELECT *'

\set Table_Part_00 lineitem_range_part_00
\set Table_Part_01 lineitem_range_part_01
\set Table_Part_02 lineitem_range_part_02
\set Table_Part_03 lineitem_range_part_03

-- Run select query, and apply range partitioning on query results

SELECT worker_range_partition_table(:JobId, :TaskId, :Select_Query_Text,
       				    :Partition_Column_Text, :Partition_Column_Type,
				    ARRAY[1, 3000, 12000]::_int8);

-- Note that the following file names depend on job and task identifiers. We
-- prefer to substitute them here, but the current psql version does not perform
-- variable interpolation for names inside single quotes. This SQL interpolation
-- issue is fixed in PostgreSQL 9.0; and once we upgrade, we will change both
-- the following filenames, and the sequence names in the relay_sequence tests.

COPY :Table_Part_00 FROM 'base/pgsql_job_cache/job_201010/task_101101/p_00000';
COPY :Table_Part_01 FROM 'base/pgsql_job_cache/job_201010/task_101101/p_00001';
COPY :Table_Part_02 FROM 'base/pgsql_job_cache/job_201010/task_101101/p_00002';
COPY :Table_Part_03 FROM 'base/pgsql_job_cache/job_201010/task_101101/p_00003';

SELECT COUNT(*) FROM :Table_Part_00;
SELECT COUNT(*) FROM :Table_Part_03;

-- We first compute the difference of partition tables against the base table.
-- Then, we compute the difference of the base table against partitioned tables.

SELECT COUNT(*) AS diff_lhs_00 FROM (
       :Select_All FROM :Table_Part_00 EXCEPT ALL
       :Select_All FROM lineitem WHERE :Partition_Column < 1 ) diff;
SELECT COUNT(*) AS diff_lhs_01 FROM (
       :Select_All FROM :Table_Part_01 EXCEPT ALL
       :Select_All FROM lineitem WHERE :Partition_Column >= 1 AND
       		   		       :Partition_Column < 3000 ) diff;
SELECT COUNT(*) AS diff_lhs_02 FROM (
       :Select_All FROM :Table_Part_02 EXCEPT ALL
       :Select_All FROM lineitem WHERE :Partition_Column >= 3000 AND
       		   		       :Partition_Column < 12000 ) diff;
SELECT COUNT(*) AS diff_lhs_03 FROM (
       :Select_All FROM :Table_Part_03 EXCEPT ALL
       :Select_All FROM lineitem WHERE :Partition_Column >= 12000 ) diff;

SELECT COUNT(*) AS diff_rhs_00 FROM (
       :Select_All FROM lineitem WHERE :Partition_Column < 1 EXCEPT ALL
       :Select_All FROM :Table_Part_00 ) diff;
SELECT COUNT(*) AS diff_rhs_01 FROM (
       :Select_All FROM lineitem WHERE :Partition_Column >= 1 AND
       		   		       :Partition_Column < 3000 EXCEPT ALL
       :Select_All FROM :Table_Part_01 ) diff;
SELECT COUNT(*) AS diff_rhs_02 FROM (
       :Select_All FROM lineitem WHERE :Partition_Column >= 3000 AND
       		   		       :Partition_Column < 12000 EXCEPT ALL
       :Select_All FROM :Table_Part_02 ) diff;
SELECT COUNT(*) AS diff_rhs_03 FROM (
       :Select_All FROM lineitem WHERE :Partition_Column >= 12000 EXCEPT ALL
       :Select_All FROM :Table_Part_03 ) diff;
