/*
 * Copyright 2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codenarc.rule.exceptions

import org.codenarc.rule.AbstractAstVisitorRule
import org.codenarc.rule.AstVisitor

/**
 * Rule that checks for catching a IndexOutOfBoundsException
 *
 * @author Chris Mair
 * @version $Revision: 504 $ - $Date: 2011-01-04 22:12:18 -0500 (Tue, 04 Jan 2011) $
 */
class CatchIndexOutOfBoundsExceptionRule extends AbstractAstVisitorRule {
    String name = 'CatchIndexOutOfBoundsException'
    int priority = 2

    AstVisitor getAstVisitor() {
        new CommonCatchAstVisitor('IndexOutOfBoundsException')
    }
}
