/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.configuration.event;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.XMLConfiguration;

/**
 * Test class for events generated by XMLConfiguration.
 *
 * @version $Id: TestXMLConfigurationEvents.java 1225648 2011-12-29 20:55:07Z oheger $
 */
public class TestXMLConfigurationEvents extends
        AbstractTestFileConfigurationEvents
{
    static final File TEST_FILE = ConfigurationAssert.getTestFile("test.xml");

    @Override
    protected URL getSourceURL() throws IOException
    {
        return TEST_FILE.toURI().toURL();
    }

    @Override
    protected AbstractConfiguration createConfiguration()
    {
        return new XMLConfiguration();
    }
}
