package org.apache.commons.javaflow.bytecode.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.apache.commons.javaflow.bytecode.transformation.asm.AsmClassTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;


public abstract class AbstractTransformerTestCase extends TestCase {

    protected void assertSameTransformation( final String pClazzName ) throws IOException {
        final InputStream is = getStream(pClazzName);
        final ClassReader cr = new ClassReader(is);
        
        final AsmClassTransformer t1 = new AsmClassTransformer();
        final BcelClassTransformer t2 = new BcelClassTransformer();
        
        final byte[] bytecode = t1.transform(cr.b);
        CheckClassAdapter.verify(new ClassReader(bytecode), true);

        final StringWriter sw1 = new StringWriter();
        new ClassReader(bytecode).accept(new TraceClassVisitor(new PrintWriter(sw1)), false);

        final StringWriter sw2 = new StringWriter();
        new ClassReader(t2.transform(cr.b)).accept(new TraceClassVisitor(new PrintWriter(sw2)), false);
        
        assertEquals(sw2.toString(), sw1.toString());
    }
    
  protected void runTest() throws Throwable {
    try {
      super.runTest();
      
    } catch( Throwable e) {
        throw e;
    }
  }

  private InputStream getStream( String name) {
    return getClass().getResourceAsStream("/" + name.replace( '.', '/') + ".class");
  }

}
