package org.apache.commons.javaflow.bytecode.transformation.data;

import junit.framework.Assert;


/**
 * Test that allocates a lot of new objects. Javaflow performs some tricky
 * instrumentation on new object allocations, especially when it has arguments.
 * Nesting object allocations makes it even more interesting.
 * 
 * @author Kohsuke Kawaguchi
 */
public final class NewObject implements Runnable {
  static char[] ch = { 'a', 'b', 'c'};
  
  public void run() {

    String s = new String( new String( new String( ch, 0, ch.length).toCharArray(), 0, ch.length));
    // String s = new String( new String( ch).toCharArray());

    Assert.assertEquals( s, "abc");
  }

}

