package org.apache.commons.javaflow.bytecode.transformation.tests;

import org.apache.commons.javaflow.Continuation;
import org.apache.commons.javaflow.bytecode.transformation.AbstractTransformerTestCase;
import org.apache.commons.javaflow.bytecode.transformation.data.CounterFlow;

public abstract class AbstractCounterTestCase extends AbstractTransformerTestCase {

    public void testCounter() {
        final int count = 5;
        final Runnable r = new CounterFlow(count);
        int i = 0;
        Continuation c = Continuation.startWith(r);
        while (c != null) {
            c = Continuation.continueWith(c);
            i++;
        }
        assertTrue(i == count);
    }
}
