#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2009 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
#

from convirt.model import DBSession
from convirt.model.Entity import Entity,EntityTasks
from convirt.model.services import Task
from convirt.viewModel.TaskCreator import TaskCreator

from sqlalchemy.orm import eagerload

import convirt.core.utils.constants
constants = convirt.core.utils.constants

from datetime import datetime,timedelta
import traceback,transaction,tg
import time

class WorkManager:

    def __init__(self,auth):
        self.max_workers = 1
        self.worker = u"DefaultWorker"
        self.worker_ids = []
        self.available_workers = self.max_workers
        self.tc = TaskCreator()
        self.auth = auth
        self.start_time=datetime.utcnow()


    def get_work(self):
        raise Exception("get_work needs to be implemented.")

    def get_task(self):
        pass

    def workers_in_progress(self):
        return self.worker_ids


    def make_entity_task_entries(self, task_id, entity_ids):
        estimated_time=datetime.utcnow()+timedelta(minutes=int(tg.config.get("completion_time")))
        for ent_id in entity_ids:
            try:
                ###update the entity_tasks table
                ent_task=EntityTasks(self.worker,task_id,ent_id,False,datetime.utcnow(),estimated_time)
                DBSession.merge(ent_task)

            except Exception, e:
                traceback.print_exc()

            transaction.commit()


    def wait_for_workers_to_finish(self, task_ids, wait_time=None ):

        task_completed = False

        ###this is an infinite loop until we find a completed task
        ###we need to add some wait time to check on the status of child tasks
        while task_completed == False:
            time.sleep(5)
            completed_tasks = self.check_tasks_completed(task_ids)
            if len(completed_tasks) > 0:
                task_completed = True

                for task in completed_tasks:
                    self.worker_ids.remove(task['task_id'])

                    DBSession.query(EntityTasks).\
                        filter(EntityTasks.worker_id==task['task_id']).\
                        update(dict(finished=True, end_time=datetime.utcnow()))

                    transaction.commit()
                    

    def check_tasks_completed(self, task_ids):

        transaction.begin()
        tasks=DBSession.query(Task).filter(Task.task_id.in_(task_ids)).\
                                options(eagerload("result")).all()
        completed_tasks = []
        for task in tasks:
            if task.is_finished():
                completed_tasks.append(dict(task_id=task.task_id, status=task.result[0].status))
#            else:
#                self.handle_hanged_tasks(task)

        transaction.commit()
        return completed_tasks


    def do_work(self):
        (new_work, entity_ids) = self.get_work()
        wip = self.workers_in_progress()

        while new_work or wip:

            if new_work and len(wip) < self.max_workers:
                work_id = self.tc.submit_task(new_work)
                self.worker_ids.append(work_id)

                self.make_entity_task_entries(work_id, entity_ids)

            else:
                if len(wip) > 0:
                    self.wait_for_workers_to_finish(wip)

            (new_work, entity_ids) = self.get_work()
            wip = self.workers_in_progress()


    def resume_work(self,context):
        """
        on resume setting value from task context
        """
        execution_context=context["execution_context"]
        self.start_time=execution_context["start_time"]
        self.sp_list=execution_context["sp_list"]
        self.do_work()



