# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "coquelicot"
  s.version = "0.9.2"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["potager.org", "mh / immerda.ch"]
  s.date = "2013-04-21"
  s.description = "Coquelicot is a \"one-click\" file sharing web application with a\nfocus on protecting users' privacy.\n\nBasic principle: users can upload a file to the server, in return they\nget a unique URL which can be shared with others in order to download\nthe file.\n\nCoquelicot aims to protect, to some extent, users and system\nadministrators from disclosure of the files exchanged from passive and\nnot so active attackers.\n"
  s.email = ["jardiniers@potager.org"]
  s.executables = ["coquelicot"]
  s.files = ["Gemfile", "Gemfile.lock", "HACKING", "INSTALL", "LICENSE", "NEWS", "README", "Rakefile", "TODO", "bin/coquelicot", "conf/settings-default.yml", "conf/settings-imap.yml", "conf/settings-simplepass.yml", "coquelicot.gemspec", "lib/coquelicot.rb", "lib/coquelicot/app.rb", "lib/coquelicot/auth.rb", "lib/coquelicot/auth/imap.rb", "lib/coquelicot/auth/simplepass.rb", "lib/coquelicot/base_app.rb", "lib/coquelicot/depot.rb", "lib/coquelicot/helpers.rb", "lib/coquelicot/jyraphe_migrator.rb", "lib/coquelicot/num.rb", "lib/coquelicot/rack/multipart_parser.rb", "lib/coquelicot/rack/upload.rb", "lib/coquelicot/stored_file.rb", "lib/coquelicot/version.rb", "po/coquelicot.pot", "po/de/coquelicot.po", "po/fr/coquelicot.po", "public/images/ajax-loader.gif", "public/images/blank.gif", "public/images/overlay.png", "public/javascripts/coquelicot.auth.imap.js", "public/javascripts/coquelicot.auth.simplepass.js", "public/javascripts/coquelicot.js", "public/javascripts/jquery.lightBoxFu.js", "public/javascripts/jquery.uploadProgress.js", "public/stylesheets/lightbox-fu-ie6.css", "public/stylesheets/lightbox-fu-ie7.css", "spec/coquelicot/app_spec.rb", "spec/coquelicot/depot_spec.rb", "spec/coquelicot/jyraphe_migrator_spec.rb", "spec/coquelicot/rack/multipart_parser_spec.rb", "spec/coquelicot/rack/upload_spec.rb", "spec/coquelicot/stored_file_spec.rb", "spec/coquelicot_spec.rb", "spec/fixtures/LICENSE-secret-1.0/reference", "spec/fixtures/LICENSE-secret-1.0/stored_file", "spec/fixtures/LICENSE-secret-2.0/reference", "spec/fixtures/LICENSE-secret-2.0/stored_file", "spec/fixtures/LICENSE-secret-2.0/stored_file.content", "spec/fixtures/small-secret-1.0/reference", "spec/fixtures/small-secret-1.0/stored_file", "spec/spec_helper.rb", "views/about_your_data.haml", "views/auth/imap.haml", "views/auth/simplepass.haml", "views/download_in_progress.haml", "views/enter_file_key.haml", "views/error.haml", "views/expired.haml", "views/forbidden.haml", "views/index.haml", "views/layout.haml", "views/not_found.haml", "views/ready.haml", "views/style.sass", "lib/coquelicot/debian.rb", "public/javascripts/jquery.min.js"]
  s.homepage = "https://coquelicot.potager.org/"
  s.require_paths = ["lib"]
  s.rubygems_version = "1.8.23"
  s.summary = "\"one-click\" file sharing web application focusing on privacy"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<rake>, [">= 0"])
      s.add_development_dependency(%q<rspec>, ["~> 2.6"])
      s.add_development_dependency(%q<hpricot>, [">= 0"])
      s.add_development_dependency(%q<timecop>, [">= 0"])
      s.add_development_dependency(%q<rack-test>, [">= 0"])
      s.add_development_dependency(%q<capybara>, [">= 0"])
      s.add_development_dependency(%q<active_support>, [">= 0"])
      s.add_development_dependency(%q<gettext>, [">= 0"])
      s.add_runtime_dependency(%q<sinatra>, ["~> 1.3"])
      s.add_runtime_dependency(%q<sinatra-contrib>, ["~> 1.3"])
      s.add_runtime_dependency(%q<rack>, ["~> 1.1"])
      s.add_runtime_dependency(%q<haml>, ["~> 3.1"])
      s.add_runtime_dependency(%q<haml-magic-translations>, ["~> 0.3"])
      s.add_runtime_dependency(%q<sass>, [">= 0"])
      s.add_runtime_dependency(%q<maruku>, [">= 0"])
      s.add_runtime_dependency(%q<fast_gettext>, [">= 0"])
      s.add_runtime_dependency(%q<lockfile>, ["~> 2.0"])
      s.add_runtime_dependency(%q<json>, [">= 0"])
      s.add_runtime_dependency(%q<rainbows>, [">= 0"])
      s.add_runtime_dependency(%q<multipart-parser>, [">= 0"])
      s.add_runtime_dependency(%q<upr>, [">= 0"])
      s.add_runtime_dependency(%q<moneta>, ["~> 0.7"])
    else
      s.add_dependency(%q<rake>, [">= 0"])
      s.add_dependency(%q<rspec>, ["~> 2.6"])
      s.add_dependency(%q<hpricot>, [">= 0"])
      s.add_dependency(%q<timecop>, [">= 0"])
      s.add_dependency(%q<rack-test>, [">= 0"])
      s.add_dependency(%q<capybara>, [">= 0"])
      s.add_dependency(%q<active_support>, [">= 0"])
      s.add_dependency(%q<gettext>, [">= 0"])
      s.add_dependency(%q<sinatra>, ["~> 1.3"])
      s.add_dependency(%q<sinatra-contrib>, ["~> 1.3"])
      s.add_dependency(%q<rack>, ["~> 1.1"])
      s.add_dependency(%q<haml>, ["~> 3.1"])
      s.add_dependency(%q<haml-magic-translations>, ["~> 0.3"])
      s.add_dependency(%q<sass>, [">= 0"])
      s.add_dependency(%q<maruku>, [">= 0"])
      s.add_dependency(%q<fast_gettext>, [">= 0"])
      s.add_dependency(%q<lockfile>, ["~> 2.0"])
      s.add_dependency(%q<json>, [">= 0"])
      s.add_dependency(%q<rainbows>, [">= 0"])
      s.add_dependency(%q<multipart-parser>, [">= 0"])
      s.add_dependency(%q<upr>, [">= 0"])
      s.add_dependency(%q<moneta>, ["~> 0.7"])
    end
  else
    s.add_dependency(%q<rake>, [">= 0"])
    s.add_dependency(%q<rspec>, ["~> 2.6"])
    s.add_dependency(%q<hpricot>, [">= 0"])
    s.add_dependency(%q<timecop>, [">= 0"])
    s.add_dependency(%q<rack-test>, [">= 0"])
    s.add_dependency(%q<capybara>, [">= 0"])
    s.add_dependency(%q<active_support>, [">= 0"])
    s.add_dependency(%q<gettext>, [">= 0"])
    s.add_dependency(%q<sinatra>, ["~> 1.3"])
    s.add_dependency(%q<sinatra-contrib>, ["~> 1.3"])
    s.add_dependency(%q<rack>, ["~> 1.1"])
    s.add_dependency(%q<haml>, ["~> 3.1"])
    s.add_dependency(%q<haml-magic-translations>, ["~> 0.3"])
    s.add_dependency(%q<sass>, [">= 0"])
    s.add_dependency(%q<maruku>, [">= 0"])
    s.add_dependency(%q<fast_gettext>, [">= 0"])
    s.add_dependency(%q<lockfile>, ["~> 2.0"])
    s.add_dependency(%q<json>, [">= 0"])
    s.add_dependency(%q<rainbows>, [">= 0"])
    s.add_dependency(%q<multipart-parser>, [">= 0"])
    s.add_dependency(%q<upr>, [">= 0"])
    s.add_dependency(%q<moneta>, ["~> 0.7"])
  end
end
