/* $Id: cpl_image_io_body.h,v 1.53 2010/12/23 10:26:19 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* Type dependent macros */
#if defined CPL_CLASS && CPL_CLASS == CPL_CLASS_DOUBLE
#define CPL_TYPE            double
#define CPL_TYPE_T          CPL_TYPE_DOUBLE
#define CPL_CFITSIO_TYPE    TDOUBLE

#elif defined CPL_CLASS && CPL_CLASS == CPL_CLASS_FLOAT
#define CPL_TYPE            float
#define CPL_TYPE_T          CPL_TYPE_FLOAT
#define CPL_CFITSIO_TYPE    TFLOAT

#elif defined CPL_CLASS && CPL_CLASS == CPL_CLASS_INT
#define CPL_TYPE            int
#define CPL_TYPE_T          CPL_TYPE_INT
#define CPL_CFITSIO_TYPE    TINT

#elif defined CPL_CLASS && CPL_CLASS == CPL_CLASS_DOUBLE_COMPLEX
#define CPL_TYPE            double complex
#define CPL_TYPE_T          CPL_TYPE_DOUBLE_COMPLEX
/* NOTE: Saving unsupported */

#elif defined CPL_CLASS && CPL_CLASS == CPL_CLASS_FLOAT_COMPLEX
#define CPL_TYPE            float complex
#define CPL_TYPE_T          CPL_TYPE_FLOAT_COMPLEX
/* NOTE: Saving unsupported */

#else
#undef CPL_TYPE
#undef CPL_TYPE_T
#undef CPL_CFITSIO_TYPE
#endif

#if CPL_OPERATION == CPL_IMAGE_IO_GET
    case CPL_TYPE_T: {
        const CPL_TYPE * pi = (CPL_TYPE*)image->pixels;
        value = (double)pi[pos];
        break;
    }
#elif CPL_OPERATION == CPL_IMAGE_IO_SET
    case CPL_TYPE_T: {
        CPL_TYPE * pi = (CPL_TYPE*)image->pixels;
        pi[pos] = value;
        break;
    }
#elif CPL_OPERATION == CPL_IMAGE_IO_GET_PIXELS

    /* Test entries */
    cpl_ensure(img, CPL_ERROR_NULL_INPUT, NULL);
    cpl_ensure(img->type == CPL_TYPE_T, CPL_ERROR_TYPE_MISMATCH, NULL);

    return (CPL_CONST CPL_TYPE*)img->pixels;

#elif CPL_OPERATION == CPL_IMAGE_IO_SET_BADPIXEL

  case CPL_TYPE_T: {
      CPL_TYPE          *   pi;
      const CPL_TYPE        acast = (CPL_TYPE) a;
      int                   i; 
      pi = (CPL_TYPE*)im->pixels;
      for (i=0; i<im->nx*im->ny; i++) 
          if (pbpm[i] == CPL_BINARY_1) pi[i] = acast;
      break;
  }

#elif CPL_OPERATION == CPL_IMAGE_COMPLEX

    cpl_type        type, ctype;
    cpl_image     * out;

    cpl_ensure(image != NULL, CPL_ERROR_NULL_INPUT, NULL);

    ctype = cpl_image_get_type(image);
    cpl_ensure(ctype == CPL_TYPE_FLOAT_COMPLEX ||
           ctype == CPL_TYPE_DOUBLE_COMPLEX, CPL_ERROR_INVALID_TYPE, NULL);

    type = ctype == CPL_TYPE_FLOAT_COMPLEX ? CPL_TYPE_FLOAT : CPL_TYPE_DOUBLE;

    out = cpl_image_new(image -> nx, image -> ny, type);

    if (type == CPL_TYPE_FLOAT) {
    const float complex * fdata = 
        cpl_image_get_data_float_complex_const(image);
    float               * fout  = cpl_image_get_data_float(out);

    int i;
    
    for (i = 0; i < image->nx*image->ny; i++)
        fout[i] = CPL_COMPLEX_OPERATOR_F(fdata[i]);
    } else {
    const double complex * ddata =
        cpl_image_get_data_double_complex_const(image);
    double               * dout  = cpl_image_get_data_double(out);

    int i;

    for (i = 0; i < image->nx*image->ny; i++)
        dout[i] = CPL_COMPLEX_OPERATOR(ddata[i]);
    }

    return out;

#endif

#undef CPL_TYPE
#undef CPL_TYPE_T
#undef CPL_CFITSIO_TYPE
