
// Test library configuration for gnu.cfg
//
// Usage:
// $ cppcheck --check-library --library=gnu --enable=information --enable=style --error-exitcode=1 --suppress=missingIncludeSystem --inline-suppr test/cfg/gnu.c
// =>
// No warnings about bad library configuration, unmatched suppressions, etc. exitcode=0
//

#include <string.h>

void leakReturnValNotUsed() {
   // cppcheck-suppress unreadVariable
   char* ptr = (char*)strdupa("test");
   // cppcheck-suppress ignoredReturnValue
   strdupa("test");
   // cppcheck-suppress unreadVariable
   char* ptr2 = (char*)strndupa("test", 1);
   // cppcheck-suppress ignoredReturnValue
   strndupa("test", 1);
   // cppcheck-suppress ignoredReturnValue
   // cppcheck-suppress nullPointer
   strcasestr("test", NULL);
}
