/*  cssed (c) Iago Rubio 2003, 2004 - A tiny CSS editor.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/** @file cssedwindow.h
 *  @brief Header file for the cssed main window object. 
 *  Those functions are the interface for cssed's ::_CssedWindow object.
 */
 
/** a macro to cast a pointer to ::CssedWindow */
#define CSSED_WINDOW(n) (CssedWindow*) n

/** registry name for Windows */
#ifdef WIN32
#	define CSSED_REGISTRY_NAME "cssed-0.3.1"
#endif

/** error domain to be used on GError */
#define CSSED_ERROR_DOMAIN  g_quark_from_string ("CSSED_ERROR")

/** cssed related errors */
typedef enum {
	/** file error matches with  G_FILE_ERROR_EXIST */
	CSSED_FILE_ERROR_EXIST,
	/** file error matches with G_FILE_ERROR_ISDIR */
	CSSED_FILE_ERROR_ISDIR,
	/** file error matches with G_FILE_ERROR_ACCES */
	CSSED_FILE_ERROR_ACCES,
	/** file error matches with G_FILE_ERROR_NAMETOOLONG */
	CSSED_FILE_ERROR_NAMETOOLONG,
	/** file error matches with G_FILE_ERROR_NOENT */
	CSSED_FILE_ERROR_NOENT,
	/** file error matches with G_FILE_ERROR_NOTDIR */
	CSSED_FILE_ERROR_NOTDIR,
	/** file error matches with G_FILE_ERROR_NXIO */
	CSSED_FILE_ERROR_NXIO,
	/** file error matches with G_FILE_ERROR_NODEV */
	CSSED_FILE_ERROR_NODEV,
	/** file error matches with G_FILE_ERROR_ROFS */
	CSSED_FILE_ERROR_ROFS,
	/** file error matches with G_FILE_ERROR_TXTBSY */
	CSSED_FILE_ERROR_TXTBSY,
	/** file error matches with G_FILE_ERROR_FAULT */
	CSSED_FILE_ERROR_FAULT,
	/** file error matches with G_FILE_ERROR_LOOP */
	CSSED_FILE_ERROR_LOOP,
	/** file error matches with G_FILE_ERROR_NOSPC */
	CSSED_FILE_ERROR_NOSPC,
	/** file error matches with G_FILE_ERROR_NOMEM */
	CSSED_FILE_ERROR_NOMEM,
	/** file error matches with G_FILE_ERROR_MFILE */
	CSSED_FILE_ERROR_MFILE,
	/** file error matches with G_FILE_ERROR_NFILE */
	CSSED_FILE_ERROR_NFILE,
	/** file error matches with G_FILE_ERROR_BADF */
	CSSED_FILE_ERROR_BADF,
	/** file error matches with G_FILE_ERROR_INVAL */
	CSSED_FILE_ERROR_INVAL,
	/** file error matches with G_FILE_ERROR_PIPE */
	CSSED_FILE_ERROR_PIPE,
	/** file error matches with G_FILE_ERROR_AGAIN */
	CSSED_FILE_ERROR_AGAIN,
	/** file error matches with G_FILE_ERROR_INTR */
	CSSED_FILE_ERROR_INTR,
	/** file error matches with G_FILE_ERROR_IO */
	CSSED_FILE_ERROR_IO,
	/** file error matches with G_FILE_ERROR_PERM */
	CSSED_FILE_ERROR_PERM,
	/** file error matches with G_FILE_ERROR_FAILED */
	CSSED_FILE_ERROR_FAILED,
	/** this is not an error code it's just to know were the GFIleError matching ends */	
	CSSED_FILE_ERROR_LAST, 
	/**  the file is already opened onto cssed */
	CSSED_ERROR_FILE_IS_OPENED, 
	/**  the file is not a regular file, may be a device or whatever */
	CSSED_ERROR_FILE_NOT_REGULAR, //
	/** NULL document have been passed or returned for sure programming error */
	CSSED_ERROR_DOC_IS_NULL // 
} CssedError;

/** @enum CssedEolMode cssed's end of line modes */
typedef enum {
	/** Windows end of line Carriage return / Line feed */
	EOL_MODE_CRLF, 	
	/** Mac end of line Carriage return */
	EOL_MODE_CR,	
	/** Unix end of line Line feed */
	EOL_MODE_LF			
} CssedEolMode;

/** @enum CssedCodePage cssed's code pages */
typedef enum {
	/** Default code page */
	CSSED_CODEPAGE_DEFAULT,
	/** UTF8 code page */
	CSSED_CODEPAGE_UTF8,
	/** DBCS code page (Thai, Hangul) */
	CSSED_CODEPAGE_DBCS
} CssedCodePage;

// those are opaque use only provided functions
/** @struct _CssedDoc.  
 *  @brief This object implements a cssed document. This is opaque and should be accessed with the functions provided in document.h. I should not be used in plugins or extensions and exists only in the scope of the main cssed instance.
It is here only for compatibility with older code.
 */
/** @typedef CssedDoc.  
 *  @brief A utility data type for ::_CssedDoc structures.
 */
typedef struct _CssedDoc CssedDoc;
	
/** @struct _CssedWindow.  
 *  @brief This object represents the cssed main window object. This is opaque and should be accessed with the functions provided in cssedwindow.h
 */	
/** @typedef CssedWindow.  
 *  @brief A utility data type for ::_CssedWindow structures.
 */
typedef struct _CssedWindow CssedWindow;

/* *************************************************************************************************** */
#define CSSED_FILETYPE_DEFAULT CSSED_FILETYPE_TEXT

/** @enum CssedFileTypeId list of recogniced file type identifiers */
typedef enum {
	/** internall use, never use it. */
	CSSED_FILETYPE_UNKNOW,		
	/** The default file type, plain text */
	CSSED_FILETYPE_TEXT,		
	/** not used ,but will be link insertion */
	CSSED_FILETYPE_BYNARY,		
	/** core language */
	CSSED_FILETYPE_CSS,			
	/** this is not just HTML but hypertext and includes ASP, JSP and PHP */
	CSSED_FILETYPE_HTML,		
	/** This is standalon PHP not server side PHP (for sh-like scripts) */
	CSSED_FILETYPE_PHP,		
	/** XML and SVG */
	CSSED_FILETYPE_XML,	
	/** shell and bash scripts */
	CSSED_FILETYPE_SH,
	/** not just C but CPP */
	CSSED_FILETYPE_C,	
	/** apache conf files */
	CSSED_FILETYPE_APACHE_CONF,
	/** mostly for emacs.el files (not ready) */
	CSSED_FILETYPE_LISP,
	/** perl scripts */
	CSSED_FILETYPE_PERL,
	/** python */
	CSSED_FILETYPE_PYTHON,
	/**  SQL (Ansi) */
	CSSED_FILETYPE_SQL,
	/** diff and patch files */
	CSSED_FILETYPE_DIFF,
	/** java */
	CSSED_FILETYPE_JAVA,
	/** javascript */
	CSSED_FILETYPE_JS,	
	/** Makefiles */
	CSSED_FILETYPE_MAKE,
	/** APDL */
	CSSED_FILETYPE_APDL,
	/** AU3 */		
	CSSED_FILETYPE_AU3,
	/** AVE */
	CSSED_FILETYPE_AVE,
	/** ADA */
	CSSED_FILETYPE_ADA,
	/** Assembler */
	CSSED_FILETYPE_ASM,
	/** ASN1 */
	CSSED_FILETYPE_ASN1,
	/** BAAN */
	CSSED_FILETYPE_BAAN,
	/** BASIC */
	CSSED_FILETYPE_BASIC,
	/** BULLANT */
	CSSED_FILETYPE_BULLANT,
	/** CLW */
	CSSED_FILETYPE_CLW,
	/** CAML */
	CSSED_FILETYPE_CAML,
	/** CRONTAB */
	CSSED_FILETYPE_CRONTAB,
	/** ESCRIPT */
	CSSED_FILETYPE_ESCRIPT,
	/** EIFFEL */
	CSSED_FILETYPE_EIFFEL,
	/** ERLANG */
	CSSED_FILETYPE_ERLANG,
	/** FORTH */
	CSSED_FILETYPE_FORTH,
	/** FORTRAN */
	CSSED_FILETYPE_FORTRAN,
	/** GUI4CLI */
	CSSED_FILETYPE_GUI4CLI,
	/** KIX */
	CSSED_FILETYPE_KIX,
	/** LOUT */
	CSSED_FILETYPE_LOUT,
	/** LUA */
	CSSED_FILETYPE_LUA,
	/** MMIXAL */
	CSSED_FILETYPE_MMIXAL,
	/** MPT */
	CSSED_FILETYPE_MPT,
	/** MSSQL */
	CSSED_FILETYPE_MSSQL,
	/** MATLAB */
	CSSED_FILETYPE_MATLAB,
	/** METAPOST */
	CSSED_FILETYPE_METAPOST,
	/** NSIS */
	CSSED_FILETYPE_NSIS,
	/** PureBasic */
	CSSED_FILETYPE_PB,
	/** POV */
	CSSED_FILETYPE_POV,
	/** PS */
	CSSED_FILETYPE_PS,
	/** PASCAL */
	CSSED_FILETYPE_PASCAL,
	/** RUBY */
	CSSED_FILETYPE_RUBY,
	/** SCRIPTOL */
	CSSED_FILETYPE_SCRIPTOL,
	/** SPECMAN */
	CSSED_FILETYPE_SPECMAN,
	/** TEX */
	CSSED_FILETYPE_TEX,
	/** VisualBasic */
	CSSED_FILETYPE_VB,
	/** VHDL */
	CSSED_FILETYPE_VHDL,
	/** VERILOG */
	CSSED_FILETYPE_VERILOG,
	/** YAML */
	CSSED_FILETYPE_YAML,
	// if you miss something here, just request  for inclusion
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR,
	/** Empty slot for user defined languages */			// user defined file types
	CSSED_FILETYPE_USR1,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR2,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR3,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR4,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR5,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR6,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR7,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR8,
	/** Empty slot for user defined languages */
	CSSED_FILETYPE_USR9
} CssedFileTypeId;

#define	CSSED_NUMFILETYPES	(CSSED_FILETYPE_USR9+1)


