#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

. ./test_style.sh

# First, some basic stuff
ctioga -t 'Basic curve' 'sin(x)'
ctioga -N -t 'Several styles' 'sin(x)' 'cos(x)' 'tan(x)'

# Then, we try various styles:
ctioga -N -t 'Transparency and fills' \
    --fill y-axis --fill-transparency 0.6 'sin(x)' 'cos(x)'
ctioga -N -t 'Markers' \
    --marker auto 'sin(x)**2' 'cos(x)**2'
ctioga -N -t 'Dot clouds' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' '1 - x**2'

# Then, insets:

ctioga -N -t 'Inset (with title)' 'x**2' --inset .5,.5:.4 \
    -t 'Title inset' 'cos(x)'

