/* window.cxx
     $Id: window.cxx,v 1.8 2001/11/27 23:57:36 elf Exp $

   written by Marc Singer
   19 September 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

   Implementation of window and screen classes.

*/

#include "std.h"
#include <stdarg.h>
#include "window.h"


int LScreen::_color_of (int color)
{
  switch (color) {
  case colorBlack:
    return COLOR_BLACK;
  case colorRed:
    return COLOR_RED;
  case colorGreen:
    return COLOR_GREEN;
  case colorYellow:
    return COLOR_YELLOW;
  case colorBlue:
    return COLOR_BLUE;
  case colorMagenta:
    return COLOR_MAGENTA;
  case colorCyan:
    return COLOR_CYAN;
  case colorWhite:
    return COLOR_WHITE;
  default:
    return COLOR_BLACK;
  }
}

void LScreen::init (void)
{
  m_pWindowRoot = new LWindow (initscr ());
  start_color ();
  ESCDELAY = 50;
}


void LScreen::release_this (void)
{
  if (m_pWindowRoot) {
    delete m_pWindowRoot;
    m_pWindowRoot = NULL;
    endwin ();
  }
}


LWindow* LWindow::create_child (int x, int y, int dx, int dy)
{
  LWindow* pWindow;
  if (m_pWindowParent)
    pWindow = new LWindow (derwin (m_pWindow, dy, dx, y, x));
  else
    pWindow = new LWindow (newwin (dy, dx, y, x));
  scrollok (pWindow->m_pWindow, true);
  keypad (pWindow->m_pWindow, true);
  //  syncok (pWindow->m_pWindow, TRUE);
  pWindow->m_pWindowParent = this;
  return pWindow;
}


int LWindow::getstr (int x, int y, char* sz, int cch)
{
  moveto (x, y);
  return wgetnstr (m_pWindow, sz, cch);
}

void LWindow::init (WINDOW* pWindow)
{
  m_pWindow = pWindow;
}


void LWindow::printfxy (int x, int y, const char* szFormat, ...)
{
  va_list ap;
  va_start (ap, szFormat);

  moveto (x, y);
  vwprintw (m_pWindow, szFormat, ap);
  va_end (ap);

  touch (y);
}


void LWindow::release_this (void)
{
  if (m_pWindow) {
    delwin (m_pWindow);
    m_pWindow = NULL;
  }
}

void LWindow::touch (int y)
{
  if (m_pWindowParent) {
    int xParent, yParent;
    getparyx (m_pWindow, yParent, xParent);
    m_pWindowParent->touch (y + yParent);
  }
  else
    touchline (m_pWindow, y, 1);
}
