
#ifndef _SEARCHRESULT_H_
#define _SEARCHRESULT_H_

#include "global.h"
#include "log.h"
#include <QTextCodec>
#include <string>
#include <rpcdriver/types.h>

class SearchEntry {
public:
	SearchEntry(const std::string &file_as_in_dcpp,
				const QString& n,
				const QString& hName,
				int uId,
				int64 fSize,
				int uSlots,
				int fSlots,
				int t,
				const QString& tthIn,
			    bool isFileStringUTF8 = false) :
	file( file_as_in_dcpp ),
	nick( n ),
	hubName( hName ),
	userId( uId ),
	fileSize( fSize ),
	userSlots( uSlots ),
	freeSlots( fSlots ),
	type( static_cast<eType>( t ) ),
	tth( tthIn ),
	isUTF8( isFileStringUTF8 ),
	fileName(""),
	filePath("")
	{
		QTextCodec *codec;
		if (isUTF8)
			codec = QTextCodec::codecForName("utf-8");
		else
			codec = QTextCodec::codecForName("Windows-1252");

		// if can't find matching codec, fall back on default codec for C-strings
		if (!codec)
			codec = QTextCodec::codecForCStrings();

		QString fstr = codec->toUnicode( file.c_str() );

		// Check if this is a directory or a file.
		if( type == DIRECTORY ) {
			
			// Get the second last section, i.e. the part before the last '\'
			fileName = fstr.section( '\\', -2 );
		}
		else {
			
			// Get the last part of the path
			fileName = fstr.section('\\', -1);
		}
		
		filePath = fstr.left( fstr.lastIndexOf( fileName ) );
	
		logger->debug("SearchEntry() : file is \"%s\", fileName is \"%s\"", file.c_str(), fileName.toLatin1().constData());
	}

	virtual ~SearchEntry(){}

	enum eType
    {
        FILE,
        DIRECTORY
    };

	/*! Returns full path + filename string, in original encoding from dc++ */
	const std::string &getFile() const { return file; }

	/*! Returns unicode file name without path, only for use in the GUI */
	const QString& getFileName() const { return fileName; }

	/*! Returns unicode file path without file name, only for use in the GUI */
	const QString& getPath() const { return filePath; }
		
	/**
	 */
	const QString& getNick() const { return nick; }
	/**
	 */
	const QString& getHubName() const { return hubName; }
	/**
	 */
	int getUserId() const { return userId; }
	/**
	 */
	int64 getFileSize() const { return fileSize; }
	/**
	 */
	int getUserSlots() const { return userSlots; }
	/**
	 */
	int getFreeSlots() const { return freeSlots; }
	
	/**
	 */
	eType getType() const { return type; }
	
	/**
	*/
	const QString& getTTH() const { return tth; }

	/**
	Returns true if the string returned by getFile() has utf-8 encoding
	*/
	bool getUTF8() const { return isUTF8; }
	
	/**
	 */
	void setFileName( const QString& name ) { fileName = name; }
	/**
	 */
	void setFileName( const std::string& name ) { fileName = name.c_str(); }
	
	/**
	 */
	void setNick( const QString& n ) { nick = n; }
	/**
	 */
	void setNick( const std::string& n ) { nick = n.c_str(); }
	
	/**
	 */
	void setHubName( const QString& name ) { hubName = name; }
	/**
	 */
	void setHubName( const std::string& name ) { hubName = name.c_str(); }
	
	/**
	 */
	void setFileSize( int64 s ) { fileSize = s; }
	/**
	 */
	void setUserSlots( int u ) { userSlots = u; }
	/**
	 */
	void setFreeSlots( int f ) { freeSlots = f; }
	/**
	 */
	void setType( eType t ) { type = t; }
	
// 	SearchEntry& operator=(const SearchEntry& rhs)
// 	{
// 		if( this == &rhs )
// 			return *this;
// 		
// 		
// 		
// 		return *this;
// 	}

	static int sortElement;   //!< Defines the element to sort on. UGLY SHITCODE.
	enum {SORT_FILENAME,
	SORT_USER,
	SORT_SIZE,
	SORT_PATH,
	SORT_SLOTS,
	SORT_HUBNAME,
	SORT_TYPE,
	SORT_TTH};

bool operator < (const SearchEntry& s) const
{
    switch(sortElement)
    {
    case SORT_FILENAME:
		if(type != s.type) return s.type < type;
		return fileName < s.fileName;
    case SORT_USER:
		return nick < s.nick;
    case SORT_SIZE:
		return fileSize < s.fileSize;
    case SORT_PATH:
		return filePath < s.filePath;
    case SORT_SLOTS:
		return freeSlots < s.freeSlots;
    case SORT_HUBNAME:
		return hubName < s.hubName;
    case SORT_TYPE:
		return type < s.type;
    case SORT_TTH:
		return tth < s.tth;
    }
	return false;
}
private:

	/**
	Unmodified full path + filename string, as received from dc++
	*/
	std::string file;

	/**
	*/
	QString nick;
	/**
	 */
	QString hubName;
	/**
	 */
	int userId;
	/**
	 */
	int64 fileSize;
	/**
	 */
	int userSlots;
	/**
	 */
    int freeSlots;

	/**
	 */
    eType type;
	
	/**
	*/
	QString tth;

	/**
	True if the file string is originally encoded with utf-8
	*/
	bool isUTF8;

	/// Name of the file
	QString fileName;
	
	/// Path to the file on the remote users share 
	QString filePath;
};

#endif
