/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/invalid_argument.cpp
 *
 * @brief Exception in case of in invalid argument
 *
 *
 * $Id: invalid_argument.cpp 296 2007-11-27 00:21:41Z tautschn $
 *
 * @author Christian Schallhart <schallha@in.tum.de>
 * @date   Thu Nov 23 08:14:30 CET 2006
*/

#include <diagnostics/basic_exceptions/invalid_argument.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

Invalid_Argument::~Invalid_Argument() DIAGNOSTICS_EXCEPTIONS_THROW_DECL
{
}

Invalid_Argument::Invalid_Argument(Self const & other)
    : Super(other)
{
}

Invalid_Argument::Invalid_Argument(::std::string const & what)
    : Super(what)
{
}

char const * Invalid_Argument::name() const
{
    return "Invalid_Argument";
}

DIAGNOSTICS_NAMESPACE_END;

