/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/logging_facility.cpp
 *
 * $Id: logging_facility.cpp,v 1.8 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Implementation of @ref diagnostics::Logging_Facility
 */

#include <diagnostics/frame/logging_facility.hpp>

#include <diagnostics/frame/logging_implementation.hpp>
#include <diagnostics/frame/logging_mutex.hpp>

#include <diagnostics/util/to_string.hpp>

#include <iostream>

#include <exception>

DIAGNOSTICS_NAMESPACE_BEGIN;

void Logging_Facility::panic_log(::std::string const & what,
								 char const * const base_file_name,
								 char const * const file_name,
								 int const line) 
{
    INTERNAL_NAMESPACE::Logging_Implementation::panic_log
		(what,base_file_name,file_name,line);
}

void Logging_Facility::log(Level_t const level,
						   Type_t const type,
						   int const nr_what,
						   ::std::string const & str_what,
						   char const * const base_file_name,
						   char const * const file_name,
						   int const line) 
    try
{
    DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD(guard);
    if(DIAGNOSTICS_LOGGING_FACILITY_LOCK_IS_NESTED(guard)) {
		DIAGNOSTICS_PANIC_LOG_INTERNAL(::std::string("Recursive Lock: Logging_Facility::log()"));
		return;
    }
    INTERNAL_NAMESPACE::Logging_Implementation::instance()->log
		(level,type,nr_what,str_what,base_file_name,file_name,line);
}
catch(::std::exception & e)
{
    DIAGNOSTICS_PANIC_LOG_INTERNAL
		(::std::string("::std::exception during logging: Logging_Facility::log(): ")+e.what());
}
catch(...)
{
    DIAGNOSTICS_PANIC_LOG_INTERNAL(::std::string("Unexpected Exception during logging: Logging_Facility::log()"));
}


DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
