#include "meter.h"
#include <qpixmap.h>
#include <qpainter.h>
#include "mainwnd.h"
#include <qtimer.h>

#include "meter_bright.xpm"
#include "meter_dim.xpm"

Meter::Meter(QWidget *parent, const char *name, WFlags f) : QWidget(parent, name, f)
{
	meter_dim=new QPixmap((const char **)meter_dim_xpm);
	meter_bright=new QPixmap((const char **)meter_bright_xpm);
	peak=0.0;
	rms=0.0;
	curval=0.0;
	curpeak=0.0;
	peak_timer=new QTimer(this);
	rms_timer=new QTimer(this);
	connect(peak_timer, SIGNAL(timeout()), this, SLOT(clearPeak()));
	connect(rms_timer, SIGNAL(timeout()), this, SLOT(clearRms()));
}

Meter::~Meter()
{
	delete meter_dim;
	delete meter_bright;
}

void Meter::setValue(double val, double pk)
{
	curval=val;
	curpeak=pk;
}

void Meter::paintEvent(QPaintEvent *e)
{
	if(curpeak > peak)
	{
		peak=curpeak;
		peak_timer->start(1000, true);
	}
	if(curval > rms)
	{
		rms=curval;
		rms_timer->start(750, true);
	}

	QPainter p(this);

	Draw3dRect(&p, rect(), true, QColor(255, 255, 255), QColor(128, 128, 128));

	int divider=150-(int)(150.0*rms);
	if(divider < 0)
		divider=0;
	if(divider > 150)
		divider=150;

	int peakpos=150-(int)(150.0*peak);
	if(peakpos < 0)
		peakpos=0;
	if(peakpos > 150)
		peakpos=150;

	int curpk=150-(int)(150.0*curpeak);
	if(curpk < 0)
		curpk=0;
	if(curpk > 150)
		curpk=150;

	p.drawPixmap(2, 2, *meter_dim, 0, 0, 3, curpk);
	p.drawPixmap(2, curpk+2, *meter_bright, 0, curpk, 3, 150-curpk);

	p.drawPixmap(19, 2, *meter_dim, 17, 0, 3, curpk);
	p.drawPixmap(19, curpk+2, *meter_bright, 17, curpk, 3, 150-curpk);

	p.drawPixmap(5, 2, *meter_dim, 3, 0, 14, divider);
	p.drawPixmap(5, divider+2, *meter_bright, 3, divider, 14, 150-divider);

	if(peakpos != 150)
	{
		QPen pen(QColor(255, 255, 255));
		p.setPen(pen);
		p.moveTo(2, peakpos+2);
		p.lineTo(21, peakpos+2);
	}
}

void Meter::Draw3dRect( QPainter *p, const QRect &rcRect, bool bSunken, QColor crTop, QColor crBottom )
{
    QPen penLight(crTop);
    QPen penDark(crBottom);

    if(bSunken)
        p->setPen(penDark);
    else
        p->setPen(penLight);

    p->moveTo(rcRect.left(), rcRect.bottom()-1);
    p->lineTo(rcRect.left(), rcRect.top());
    p->lineTo(rcRect.right(), rcRect.top());

    if(bSunken)
        p->setPen(penLight);
    else
        p->setPen(penDark);

    p->moveTo(rcRect.right(), rcRect.top());
    p->lineTo(rcRect.right(), rcRect.bottom());
    p->lineTo(rcRect.left(), rcRect.bottom());

}

void Meter::clearPeak()
{
	peak=0.0;
}

void Meter::clearRms()
{
	rms=0.0;
}
