#ifndef _MP3_STREAM_SOURCE_H_INCLUDED
#define _MP3_STREAM_SOURCE_H_INCLUDED

#include "config.h"
#ifdef HAVE_LIBMAD

#include "jack.h"
#include <mad.h>
#include "mp3map.h"

class Mp3StreamSource : public StreamSource
{
Q_OBJECT

public:
	Mp3StreamSource(QWidget *owner);
	~Mp3StreamSource();

	int attach(QString name);
	int get_buffer(char *, int);
	int play(unsigned long start_frame, unsigned long samples, bool loop=false);
	int stop(void);
	void exit_loop(void);
	StreamSource *get_source(void);
	void setMap(Mp3Map *m);
	void generate_wave(void);
private:
	void read_synth_data(char *buf, int max);
	char pcm_buf[4800];
	void render_frame(int size);
	int fd;
	unsigned long file_pos;
	bool external_map;
	Mp3Map *map;
	struct mad_frame fr;
	struct mad_stream st;
	struct mad_synth sy;
	unsigned char *frame_buffer;
	int frames_buffered;
	int first_frame;
	int pcm_pos;
	int sample_offset;
	bool init;
};
#endif /* HAVE_LIBMAD */
#endif
