#ifndef _BITMAPBUTTON_H_INCLUDED
#define _BITMAPBUTTON_H_INCLUDED

#include <qwidget.h>
#include <qpushbutton.h>
#include <qpixmap.h>

class BitmapButton : public QPushButton
{
Q_OBJECT
Q_PROPERTY (bool lit READ lit WRITE setLit)
Q_PROPERTY (bool toggleLit READ toggleLit WRITE setToggleLit)
Q_PROPERTY (QPixmap upPixmap READ upPixmap WRITE setUpPixmap)
Q_PROPERTY (QPixmap downPixmap READ downPixmap WRITE setDownPixmap)
Q_PROPERTY (QPixmap upLitPixmap READ upLitPixmap WRITE setUpLitPixmap)
Q_PROPERTY (QPixmap downLitPixmap READ downLitPixmap WRITE setDownLitPixmap)

public:
	BitmapButton(QWidget *parent, const char *name=0);
	~BitmapButton();

	void setBitmaps(char **up, char **down, char **up_l=0, char **down_l=0);
public slots:
	void setUpPixmap(QPixmap& up);
	const QPixmap* upPixmap() const;
	void setDownPixmap(QPixmap& down);
	const QPixmap* downPixmap() const;
	void setUpLitPixmap(QPixmap& up_lit);
	const QPixmap* upLitPixmap() const;
	void setDownLitPixmap(QPixmap& down_lit);
	const QPixmap* downLitPixmap() const;
	void setLit(bool bLit=true);
	bool lit() const;
	void setToggleLit(bool on);
	bool toggleLit() const;

protected:
	QPixmap *pm_u;
	QPixmap *pm_d;
	QPixmap *pm_ul;
	QPixmap *pm_dl;
	bool m_bLit;
	bool m_bDown;
	bool m_bToggleLit;

	void paintEvent(QPaintEvent *ev);

protected slots:
	void btnPressed();
	void btnReleased();
};

#endif
