// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=fem, header=GenericDofMap.h)
%feature("docstring")  dolfin::GenericDofMap "
This class provides a generic interface for dof maps
";

%feature("docstring")  dolfin::GenericDofMap::GenericDofMap "
Constructor
";

%feature("docstring")  dolfin::GenericDofMap::is_view "
True if dof map is a view into another map (is a sub-dofmap)
";

%feature("docstring")  dolfin::GenericDofMap::global_dimension "
Return the dimension of the global finite element function
space
";

%feature("docstring")  dolfin::GenericDofMap::local_dimension "
Return number of owned (type=\"owned\"), unowned
(type=\"unowned\"), or all (type=\"all\") dofs in the map on this
process
";

%feature("docstring")  dolfin::GenericDofMap::cell_dimension "
Return the dimension of the local finite element function
space on a cell
";

%feature("docstring")  dolfin::GenericDofMap::max_cell_dimension "
Return the maximum dimension of the local finite element
function space
";

%feature("docstring")  dolfin::GenericDofMap::num_entity_dofs "
Return the number of dofs for a given entity dimension
";

%feature("docstring")  dolfin::GenericDofMap::geometric_dimension "
Return the geometric dimension of the coordinates this dof map
provides
";

%feature("docstring")  dolfin::GenericDofMap::num_facet_dofs "
Return number of facet dofs
";

%feature("docstring")  dolfin::GenericDofMap::ownership_range "
Return the ownership range (dofs in this range are owned by
this process)
";

%feature("docstring")  dolfin::GenericDofMap::off_process_owner "
Return map from nonlocal-dofs (that appear in local dof map)
to owning process
";

%feature("docstring")  dolfin::GenericDofMap::cell_dofs "
Local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_facet_dofs "
Tabulate local-local facet dofs
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_entity_dofs "
Tabulate the local-to-local mapping of dofs on entity
(dim, local_entity)
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_coordinates "
Tabulate the coordinates of all dofs on a cell (UFC cell version)
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_all_coordinates "
Tabulate the coordinates of all dofs owned by this
process. This function is typically used by preconditioners
that require the spatial coordinates of dofs, for example
for re-partitioning or nullspace computations. The format for
the return vector is [x0, y0, z0, x1, y1, z1, . . .].
";

%feature("docstring")  dolfin::GenericDofMap::copy "
Create a copy of the dof map
";

%feature("docstring")  dolfin::GenericDofMap::create "
Create a new dof map on new mesh
";

%feature("docstring")  dolfin::GenericDofMap::extract_sub_dofmap "
Extract sub dofmap component
";

%feature("docstring")  dolfin::GenericDofMap::collapse "
Create a \"collapsed\" a dofmap (collapses from a sub-dofmap view)
";

%feature("docstring")  dolfin::GenericDofMap::dofs "
Return list of global dof indices on this process
";

%feature("docstring")  dolfin::GenericDofMap::set "
Set dof entries in vector to a specified value. Parallel
layout of vector must be consistent with dof map range. This
function is typically used to construct the null space of a
matrix operator
";

%feature("docstring")  dolfin::GenericDofMap::set_x "
Set dof entries in vector to the value*x[i], where x[i] is the
spatial coordinate of the dof. Parallel layout of vector must
be consistent with dof map range. This function is typically
used to construct the null space of a matrix operator, e.g. rigid
body rotations.
";

%feature("docstring")  dolfin::GenericDofMap::local_to_global_unowned "
Return the map from unowned local dofmap nodes to global dofmap
nodes. Dofmap node is dof index modulo block size.
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_local_to_global_dofs "
Tabulate map between local (process) and global dof indices
";

%feature("docstring")  dolfin::GenericDofMap::local_to_global_index "
Return global dof index corresponding to a given local index
";

%feature("docstring")  dolfin::GenericDofMap::shared_nodes "
Return map from shared nodes to the processes (not including
the current process) that share it.
";

%feature("docstring")  dolfin::GenericDofMap::neighbours "
Return set of processes that share dofs with the this process
";

%feature("docstring")  dolfin::GenericDofMap::clear_sub_map_data "
Clear any data required to build sub-dofmaps (this is to
reduce memory use)
";

%feature("docstring")  dolfin::GenericDofMap::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=fem, header=DofMap.h)
%feature("docstring")  dolfin::DofMap "
This class handles the mapping of degrees of freedom. It builds
a dof map based on a ufc::dofmap on a specific mesh. It will
reorder the dofs when running in parallel. Sub-dofmaps, both
views and copies, are supported.
";

%feature("docstring")  dolfin::DofMap::DofMap "
**Overloaded versions**

* DofMap\ (ufc_dofmap, mesh)

  Create dof map on mesh (mesh is not stored)
  
  *Arguments*
      ufc_dofmap (ufc::dofmap)
          The ufc::dofmap.
      mesh (:py:class:`Mesh`)
          The mesh.

* DofMap\ (ufc_dofmap, mesh, constrained_domain)

  Create a periodic dof map on mesh (mesh is not stored)
  
  *Arguments*
      ufc_dofmap (ufc::dofmap)
          The ufc::dofmap.
      mesh (:py:class:`Mesh`)
          The mesh.
      constrained_boundary (:py:class:`SubDomain`)
          The subdomain marking the constrained (tied) boundaries.
";

%feature("docstring")  dolfin::DofMap::is_view "
True iff dof map is a view into another map

*Returns*
    bool
        True if the dof map is a sub-dof map (a view into
        another map).
";

%feature("docstring")  dolfin::DofMap::global_dimension "
Return the dimension of the global finite element function
space

*Returns*
    int
        The dimension of the global finite element function space.
";

%feature("docstring")  dolfin::DofMap::local_dimension "
Return number of owned, unowned, or all dofs in the dofmap on
this process

*Arguments*
    type (str)
        Either \"owned\", \"unowned\", or \"all\"

*Returns*
    int
        Number of local dofs.
";

%feature("docstring")  dolfin::DofMap::cell_dimension "
Return the dimension of the local finite element function
space on a cell

*Arguments*
    cell_index (int)
        Index of cell

*Returns*
    int
        Dimension of the local finite element function space.
";

%feature("docstring")  dolfin::DofMap::max_cell_dimension "
Return the maximum dimension of the local finite element
function space

*Returns*
    int
        Maximum dimension of the local finite element function
        space.
";

%feature("docstring")  dolfin::DofMap::num_entity_dofs "
Return the number of dofs for a given entity dimension

*Arguments*
    dim (int)
        Entity dimension

*Returns*
    int
        Number of dofs associated with given entity dimension
";

%feature("docstring")  dolfin::DofMap::geometric_dimension "
DEPRECATED
Return the geometric dimension of the coordinates this dof map
provides

*Returns*
    int
        The geometric dimension.
";

%feature("docstring")  dolfin::DofMap::num_facet_dofs "
Return number of facet dofs

*Returns*
    int
        The number of facet dofs.
";

%feature("docstring")  dolfin::DofMap::ownership_range "
Return the ownership range (dofs in this range are owned by
this process)

*Returns*
    (int, int)
        The ownership range.
";

%feature("docstring")  dolfin::DofMap::off_process_owner "
Return map from nonlocal dofs that appear in local dof map to
owning process

*Returns*
    numpy.array(int)
        The map from non-local dofs.
";

%feature("docstring")  dolfin::DofMap::shared_nodes "
Return map from all shared nodes to the sharing processes (not
including the current process) that share it.

*Returns*
    std::unordered_map<std::size_t, std::vector<unsigned int> >
        The map from dofs to list of processes
";

%feature("docstring")  dolfin::DofMap::neighbours "
Return set of processes that share dofs with this process

*Returns*
    set of int
        The set of processes
";

%feature("docstring")  dolfin::DofMap::clear_sub_map_data "
Clear any data required to build sub-dofmaps (this is to
reduce memory use)
";

%feature("docstring")  dolfin::DofMap::cell_dofs "
Local-to-global mapping of dofs on a cell

*Arguments*
    cell_index (int)
        The cell index.

*Returns*
    std::vector<dolfin::la_index>
        Local-to-global mapping of dofs.
";

%feature("docstring")  dolfin::DofMap::tabulate_facet_dofs "
Tabulate local-local facet dofs

*Arguments*
    dofs (int)
        Degrees of freedom.
    local_facet (int)
        The local facet.
";

%feature("docstring")  dolfin::DofMap::tabulate_entity_dofs "
Tabulate local-local mapping of dofs on entity (dim, local_entity)

*Arguments*
    dofs (int)
        Degrees of freedom.
    dim (int)
        The entity dimension
    local_entity (int)
        The local entity index
";

%feature("docstring")  dolfin::DofMap::tabulate_coordinates "
Tabulate the coordinates of all dofs on a cell (UFC cell
version)

*Arguments*
    coordinates (boost::multi_array<double, 2>)
        The coordinates of all dofs on a cell.
    vertex_coordinates (numpy.array(float))
        The cell vertex coordinates
    cell (Cell)
        The cell.
";

%feature("docstring")  dolfin::DofMap::tabulate_all_coordinates "
Tabulate the coordinates of all dofs on this process. This
function is typically used by preconditioners that require the
spatial coordinates of dofs, for example for re-partitioning or
nullspace computations.

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh.

*Returns*
    numpy.array(float)
        The dof coordinates (x0, y0, x1, y1, . . .)
";

%feature("docstring")  dolfin::DofMap::copy "
Create a copy of the dof map

*Returns*
    DofMap
        The Dofmap copy.
";

%feature("docstring")  dolfin::DofMap::create "
Create a copy of the dof map on a new mesh

*Arguments*
    new_mesh (:py:class:`Mesh`)
        The new mesh to create the dof map on.

*Returns*
    DofMap
        The new Dofmap copy.
";

%feature("docstring")  dolfin::DofMap::extract_sub_dofmap "
Extract subdofmap component

*Arguments*
    component (numpy.array(int))
        The component.
    mesh (:py:class:`Mesh`)
        The mesh.

*Returns*
    DofMap
        The subdofmap component.
";

%feature("docstring")  dolfin::DofMap::collapse "
Create a \"collapsed\" dofmap (collapses a sub-dofmap)

*Arguments*
    collapsed_map (std::unordered_map<std::size_t, std::size_t>)
        The \"collapsed\" map.
    mesh (:py:class:`Mesh`)
        The mesh.

*Returns*
    DofMap
        The collapsed dofmap.
";

%feature("docstring")  dolfin::DofMap::set "
Set dof entries in vector to a specified value. Parallel layout
of vector must be consistent with dof map range. This
function is typically used to construct the null space of a
matrix operator.

*Arguments*
    vector (:py:class:`GenericVector`)
        The vector to set.
    value (float)
        The value to set.
";

%feature("docstring")  dolfin::DofMap::set_x "
Set dof entries in vector to the x[i] coordinate of the dof
spatial coordinate. Parallel layout of vector must be consistent
with dof map range This function is typically used to
construct the null space of a matrix operator, e.g. rigid
body rotations.

*Arguments*
    vector (:py:class:`GenericVector`)
        The vector to set.
    value (float)
        The value to multiply to coordinate by.
    component (int)
        The coordinate index.
    mesh (:py:class:`Mesh`)
        The mesh.
";

%feature("docstring")  dolfin::DofMap::local_to_global_unowned "
Return the map from unowned local dofmap nodes to global dofmap
nodes. Dofmap node is dof index modulo block size.

*Returns*
    numpy.array(int)
        The unonwed local-to-global node map.
";

%feature("docstring")  dolfin::DofMap::tabulate_local_to_global_dofs "
Compute the map from local (this process) dof indices to
global dof indices.

*Arguments*
    local_to_global_map (numpy.array(int))
        The local-to-global map to fill.
";

%feature("docstring")  dolfin::DofMap::local_to_global_index "
Return global dof index for a given local (process) dof index

*Arguments*
    local_index (int)
        The local local index.

*Returns*
    int
        The global dof index.
";

%feature("docstring")  dolfin::DofMap::data "
Return the underlying dof map data. Intended for internal library
use only.

*Returns*
    std::vector<std::vector<dolfin::la_index> >
        The local-to-global map for each cell.
";

%feature("docstring")  dolfin::DofMap::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

// Documentation extracted from: (module=fem, header=fem_utils.h)
%feature("docstring")  dolfin::dof_to_vertex_map "
Return a map between dofs indices and vertex indices

Only works for FunctionSpace with dofs exclusively on vertices.
For MixedFunctionSpaces vertex index is offset with the number
of dofs per vertex. In parallel the returned map only maps local
(to processor) dofs.

*Arguments*
    space (:py:class:`FunctionSpace`)
        The FunctionSpace for what the dof to vertex map should be computed for

*Returns*
    numpy.array(int)
        The dof to vertex map
";

%feature("docstring")  dolfin::vertex_to_dof_map "
Return a map between vertex indices and dofs indices

Only works for FunctionSpace with dofs exclusively on vertices.
For MixedFunctionSpaces dof index is offset with the number of
dofs per vertex.

*Arguments*
    space (:py:class:`FunctionSpace`)
        The FunctionSpace for what the vertex to dof map should be computed for

*Returns*
    std::vector<dolfin::la_index>
        The vertex to dof map
";

// Documentation extracted from: (module=fem, header=Equation.h)
%feature("docstring")  dolfin::Equation "
This class represents a variational equation lhs == rhs.
The equation can be either linear or nonlinear:

1. Linear (a == L), in which case a must be a bilinear form
   and L must be a linear form.

2. Nonlinear (F == 0), in which case F must be a linear form.
";

%feature("docstring")  dolfin::Equation::Equation "
**Overloaded versions**

* Equation\ (a, L)

  Create equation a == L

* Equation\ (F, rhs)

  Create equation F == 0
";

%feature("docstring")  dolfin::Equation::is_linear "
Check whether equation is linear
";

%feature("docstring")  dolfin::Equation::lhs "
Return form for left-hand side
";

%feature("docstring")  dolfin::Equation::rhs "
Return form for right-hand side
";

%feature("docstring")  dolfin::Equation::rhs_int "
Return value for right-hand side
";

// Documentation extracted from: (module=fem, header=FiniteElement.h)
%feature("docstring")  dolfin::FiniteElement "
This is a wrapper for a UFC finite element (ufc::finite_element).
";

%feature("docstring")  dolfin::FiniteElement::FiniteElement "
Create finite element from UFC finite element (data may be shared)
";

%feature("docstring")  dolfin::FiniteElement::signature "
Return a string identifying the finite element
";

%feature("docstring")  dolfin::FiniteElement::cell_shape "
Return the cell shape
";

%feature("docstring")  dolfin::FiniteElement::space_dimension "
Return the dimension of the finite element function space
";

%feature("docstring")  dolfin::FiniteElement::value_rank "
Return the rank of the value space
";

%feature("docstring")  dolfin::FiniteElement::value_dimension "
Return the dimension of the value space for axis i
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis "
Evaluate basis function i at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_all "
Evaluate all basis functions at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_derivatives "
Evaluate order n derivatives of basis function i at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_derivatives_all "
Evaluate order n derivatives of all basis functions at given
point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_dof "
Evaluate linear functional for dof i on the function f
";

%feature("docstring")  dolfin::FiniteElement::evaluate_dofs "
Evaluate linear functionals for all dofs on the function f
";

%feature("docstring")  dolfin::FiniteElement::interpolate_vertex_values "
Interpolate vertex values from dof values
";

%feature("docstring")  dolfin::FiniteElement::map_from_reference_cell "
Map coordinate xhat from reference cell to coordinate x in cell
";

%feature("docstring")  dolfin::FiniteElement::map_to_reference_cell "
Map from coordinate x in cell to coordinate xhat in reference cell
";

%feature("docstring")  dolfin::FiniteElement::num_sub_elements "
Return the number of sub elements (for a mixed element)
";

%feature("docstring")  dolfin::FiniteElement::hash "
Return simple hash of the signature string
";

%feature("docstring")  dolfin::FiniteElement::create_sub_element "
Create a new finite element for sub element i (for a mixed element)
";

%feature("docstring")  dolfin::FiniteElement::create "
Create a new class instance
";

%feature("docstring")  dolfin::FiniteElement::extract_sub_element "
Extract sub finite element for component
";

%feature("docstring")  dolfin::FiniteElement::ufc_element "
Return underlying UFC element. Intended for libray usage only
and may change.
";

// Documentation extracted from: (module=fem, header=BasisFunction.h)
%feature("docstring")  dolfin::BasisFunction "
This class represents a finite element basis function. It can be
used for computation of basis function values and derivatives.

Evaluation of basis functions is also possible through the use
of the functions ``evaluate_basis`` and ``evaluate_basis_derivatives``
available in the :py:class:`FiniteElement` class. The BasisFunction class
relies on these functions for evaluation but also implements the
ufc::function interface which allows evaluate_dof to be
evaluated for a basis function (on a possibly different
element).
";

%feature("docstring")  dolfin::BasisFunction::BasisFunction "
Create basis function with given index on element on given cell

*Arguments*
    index (int)
        The index of the basis function.
    element (:py:class:`FiniteElement`)
        The element to create basis function on.
    cell (ufc::cell)
        The cell.
";

%feature("docstring")  dolfin::BasisFunction::eval "
Evaluate basis function at given point

*Arguments*
    values (float)
        The values of the function at the point.
    x (float)
        The coordinates of the point.
";

%feature("docstring")  dolfin::BasisFunction::eval_derivatives "
Evaluate all order n derivatives at given point

*Arguments*
    values (float)
        The values of derivatives at the point.
    x (float)
        The coordinates of the point.
    n (int)
        The order of derivation.
";

%feature("docstring")  dolfin::BasisFunction::evaluate "
Evaluate function at given point in cell

*Arguments*
    values (float)
        The values of the function at the point..
    coordinates (float)
        The coordinates of the point.
    cell (ufc::cell)
        The cell.
";

// Documentation extracted from: (module=fem, header=DirichletBC.h)
%feature("docstring")  dolfin::DirichletBC "
This class specifies the interface for setting (strong)
Dirichlet boundary conditions for partial differential
equations,

.. math::

    u = g \hbox{ on } G,

where :math:`u` is the solution to be computed, :math:`g` is a function
and :math:`G` is a sub domain of the mesh.

A DirichletBC is specified by the function g, the function space
(trial space) and boundary indicators on (a subset of) the mesh
boundary.

The boundary indicators may be specified in a number of
different ways.

The simplest approach is to specify the boundary by a :py:class:`SubDomain`
object, using the inside() function to specify on which facets
the boundary conditions should be applied. The boundary facets
will then be searched for and marked *only* on the first call to
apply. This means that the mesh could be moved after the first
apply and the boundary markers would still remain intact.

Alternatively, the boundary may be specified by a :py:class:`MeshFunction`
over facets labeling all mesh facets together with a number that
specifies which facets should be included in the boundary.

The third option is to attach the boundary information to the
mesh. This is handled automatically when exporting a mesh from
for example VMTK.

The 'method' variable may be used to specify the type of method
used to identify degrees of freedom on the boundary. Available
methods are: topological approach (default), geometric approach,
and pointwise approach. The topological approach is faster, but
will only identify degrees of freedom that are located on a
facet that is entirely on the boundary. In particular, the
topological approach will not identify degrees of freedom for
discontinuous elements (which are all internal to the cell). A
remedy for this is to use the geometric approach. In the
geometric approach, each dof on each facet that matches the
boundary condition will be checked. To apply pointwise boundary
conditions e.g. pointloads, one will have to use the pointwise
approach. The three possibilities are \"topological\", \"geometric\"
and \"pointwise\".

Note: when using \"pointwise\", the boolean argument `on_boundary`
in SubDomain::inside will always be false.

The 'check_midpoint' variable can be used to decide whether or
not the midpoint of each facet should be checked when a
user-defined :py:class:`SubDomain` is used to define the domain of the
boundary condition. By default, midpoints are always checked.
Note that this variable may be of importance close to corners,
in which case it is sometimes important to check the midpoint to
avoid including facets \"on the diagonal close\" to a corner. This
variable is also of importance for curved boundaries (like on a
sphere or cylinder), in which case it is important *not* to
check the midpoint which will be located in the interior of a
domain defined relative to a radius.
";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "
**Overloaded versions**

* DirichletBC\ (V, g, sub_domain, method=\"topological\", check_midpoint=true)

  Create boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (:py:class:`SubDomain`)
          The subdomain.
      method (str)
          Optional argument: A string specifying
          the method to identify dofs.

* DirichletBC\ (V, g, sub_domain, method=\"topological\", check_midpoint=true)

  Create boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space
      g (:py:class:`GenericFunction`)
          The value
      sub_domain (:py:class:`SubDomain`)
          The subdomain
      method (str)
          Optional argument: A string specifying
          the method to identify dofs

* DirichletBC\ (V, g, sub_domains, sub_domain, method=\"topological\")

  Create boundary condition for subdomain specified by index
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domains (:py:class:`MeshFunction`)
          Subdomain markers
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, sub_domains, sub_domain, method=\"topological\")

  Create boundary condition for subdomain specified by index
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domains (:py:class:`MeshFunction`)
          Subdomain markers
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, sub_domain, method=\"topological\")

  Create boundary condition for boundary data included in the mesh
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, sub_domain, method=\"topological\")

  Create boundary condition for boundary data included in the mesh
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, markers, method=\"topological\")

  Create boundary condition for subdomain by boundary markers
  (cells, local facet numbers)
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      markers (numpy.array(int))
          Subdomain markers (facet index local to process)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (bc)

  Copy constructor
  
  *Arguments*
      bc (:py:class:`DirichletBC`)
          The object to be copied.
";

%feature("docstring")  dolfin::DirichletBC::operator= "
Assignment operator

*Arguments*
    bc (:py:class:`DirichletBC`)
        Another DirichletBC object.
";

%feature("docstring")  dolfin::DirichletBC::apply "
**Overloaded versions**

* apply\ (A)

  Apply boundary condition to a matrix
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary condition to.

* apply\ (b)

  Apply boundary condition to a vector
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply boundary condition to.

* apply\ (A, b)

  Apply boundary condition to a linear system
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary condition to.
      b (:py:class:`GenericVector`)
          The vector to apply boundary condition to.

* apply\ (b, x)

  Apply boundary condition to vectors for a nonlinear problem
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply boundary conditions to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).

* apply\ (A, b, x)

  Apply boundary condition to a linear system for a nonlinear problem
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary conditions to.
      b (:py:class:`GenericVector`)
          The vector to apply boundary conditions to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).
";

%feature("docstring")  dolfin::DirichletBC::get_boundary_values "
Get Dirichlet dofs and values. If a method other than 'pointwise' is
used in parallel, the map may not be complete for local vertices since
a vertex can have a bc applied, but the partition might not have a
facet on the boundary. To ensure all local boundary dofs are marked,
it is necessary to call gather() on the returned boundary values.

*Arguments*
    boundary_values (std::unordered_map<std::size_t, double>)
        Map from dof to boundary value.
    method (str)
        Optional argument: A string specifying which
        method to use.
";

%feature("docstring")  dolfin::DirichletBC::gather "
Get boundary values from neighbour processes. If a method other than
\"pointwise\" is used, this is necessary to ensure all boundary dofs are
marked on all processes.

*Arguments*
    boundary_values (std::unordered_map<std::size_t, double>)
        Map from dof to boundary value.
";

%feature("docstring")  dolfin::DirichletBC::zero "
Make rows of matrix associated with boundary condition zero,
useful for non-diagonal matrices in a block matrix.

*Arguments*
    A (:py:class:`GenericMatrix`)
        The matrix
";

%feature("docstring")  dolfin::DirichletBC::zero_columns "
Make columns of matrix associated with boundary condition
zero, and update a (right-hand side) vector to reflect the
changes. Useful for non-diagonals.

*Arguments*
    A (:py:class:`GenericMatrix`)
        The matrix
    b (:py:class:`GenericVector`)
        The vector
    diag_val (float)
        This parameter would normally be -1, 0 or 1.
";

%feature("docstring")  dolfin::DirichletBC::markers "
Return boundary markers

*Returns*
    numpy.array((int, int))
        Boundary markers (facets stored as pairs of cells and
        local facet numbers).
";

%feature("docstring")  dolfin::DirichletBC::function_space "
Return function space V

*Returns*
    :py:class:`FunctionSpace`
        The function space to which boundary conditions are applied.
";

%feature("docstring")  dolfin::DirichletBC::value "
Return boundary value g

*Returns*
    :py:class:`GenericFunction`
        The boundary values.
";

%feature("docstring")  dolfin::DirichletBC::user_sub_domain "
Return shared pointer to subdomain

*Returns*
    :py:class:`SubDomain`
        Shared pointer to subdomain.
";

%feature("docstring")  dolfin::DirichletBC::is_compatible "
Check if given function is compatible with boundary condition
(checking only vertex values)

*Arguments*
    v (:py:class:`GenericFunction`)
        The function to check for compatibility
        with boundary condition.

*Returns*
    bool
        True if compatible.
";

%feature("docstring")  dolfin::DirichletBC::set_value "
**Overloaded versions**

* set_value\ (g)

  Set value g for boundary condition, domain remains unchanged
  
  *Arguments*
      g (:py:class:`GenericFunction`)
          The value.

* set_value\ (g)

  Set value g for boundary condition, domain remains unchanged
  
  *Arguments*
      g (:py:class:`GenericFunction`)
          The value.
";

%feature("docstring")  dolfin::DirichletBC::homogenize "
Set value to 0.0
";

%feature("docstring")  dolfin::DirichletBC::method "
Return method used for computing Dirichlet dofs

*Returns*
    str
        Method used for computing Dirichlet dofs (\"topological\",
        \"geometric\" or \"pointwise\").
";

%feature("docstring")  dolfin::DirichletBC::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=PointSource.h)
%feature("docstring")  dolfin::PointSource "
This class provides an easy mechanism for adding a point source
(Dirac delta function) to the right-hand side vector in a
variational problem. The associated function space must be
scalar in order for the inner product with the (scalar) Dirac
delta function to be well defined.
";

%feature("docstring")  dolfin::PointSource::PointSource "
**Overloaded versions**

* PointSource\ (V, p, magnitude=1.0)

  Create point source at given point of given magnitude

* PointSource\ (V, p, magnitude=1.0)

  Create point source at given point of given magnitude
";

%feature("docstring")  dolfin::PointSource::apply "
Apply (add) point source to right-hand side vector
";

// Documentation extracted from: (module=fem, header=assemble.h)
%feature("docstring")  dolfin::assemble "
**Overloaded versions**

* assemble\ (A, a)

  Assemble tensor

* assemble\ (a)

  Assemble scalar
";

%feature("docstring")  dolfin::assemble_system "
**Overloaded versions**

* assemble_system\ (A, b, a, L)

  Assemble system (A, b)

* assemble_system\ (A, b, a, L, bc)

  Assemble system (A, b) and apply Dirichlet boundary condition

* assemble_system\ (A, b, a, L, bcs)

  Assemble system (A, b) and apply Dirichlet boundary conditions

* assemble_system\ (A, b, a, L, bcs, x0)

  Assemble system (A, b) on sub domains and apply Dirichlet boundary
  conditions
";

// Documentation extracted from: (module=fem, header=LocalSolver.h)
%feature("docstring")  dolfin::LocalSolver::solve "
Solve local (cell-wise) problem and copy result into global
vector x.
";

// Documentation extracted from: (module=fem, header=solve.h)
%feature("docstring")  dolfin::solve "
**Overloaded versions**

* solve\ (equation, u, parameters=empty_parameters)

  Solve linear variational problem a(u, v) == L(v) or nonlinear
  variational problem F(u; v) = 0 without boundary conditions.
  
  Optional parameters can be passed to the LinearVariationalSolver
  or NonlinearVariationalSolver classes.

* solve\ (equation, u, bc, parameters=empty_parameters)

  Solve linear variational problem a(u, v) == L(v) or nonlinear
  variational problem F(u; v) = 0 with a single boundary condition.
  
  Optional parameters can be passed to the LinearVariationalSolver
  or NonlinearVariationalSolver classes.

* solve\ (equation, u, bcs, parameters=empty_parameters)

  Solve linear variational problem a(u, v) == L(v) or nonlinear
  variational problem F(u; v) = 0 with a list of boundary conditions.
  
  Optional parameters can be passed to the LinearVariationalSolver
  or NonlinearVariationalSolver classes.

* solve\ (equation, u, J, parameters=empty_parameters)

  Solve nonlinear variational problem F(u; v) == 0 without boundary
  conditions. The argument J should provide the Jacobian bilinear
  form J = dF/du.
  
  Optional parameters can be passed to the LinearVariationalSolver
  or NonlinearVariationalSolver classes.

* solve\ (equation, u, bc, J, parameters=empty_parameters)

  Solve nonlinear variational problem F(u; v) == 0 with a single
  boundary condition. The argument J should provide the Jacobian
  bilinear form J = dF/du.
  
  Optional parameters can be passed to the LinearVariationalSolver
  or NonlinearVariationalSolver classes.

* solve\ (equation, u, bcs, J, parameters=empty_parameters)

  Solve nonlinear variational problem F(u; v) == 0 with a list of
  boundary conditions. The argument J should provide the Jacobian
  bilinear form J = dF/du.
  
  Optional parameters can be passed to the LinearVariationalSolver
  or NonlinearVariationalSolver classes.
";

// Documentation extracted from: (module=fem, header=Form.h)
%feature("docstring")  dolfin::Form "
Base class for UFC code generated by FFC for DOLFIN with option -l.

A note on the order of trial and test spaces: FEniCS numbers
argument spaces starting with the leading dimension of the
corresponding tensor (matrix). In other words, the test space is
numbered 0 and the trial space is numbered 1. However, in order
to have a notation that agrees with most existing finite element
literature, in particular

    a = a(u, v)

the spaces are numbered from right to

    a: V_1 x V_0 -> R

.. note::

    Figure out how to write this in math mode without it getting
    messed up in the Python version.

This is reflected in the ordering of the spaces that should be
supplied to generated subclasses. In particular, when a bilinear
form is initialized, it should be initialized as

.. code-block:: c++

    a(V_1, V_0) = ...

where ``V_1`` is the trial space and ``V_0`` is the test space.
However, when a form is initialized by a list of argument spaces
(the variable ``function_spaces`` in the constructors below, the
list of spaces should start with space number 0 (the test space)
and then space number 1 (the trial space).
";

%feature("docstring")  dolfin::Form::Form "
**Overloaded versions**

* Form\ (rank, num_coefficients)

  Create form of given rank with given number of coefficients
  
  *Arguments*
      rank (int)
          The rank.
      num_coefficients (int)
          The number of coefficients.

* Form\ (ufc_form, function_spaces, coefficients)

  Create form (shared data)
  
  *Arguments*
      ufc_form (ufc::form)
          The UFC form.
      function_spaces (list of :py:class:`FunctionSpace`)
          Vector of function spaces.
      coefficients (list of :py:class:`GenericFunction`)
          Vector of coefficients.
";

%feature("docstring")  dolfin::Form::rank "
Return rank of form (bilinear form = 2, linear form = 1,
functional = 0, etc)

*Returns*
    int
        The rank of the form.
";

%feature("docstring")  dolfin::Form::num_coefficients "
Return number of coefficients

*Returns*
    int
        The number of coefficients.
";

%feature("docstring")  dolfin::Form::coloring "
Return coloring type for colored (multi-threaded) assembly of form
over a mesh entity of a given dimension

*Arguments*
    entity_dim (int)
        Dimension.

*Returns*
    numpy.array(int)
        Coloring type.
";

%feature("docstring")  dolfin::Form::set_mesh "
Set mesh, necessary for functionals when there are no function spaces

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh.
";

%feature("docstring")  dolfin::Form::mesh "
Extract common mesh from form

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::Form::mesh_shared_ptr "
Return mesh shared pointer (if any)

*Returns*
    :py:class:`Mesh`
        The mesh shared pointer.
";

%feature("docstring")  dolfin::Form::function_space "
Return function space for given argument

*Arguments*
    i (int)
        Index

*Returns*
    :py:class:`FunctionSpace`
        Function space shared pointer.
";

%feature("docstring")  dolfin::Form::function_spaces "
Return function spaces for arguments

*Returns*
    list of :py:class:`FunctionSpace`
        Vector of function space shared pointers.
";

%feature("docstring")  dolfin::Form::set_coefficient "
**Overloaded versions**

* set_coefficient\ (i, coefficient)

  Set coefficient with given number (shared pointer version)
  
  *Arguments*
      i (int)
          The given number.
      coefficient (:py:class:`GenericFunction`)
          The coefficient.

* set_coefficient\ (name, coefficient)

  Set coefficient with given name (shared pointer version)
  
  *Arguments*
      name (str)
          The name.
      coefficient (:py:class:`GenericFunction`)
          The coefficient.
";

%feature("docstring")  dolfin::Form::set_coefficients "
Set all coefficients in given map. All coefficients in the
given map, which may contain only a subset of the coefficients
of the form, will be set.

*Arguments*
    coefficients (:py:class:`GenericFunction`)
        The map of coefficients.
";

%feature("docstring")  dolfin::Form::set_some_coefficients "
Set some coefficients in given map. Each coefficient in the
given map will be set, if the name of the coefficient matches
the name of a coefficient in the form.

This is useful when reusing the same coefficient map for
several forms, or when some part of the form has been
outcommented (for testing) in the UFL file, which means that
the coefficient and attaching it to the form does not need to
be outcommented in a C++ program using code from the generated
UFL file.

*Arguments*
    coefficients (:py:class:`GenericFunction`)
        The map of coefficients.
";

%feature("docstring")  dolfin::Form::coefficient "
**Overloaded versions**

* coefficient\ (i)

  Return coefficient with given number
  
  *Arguments*
      i (int)
          Index
  
  *Returns*
      :py:class:`GenericFunction`
          The coefficient.

* coefficient\ (name)

  Return coefficient with given name
  
  *Arguments*
      name (str)
          The name.
  
  *Returns*
      :py:class:`GenericFunction`
          The coefficient.
";

%feature("docstring")  dolfin::Form::coefficients "
Return all coefficients

*Returns*
    list of :py:class:`GenericFunction`
        All coefficients.
";

%feature("docstring")  dolfin::Form::coefficient_number "
Return the number of the coefficient with this name

*Arguments*
    name (str)
        The name.

*Returns*
    int
        The number of the coefficient with the given name.
";

%feature("docstring")  dolfin::Form::coefficient_name "
Return the name of the coefficient with this number

*Arguments*
    i (int)
        The number

*Returns*
    str
        The name of the coefficient with the given number.
";

%feature("docstring")  dolfin::Form::cell_domains "
Return cell domains (zero pointer if no domains have been
specified)

*Returns*
    :py:class:`MeshFunction`
        The cell domains.
";

%feature("docstring")  dolfin::Form::exterior_facet_domains "
Return exterior facet domains (zero pointer if no domains have
been specified)

*Returns*
    :py:class:`MeshFunction`
        The exterior facet domains.
";

%feature("docstring")  dolfin::Form::interior_facet_domains "
Return interior facet domains (zero pointer if no domains have
been specified)

*Returns*
    :py:class:`MeshFunction`
        The interior facet domains.
";

%feature("docstring")  dolfin::Form::vertex_domains "
Return vertex domains (zero pointer if no domains have been
specified)

*Returns*
    :py:class:`MeshFunction`
        The vertex domains.
";

%feature("docstring")  dolfin::Form::set_cell_domains "
Set cell domains

*Arguments*
    cell_domains (:py:class:`MeshFunction`)
        The cell domains.
";

%feature("docstring")  dolfin::Form::set_exterior_facet_domains "
Set exterior facet domains

*Arguments*
    exterior_facet_domains (:py:class:`MeshFunction`)
        The exterior facet domains.
";

%feature("docstring")  dolfin::Form::set_interior_facet_domains "
Set interior facet domains

*Arguments*
    interior_facet_domains (:py:class:`MeshFunction`)
        The interior facet domains.
";

%feature("docstring")  dolfin::Form::set_vertex_domains "
Set vertex domains

*Arguments*
    vertex_domains (:py:class:`MeshFunction`)
        The vertex domains.
";

%feature("docstring")  dolfin::Form::ufc_form "
Return UFC form shared pointer

*Returns*
    ufc::form
        The UFC form.
";

%feature("docstring")  dolfin::Form::check "
Check function spaces and coefficients
";

%feature("docstring")  dolfin::Form::operator== "
**Overloaded versions**

* operator==\ (rhs)

  Comparison operator, returning equation lhs == rhs

* operator==\ (rhs)

  Comparison operator, returning equation lhs == 0
";

// Documentation extracted from: (module=fem, header=AssemblerBase.h)
%feature("docstring")  dolfin::AssemblerBase "
This class provides some common functions used in assembler
classes.
";

%feature("docstring")  dolfin::AssemblerBase::AssemblerBase "
Constructor
";

// Documentation extracted from: (module=fem, header=Assembler.h)
%feature("docstring")  dolfin::Assembler "
This class provides automated assembly of linear systems, or
more generally, assembly of a sparse tensor from a given
variational form.

Subdomains for cells and facets may be specified by assigning
subdomain indicators specified by :py:class:`MeshFunction` to the :py:class:`Form`
being assembled:

   .. code-block:: c++

       form.dx = cell_domains
       form.ds = exterior_facet_domains
       form.dS = interior_facet_domains
";

%feature("docstring")  dolfin::Assembler::Assembler "
Constructor
";

%feature("docstring")  dolfin::Assembler::assemble "
Assemble tensor from given form

*Arguments*
    A (:py:class:`GenericTensor`)
        The tensor to assemble.
    a (:py:class:`Form`)
        The form to assemble the tensor from.
";

%feature("docstring")  dolfin::Assembler::assemble_cells "
Assemble tensor from given form over cells. This function is
provided for users who wish to build a customized assembler.
";

%feature("docstring")  dolfin::Assembler::assemble_exterior_facets "
Assemble tensor from given form over exterior facets. This
function is provided for users who wish to build a customized
assembler.
";

%feature("docstring")  dolfin::Assembler::assemble_interior_facets "
Assemble tensor from given form over interior facets. This
function is provided for users who wish to build a customized
assembler.
";

%feature("docstring")  dolfin::Assembler::assemble_vertices "
Assemble tensor from given form over vertices. This function is
provided for users who wish to build a customized assembler.
";

// Documentation extracted from: (module=fem, header=SparsityPatternBuilder.h)
%feature("docstring")  dolfin::SparsityPatternBuilder "
This class provides functions to compute the sparsity pattern
based on DOF maps
";

%feature("docstring")  dolfin::SparsityPatternBuilder::build "
Build sparsity pattern for assembly of given form
";

%feature("docstring")  dolfin::SparsityPatternBuilder::build_multimesh_sparsity_pattern "
Build sparsity pattern for assembly of given multimesh form
";

%feature("docstring")  dolfin::SparsityPatternBuilder::_build_multimesh_sparsity_pattern_interface "
Build sparsity pattern for interface part of multimesh form
";

// Documentation extracted from: (module=fem, header=SystemAssembler.h)
%feature("docstring")  dolfin::SystemAssembler "
This class provides an assembler for systems of the form
Ax = b. It differs from the default DOLFIN assembler in that it
applies boundary conditions at the time of assembly, which
preserves any symmetries in A.
";

%feature("docstring")  dolfin::SystemAssembler::SystemAssembler "
**Overloaded versions**

* SystemAssembler\ (a, L)

  Constructor

* SystemAssembler\ (a, L, bc)

  Constructor

* SystemAssembler\ (a, L, bcs)

  Constructor

* SystemAssembler\ (a, L)

  Constructor

* SystemAssembler\ (a, L, bc)

  Constructor

* SystemAssembler\ (a, L, bcs)

  Constructor
";

%feature("docstring")  dolfin::SystemAssembler::assemble "
**Overloaded versions**

* assemble\ (A, b)

  Assemble system (A, b)

* assemble\ (A)

  Assemble matrix A

* assemble\ (b)

  Assemble vector b

* assemble\ (A, b, x0)

  Assemble system (A, b) for (negative) increment dx, where
  x = x0 - dx is solution to system a == -L subject to bcs.
  Suitable for use inside a (quasi-)Newton solver.

* assemble\ (b, x0)

  Assemble rhs vector b for (negative) increment dx, where
  x = x0 - dx is solution to system a == -L subject to bcs.
  Suitable for use inside a (quasi-)Newton solver.
";

// Documentation extracted from: (module=fem, header=LinearVariationalProblem.h)
%feature("docstring")  dolfin::LinearVariationalProblem "
This class represents a linear variational problem:

Find u in V such that

    a(u, v) = L(v)  for all v in V^,

where V is the trial space and V^ is the test space.
";

%feature("docstring")  dolfin::LinearVariationalProblem::LinearVariationalProblem "
**Overloaded versions**

* LinearVariationalProblem\ (a, L, u)

  Create linear variational problem without boundary conditions

* LinearVariationalProblem\ (a, L, u, bc)

  Create linear variational problem with a single boundary condition

* LinearVariationalProblem\ (a, L, u, bcs)

  Create linear variational problem with a list of boundary conditions

* LinearVariationalProblem\ (a, L, u, bcs)

  Create linear variational problem with a list of boundary conditions
  (shared pointer version)
";

%feature("docstring")  dolfin::LinearVariationalProblem::bilinear_form "
Return bilinear form
";

%feature("docstring")  dolfin::LinearVariationalProblem::linear_form "
Return linear form
";

%feature("docstring")  dolfin::LinearVariationalProblem::solution "
**Overloaded versions**

* solution\ ()

  Return solution variable

* solution\ ()

  Return solution variable (const version)
";

%feature("docstring")  dolfin::LinearVariationalProblem::bcs "
Return boundary conditions
";

%feature("docstring")  dolfin::LinearVariationalProblem::trial_space "
Return trial space
";

%feature("docstring")  dolfin::LinearVariationalProblem::test_space "
Return test space
";

// Documentation extracted from: (module=fem, header=LinearVariationalSolver.h)
%feature("docstring")  dolfin::LinearVariationalSolver "
This class implements a solver for linear variational problems.
";

%feature("docstring")  dolfin::LinearVariationalSolver::LinearVariationalSolver "
**Overloaded versions**

* LinearVariationalSolver\ (problem)

  Create linear variational solver for given problem

* LinearVariationalSolver\ (problem)

  Create linear variational solver for given problem (shared
  pointer version)
";

%feature("docstring")  dolfin::LinearVariationalSolver::solve "
Solve variational problem
";

%feature("docstring")  dolfin::LinearVariationalSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=NonlinearVariationalProblem.h)
%feature("docstring")  dolfin::NonlinearVariationalProblem "
This class represents a nonlinear variational problem:

Find u in V such that

    F(u; v) = 0  for all v in V^,

where V is the trial space and V^ is the test space.
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::NonlinearVariationalProblem "
**Overloaded versions**

* NonlinearVariationalProblem\ (F, u)

  Create nonlinear variational problem without boundary
  conditions.  The Jacobian form is not specified which requires
  the use of a nonlinear solver that does not rely on the
  Jacobian.

* NonlinearVariationalProblem\ (F, u, J)

  Create nonlinear variational problem without boundary
  conditions.  The Jacobian form is specified which allows the
  use of a nonlinear solver that relies on the Jacobian (using
  Newton's method).

* NonlinearVariationalProblem\ (F, u, bc)

  Create nonlinear variational problem with a single boundary
  condition.  The Jacobian form is not specified which requires
  the use of a nonlinear solver that does not rely on the
  Jacobian.

* NonlinearVariationalProblem\ (F, u, bc, J)

  Create nonlinear variational problem with a single boundary
  condition.  The Jacobian form is specified which allows the
  use of a nonlinear solver that relies on the Jacobian (using
  Newton's method).

* NonlinearVariationalProblem\ (F, u, bcs)

  Create nonlinear variational problem with a list of boundary
  conditions.  The Jacobian form is not specified which requires
  the use of a nonlinear solver that does not rely on the
  Jacobian.

* NonlinearVariationalProblem\ (F, u, bcs, J)

  Create nonlinear variational problem with a list of boundary
  conditions.  The Jacobian form is specified which allows the
  use of a nonlinear solver that relies on the Jacobian (using
  Newton's method).

* NonlinearVariationalProblem\ (F, u, bcs)

  Create nonlinear variational problem, shared pointer version.
  The Jacobian form is not specified which requires the use of a
  nonlinear solver that does not rely on the Jacobian.

* NonlinearVariationalProblem\ (F, u, bcs, J)

  Create nonlinear variational problem, shared pointer version.
  The Jacobian form is specified which allows the use of a
  nonlinear solver that relies on the Jacobian (using Newton's
  method).
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::set_bounds "
**Overloaded versions**

* set_bounds\ (lb, ub)

  Set the bounds for bound constrained solver

* set_bounds\ (lb, ub)

  Set the bounds for bound constrained solver

* set_bounds\ (lb_func, ub_func)

  Set the bounds for bound constrained solver

* set_bounds\ (lb_func, ub_func)

  Set the bounds for bound constrained solver
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::residual_form "
Return residual form
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::jacobian_form "
Return Jacobian form
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::solution "
**Overloaded versions**

* solution\ ()

  Return solution variable

* solution\ ()

  Return solution variable (const version)
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::bcs "
Return boundary conditions
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::trial_space "
Return trial space
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::test_space "
Return test space
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::lower_bound "
Return lower bound
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::upper_bound "
Return upper bound
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::has_jacobian "
Check whether Jacobian has been defined
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::has_lower_bound "
Check whether lower bound has been defined
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::has_upper_bound "
Check whether upper bound have has defined
";

// Documentation extracted from: (module=fem, header=NonlinearVariationalSolver.h)
%feature("docstring")  dolfin::NonlinearVariationalSolver "
This class implements a solver for nonlinear variational problems.
";

%feature("docstring")  dolfin::NonlinearVariationalSolver::NonlinearVariationalSolver "
**Overloaded versions**

* NonlinearVariationalSolver\ (problem)

  Create nonlinear variational solver for given problem

* NonlinearVariationalSolver\ (problem)

  Create nonlinear variational solver for given problem (shared
  pointer version)
";

%feature("docstring")  dolfin::NonlinearVariationalSolver::solve "
**Overloaded versions**

* solve\ (lb, ub)

  Solve variational problem with bound constraints defined by
  GenericVectors
  
  *Arguments*
      lb (:py:class:`GenericVector`)
          The linear solver.
      ub (:py:class:`GenericVector`)
          The factory.
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)

* solve\ (lb, ub)

  Solve variational problem with bound constraints defined by
  GenericVectors (shared pointer version)
  
  *Arguments*
      lb (_std::shared_ptr<const GenericVector>_)
          The linear solver.
      ub (_std::shared_ptr<const GenericVector>_)
          The factory.
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)

* solve\ (lb, ub)

  Solve variational problem with bound constraints defined by Functions
  
  *Arguments*
      lb (:py:class:`Function`)
          The linear solver.
      ub (:py:class:`Function`)
          The factory.
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)

* solve\ (lb, ub)

  Solve variational problem with bound constraints defined by
  Functions (shared pointer version)
  
  *Arguments*
      lb (_std::shared_ptr<const Function>_)
          The linear solver.
      ub (_std::shared_ptr<const Function>_)
          The factory.
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)

* solve\ ()

  Solve variational problem
  
  *Returns*
      (int, bool)
          Pair of number of Newton iterations, and whether
          iteration converged)
";

%feature("docstring")  dolfin::NonlinearVariationalSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=MultiMeshAssembler.h)
%feature("docstring")  dolfin::MultiMeshAssembler "
This class implements functionality for finite element assembly
over cut and composite finite element (MultiMesh) function spaces.
";

%feature("docstring")  dolfin::MultiMeshAssembler::MultiMeshAssembler "
Constructor
";

%feature("docstring")  dolfin::MultiMeshAssembler::assemble "
Assemble tensor from given form

*Arguments*
    A (:py:class:`GenericTensor`)
        The tensor to assemble.
    a (:py:class:`Form`)
        The form to assemble the tensor from.
";

// Documentation extracted from: (module=fem, header=MultiMeshDirichletBC.h)
%feature("docstring")  dolfin::MultiMeshDirichletBC "
This class is used to set Dirichlet boundary conditions for
multimesh function spaces.
";

%feature("docstring")  dolfin::MultiMeshDirichletBC::MultiMeshDirichletBC "
**Overloaded versions**

* MultiMeshDirichletBC\ (V, g, sub_domain, method=\"topological\", check_midpoint=true)

  Create boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`MultiMeshFunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (:py:class:`SubDomain`)
          The subdomain.
      method (str)
          Optional argument: A string specifying
          the method to identify dofs.

* MultiMeshDirichletBC\ (V, g, sub_domain, method=\"topological\", check_midpoint=true)

  Create boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`MultiMeshFunctionSpace`)
          The function space
      g (:py:class:`GenericFunction`)
          The value
      sub_domain (:py:class:`SubDomain`)
          The subdomain
      method (str)
          Optional argument: A string specifying
          the method to identify dofs
";

%feature("docstring")  dolfin::MultiMeshDirichletBC::apply "
**Overloaded versions**

* apply\ (A)

  Apply boundary condition to a matrix
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary condition to.

* apply\ (b)

  Apply boundary condition to a vector
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply boundary condition to.

* apply\ (A, b)

  Apply boundary condition to a linear system
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary condition to.
      b (:py:class:`GenericVector`)
          The vector to apply boundary condition to.

* apply\ (b, x)

  Apply boundary condition to vectors for a nonlinear problem
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply boundary conditions to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).

* apply\ (A, b, x)

  Apply boundary condition to a linear system for a nonlinear problem
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary conditions to.
      b (:py:class:`GenericVector`)
          The vector to apply boundary conditions to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).
";

// Documentation extracted from: (module=fem, header=MultiMeshDofMap.h)
%feature("docstring")  dolfin::MultiMeshDofMap "
This class handles the mapping of degrees of freedom for MultiMesh
function spaces.
";

%feature("docstring")  dolfin::MultiMeshDofMap::MultiMeshDofMap "
Constructor
";

%feature("docstring")  dolfin::MultiMeshDofMap::num_parts "
Return the number dofmaps (parts) of the MultiMesh dofmap

*Returns*
    int
        The number of dofmaps (parts) of the MultiMesh dofmap
";

%feature("docstring")  dolfin::MultiMeshDofMap::part "
Return dofmap (part) number i

*Returns*
    :py:class:`GenericDofMap`
        Dofmap (part) number i
";

%feature("docstring")  dolfin::MultiMeshDofMap::add "
**Overloaded versions**

* add\ (dofmap)

  Add dofmap (shared pointer version)
  
  *Arguments*
      dofmap (:py:class:`GenericDofMap`)
          The dofmap.

* add\ (dofmap)

  Add dofmap (reference version)
  
  *Arguments*
      dofmap (:py:class:`DofMap`)
          The dofmap.
";

%feature("docstring")  dolfin::MultiMeshDofMap::build "
Build MultiMesh dofmap
";

%feature("docstring")  dolfin::MultiMeshDofMap::clear "
Clear MultiMesh dofmap
";

%feature("docstring")  dolfin::MultiMeshDofMap::global_dimension "
Return the dimension of the global finite element function
space
";

%feature("docstring")  dolfin::MultiMeshDofMap::ownership_range "
Return the ownership range (dofs in this range are owned by
this process)
";

%feature("docstring")  dolfin::MultiMeshDofMap::off_process_owner "
Return map from nonlocal-dofs (that appear in local dof map)
to owning process
";

%feature("docstring")  dolfin::MultiMeshDofMap::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=fem, header=MultiMeshForm.h)
%feature("docstring")  dolfin::MultiMeshForm "
This class represents a variational form on a cut and composite
finite element function space (MultiMesh) defined on one or more
possibly intersecting meshes.
";

%feature("docstring")  dolfin::MultiMeshForm::MultiMeshForm "
**Overloaded versions**

* MultiMeshForm\ (multimesh)

  Create empty multimesh functional (shared pointer version)

* MultiMeshForm\ (multimesh)

  Create empty multimesh functional (reference version)

* MultiMeshForm\ (function_space)

  Create empty linear multimesh variational form (shared pointer version)

* MultiMeshForm\ (function_space)

  Create empty linear multimesh variational form (reference version)

* MultiMeshForm\ (function_space_0, function_space_1)

  Create empty bilinear multimesh variational form (shared pointer version)

* MultiMeshForm\ (function_space_0, function_space_1)

  Create empty bilinear multimesh variational form (reference version)
";

%feature("docstring")  dolfin::MultiMeshForm::rank "
Return rank of form (bilinear form = 2, linear form = 1,
functional = 0, etc)

*Returns*
    int
        The rank of the form.
";

%feature("docstring")  dolfin::MultiMeshForm::num_parts "
Return the number of forms (parts) of the MultiMesh form

*Returns*
    int
        The number of forms (parts) of the MultiMesh form.
";

%feature("docstring")  dolfin::MultiMeshForm::multimesh "
Extract common multimesh from form

*Returns*
    :py:class:`MultiMesh`
        The mesh.
";

%feature("docstring")  dolfin::MultiMeshForm::part "
Return form (part) number i

*Returns*
    :py:class:`Form`
        Form (part) number i.
";

%feature("docstring")  dolfin::MultiMeshForm::function_space "
Return function space for given argument

*Arguments*
    i (int)
        Index

*Returns*
    :py:class:`MultiMeshFunctionSpace`
        Function space shared pointer.
";

%feature("docstring")  dolfin::MultiMeshForm::add "
**Overloaded versions**

* add\ (form)

  Add form (shared pointer version)
  
  *Arguments*
      form (:py:class:`Form`)
          The form.

* add\ (form)

  Add form (reference version)
  
  *Arguments*
      form (:py:class:`Form`)
          The form.
";

%feature("docstring")  dolfin::MultiMeshForm::build "
Build MultiMesh form
";

%feature("docstring")  dolfin::MultiMeshForm::clear "
Clear MultiMesh form
";

// Documentation extracted from: (module=fem, header=OpenMpAssembler.h)
%feature("docstring")  dolfin::OpenMpAssembler "
This class provides automated assembly of linear systems, or
more generally, assembly of a sparse tensor from a given
variational form.

The MeshFunction arguments can be used to specify assembly over
subdomains of the mesh cells, exterior facets or interior
facets. Either a null pointer or an empty MeshFunction may be
used to specify that the tensor should be assembled over the
entire set of cells or facets.
";

%feature("docstring")  dolfin::OpenMpAssembler::OpenMpAssembler "
Constructor
";

%feature("docstring")  dolfin::OpenMpAssembler::assemble "
Assemble tensor from given form
";

