from re import compile

from dosage.helpers import BasicScraper, PHPScraper


class Bardsworth(BasicScraper):
    latestUrl = 'http://www.bardsworth.com/'
    imageUrl = 'http://www.bardsworth.com/archive/s%'
    imageSearch = compile(r'(/strips/.+?)"')
    prevSearch = compile(r'(/archive/.+?)">[^>].+?Prev')
    help = 'Index format: nnn'

class BetterDays(BasicScraper):
    latestUrl = 'http://www.jaynaylor.com/betterdays/'
    imageUrl = 'http://www.jaynaylor.com/betterdays/archives/%s'
    imageSearch = compile(r'<img src=(/betterdays/comic/.+?)>')
    prevSearch = compile(r'<a href="(.+)">&laquo; Previous')
    help = 'Index format: yyyy/mm/<your guess>.html'


class BetterYouThanMe(BasicScraper):
    latestUrl = 'http://betteryouthanme.net/'
    imageUrl = 'http://betteryouthanme.net/archive.php?date=%s.gif'
    imageSearch = compile(r'"(comics/.+?)"')
    prevSearch = compile(r'"(archive.php\?date=.+?)">.+?previous')
    help = 'Index format: yyyymmdd'


class BiggerThanCheeses(BasicScraper):
    latestUrl = 'http://www.biggercheese.com'
    imageUrl = 'http://www.biggercheese.com/index.php?comic=%s'
    imageSearch = compile(r'src="(comics/.+?)" alt')
    prevSearch = compile(r'"(index.php\?comic=.+?)".+?_back')
    help = 'Index format: n (unpadded)'


class BizarreUprising(BasicScraper):
    latestUrl = 'http://www.bizarreuprising.com/bu.php'
    imageUrl = 'http://www.bizarreuprising.com/bu.php?strip_id=%s'
    imageSearch = compile(r'<img src="(img/comics/bu/.+?)"')
    prevSearch = compile(r'<a href="(\?strip_id=\d+?)"><img src="img/nav/bu_prev.gif"')
    help = 'Index format: yymmdd'


class BrokenMirror(BasicScraper):
    latestUrl = 'http://www.the-broken-mirror.net/files/story/comic.php'
    imageUrl = 'http://www.the-broken-mirror.net/files/story/comic.php\?id=%s'
    imageSearch = compile(r'"(/files/story/.+?)"')
    prevSearch = compile(r'href="(comic.php\?id=.+?)">&lt;&lt;BACK')
    help = 'Index format: n'


class BonoboConspiracy(BasicScraper):
    latestUrl = 'http://ansuz.sooke.bc.ca/bonobo-conspiracy/'
    imageUrl = 'http://ansuz.sooke.bc.ca/bonobo-conspiracy/%s'
    imageSearch = compile(r'<P.+?<IMG SRC="(.+?)" ALT')
    prevSearch = compile(r'ansuz.+?/(\?i=.+?)".+?Previous')
    help = 'Index format: nnn'


class BoredAndEvil(BasicScraper):
    latestUrl = 'http://www.boredandevil.com/'
    imageUrl = 'http://www.boredandevil.com/archive.php?date=%s'
    imageSearch = compile(r'<img src="(strips/.+?)"')
    prevSearch = compile(r'First Comic.+<a href="(.+?)".+previous-on.gif')
    help = 'Index format: yyyy-mm-dd'


class BoyOnAStickAndSlither(BasicScraper):
    latestUrl = 'http://www.boasas.com/'
    imageUrl = 'http://www.boasas.com/?c=%s'
    imageSearch = compile(r'"(boasas/\d+\..+?)"')
    prevSearch = compile(r'<a href="(.*?)">.*?arrow_left')
    help = 'Index format: n (unpadded)'


class ButternutSquash(BasicScraper):
    latestUrl = 'http://www.butternutsquash.net/assets/pages/bns-current.html'
    imageUrl = 'http://www.butternutsquash.net/assets/pages/bns-comic%s.html'
    imageSearch = compile(r'<img src="(\.\./library/.+?)"')
    prevSearch = compile(r'<area shape="rect" coords="\d+,2\d,13\d,\d+" href="(bns-.+?\.html)" target="_self">')
    help = 'Index format: nn'


class Bhag(BasicScraper):
    basePath = 'http://bhag.sackofjustice.com/'
    latestUrl = ''
    prevSearch = compile(r'<a href="(http://bhag\.sackofjustice\.com/daily\.php\?date=\d{6})"><img src="http://bhag.sackofjustice.com/images/previous')


def blankLabel(name, baseUrl):
    return BasicScraper.make(
        name='BlankLabel/' + name,
        latestUrl=baseUrl,
        imageUrl='d/%s.html',
        imageSearch=compile(r'"(/comic[s|/].+?)"'),
        prevSearch=compile(r'(?:"([^"]*(?:/d/[^"\r\n]*)|(?:/strip/.+?))")(?:(?:.{43}starshift_back.gif)|(?:.+?cxn_previous)|(?:.{43}previous)|(?:[^<>]*>[^<>]*<[^<>]*previous)|(?:.*?back_button)|(?:.*?comicnav-previous))'),
        help='Index format: yyyymmdd')


checkerboardNightmare = blankLabel('CheckerboardNightmare', 'http://www.checkerboardnightmare.com/')
courtingDisaster = blankLabel('CourtingDisaster', 'http://www.courting-disaster.com/')
evilInc = blankLabel('EvilInc', 'http://www.evil-comic.com/')
greystoneInn = blankLabel('GreystoneInn', 'http://www.greystoneinn.net/')
itsWalky = blankLabel('ItsWalky', 'http://www.itswalky.com/')
# one strip name starts with %20
#krazyLarry = blankLabel('KrazyLarry', 'http://www.krazylarry.com/')
melonpool = blankLabel('Melonpool', 'http://www.melonpool.com/')
# strip names = index.php
#realLife = blankLabel('RealLife', 'http://www.reallifecomics.com/')
schlockMercenary = blankLabel('SchlockMercenary', 'http://www.schlockmercenary.com/')
# hosted on ComicsDotCom
#sheldon = blankLabel('Sheldon', 'http://www.sheldoncomics.com/')
shortpacked = blankLabel('Shortpacked', 'http://www.shortpacked.com/')
starslipCrisis = blankLabel('StarslipCrisis', 'http://www.starslipcrisis.com/')
uglyHill = blankLabel('UglyHill', 'http://www.uglyhill.com/')
wapsiSquare = blankLabel('WapsiSquare', 'http://www.wapsisquare.com/')
